/*
 * Decompiled with CFR 0.152.
 */
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.DropdownList;
import controlP5.Textfield;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.event.MouseEvent;
import processing.serial.Serial;

public class Kalibrierungssoftware
extends PApplet {
    Serial myPort;
    PImage SUSmobil;
    PImage LMT;
    PImage DBU;
    PImage UdS;
    PImage SFZSLS;
    PImage iPhysicsLab;
    ControlP5 cp5;
    DropdownList d1;
    ControlP5 anzahlKonzentrationen_;
    ControlP5 anzahlZyklen_;
    ControlP5 ppmProMl;
    ControlP5 Konzentration1;
    ControlP5 Konzentration2;
    ControlP5 Konzentration3;
    ControlP5 baudRate;
    String textValue = "";
    String portName;
    int serialListIndex;
    boolean startProgramm = false;
    boolean auswahl = false;
    boolean menu = true;
    boolean messung = false;
    boolean COM = false;
    boolean settings = false;
    int translation = 0;
    boolean Aufforderung = false;
    boolean erklaerung = true;
    boolean messungEinstellung = true;
    float ppmProMlWert = 10.0f;
    int baudrate = 9600;
    int Konzentration1Wert = 10;
    int Konzentration2Wert = 20;
    int Konzentration3Wert = 30;
    boolean erlaubnis = false;
    boolean MaxAktiv = false;
    boolean MinAktiv = false;
    boolean SteigAktiv = false;
    boolean MWAktiv = false;
    boolean unbekannteKonzentration = false;
    int GrenzeMaximumLinks = 6;
    int GrenzeMinimumLinks = 10;
    int GrenzeSteigungLinks = 14;
    int GrenzeMittelwertLinks = 18;
    boolean messungGestartet = false;
    float max = 0.0f;
    int anzahlKonzentrationen = 5;
    int aktuelleKonzentration = 0;
    int anzahlZyklen = 10;
    int aktuellerZyklus = 0;
    int aktuellerMesspunkt = 0;
    float[][] Durchschnitt = new float[this.anzahlKonzentrationen][50];
    float[][] Messdaten = new float[this.anzahlKonzentrationen * this.anzahlZyklen][50];
    float[][] UnbekannteKonzentrationMessdaten = new float[1][51];
    int UnbekannteKonzentrationZyklus = 0;
    boolean wait = true;
    float[] MerkmalMaximum = new float[this.anzahlKonzentrationen * this.anzahlZyklen];
    float[] MerkmalMinimum = new float[this.anzahlKonzentrationen * this.anzahlZyklen];
    float[] MerkmalSteigung = new float[this.anzahlKonzentrationen * this.anzahlZyklen];
    float[] MerkmalMittelwert = new float[this.anzahlKonzentrationen * this.anzahlZyklen];
    float MerkmalMaximumUnbekannt = 0.0f;
    float MerkmalMinimumUnbekannt = 1.0E9f;
    float MerkmalSteigungUnbekannt = 0.0f;
    float MerkmalMittelwertUnbekannt = 0.0f;
    int outputsAbstand = 10;
    int anzahlMerkmale = 0;
    boolean res = true;
    boolean tutor = false;
    int seiteTutorial = 0;
    float[] fakeZyklus = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 4.0f, 3.9f, 3.8f, 3.7f, 3.6f, 3.55f, 3.5f, 3.47f, 3.43f, 3.4f, 3.36f, 3.32f, 3.3f, 3.28f, 3.27f, 3.26f, 3.25f, 3.24f, 3.23f, 3.22f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 5.0f, 4.9f, 4.8f, 4.7f, 4.6f, 4.55f, 4.5f, 4.47f, 4.43f, 4.4f, 4.36f, 4.32f, 4.3f, 4.28f, 4.27f, 4.26f, 4.25f, 4.24f, 4.23f, 4.22f};
    float timerTutorial = 0.0f;
    boolean auswertung = false;
    float[] Outputs = new float[this.anzahlKonzentrationen * this.anzahlZyklen];

    public void setup() {
        this.SUSmobil = this.loadImage("img/SUSmobil.png");
        this.LMT = this.loadImage("img/LMT.png");
        this.UdS = this.loadImage("img/UdS.png");
        this.DBU = this.loadImage("img/DBU.png");
        this.iPhysicsLab = this.loadImage("img/iPhysicsLab.png");
        this.SFZSLS = this.loadImage("img/SFZSLS.png");
        this.surface.setIcon(this.SUSmobil);
        this.cp5 = new ControlP5((PApplet)this);
        PFont pfont = this.createFont("Arial", 10.0f, true);
        ControlFont font = new ControlFont(pfont, 20);
        this.d1 = (DropdownList)((DropdownList)((DropdownList)((DropdownList)((DropdownList)((DropdownList)this.cp5.addDropdownList("myList-d1").setPosition(400.0f, 170.0f)).setSize(100, 50)).setHeight(210)).setItemHeight(40).setBarHeight(50).setFont(font)).setColorBackground(this.color(60))).setColorActive(this.color(255, 128));
        this.d1.getCaptionLabel().set("PORT");
        this.d1.hide();
        this.anzahlKonzentrationen_ = new ControlP5((PApplet)this);
        ((Textfield)((Textfield)this.anzahlKonzentrationen_.addTextfield("").setPosition(400.0f, 80.0f)).setSize(100, 30).setFont(font)).setFocus(false).setColor(this.color(255));
        this.anzahlKonzentrationen_.hide();
        this.baudRate = new ControlP5((PApplet)this);
        ((Textfield)((Textfield)this.baudRate.addTextfield("").setPosition(650.0f, 180.0f)).setSize(100, 30).setFont(font)).setFocus(false).setColor(this.color(255));
        this.baudRate.hide();
        this.anzahlZyklen_ = new ControlP5((PApplet)this);
        ((Textfield)((Textfield)this.anzahlZyklen_.addTextfield("").setPosition(400.0f, 125.0f)).setSize(100, 30).setFont(font)).setFocus(false).setColor(this.color(255));
        this.anzahlZyklen_.hide();
        this.ppmProMl = new ControlP5((PApplet)this);
        ((Textfield)((Textfield)this.ppmProMl.addTextfield("").setPosition(400.0f, 150.0f)).setSize(100, 30).setFont(font)).setFocus(false).setColor(this.color(255));
        this.ppmProMl.hide();
        this.Konzentration1 = new ControlP5((PApplet)this);
        ((Textfield)((Textfield)this.Konzentration1.addTextfield("").setPosition(410.0f, 395.0f)).setSize(40, 30).setFont(font)).setFocus(false).setColor(this.color(255));
        this.Konzentration1.hide();
        this.Konzentration2 = new ControlP5((PApplet)this);
        ((Textfield)((Textfield)this.Konzentration2.addTextfield("").setPosition(410.0f, 445.0f)).setSize(40, 30).setFont(font)).setFocus(false).setColor(this.color(255));
        this.Konzentration2.hide();
        this.Konzentration3 = new ControlP5((PApplet)this);
        ((Textfield)((Textfield)this.Konzentration3.addTextfield("").setPosition(410.0f, 495.0f)).setSize(40, 30).setFont(font)).setFocus(false).setColor(this.color(255));
        this.Konzentration3.hide();
        if (Serial.list().length > 0) {
            this.portName = Serial.list()[0];
            this.myPort = new Serial((PApplet)this, this.portName, 9600);
            this.startProgramm = true;
        }
        int i = 0;
        while (i < this.anzahlKonzentrationen * this.anzahlZyklen) {
            int j = 0;
            while (j < 50) {
                this.Messdaten[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
    }

    public void draw() {
        if (this.startProgramm) {
            this.anzahlZyklen_.hide();
            this.anzahlKonzentrationen_.hide();
            this.baudRate.hide();
            int i = 0;
            while (i < this.anzahlKonzentrationen) {
                int j = 0;
                while (j < this.anzahlZyklen) {
                    if (i == 0) {
                        this.Outputs[j + this.anzahlZyklen * i] = 0.0f;
                    }
                    if (i == 1) {
                        this.Outputs[j + this.anzahlZyklen * i] = Float.isNaN(Kalibrierungssoftware.parseFloat((String)((Textfield)this.Konzentration1.get(Textfield.class, "")).getText().replace(',', '.'))) ? 10.0f : Kalibrierungssoftware.parseFloat((String)((Textfield)this.Konzentration1.get(Textfield.class, "")).getText().replace(',', '.'));
                    }
                    if (i == 2) {
                        this.Outputs[j + this.anzahlZyklen * i] = Float.isNaN(Kalibrierungssoftware.parseFloat((String)((Textfield)this.Konzentration2.get(Textfield.class, "")).getText().replace(',', '.'))) ? 20.0f : Kalibrierungssoftware.parseFloat((String)((Textfield)this.Konzentration2.get(Textfield.class, "")).getText().replace(',', '.'));
                    }
                    if (i == 3) {
                        this.Outputs[j + this.anzahlZyklen * i] = Float.isNaN(Kalibrierungssoftware.parseFloat((String)((Textfield)this.Konzentration3.get(Textfield.class, "")).getText().replace(',', '.'))) ? 30.0f : Kalibrierungssoftware.parseFloat((String)((Textfield)this.Konzentration3.get(Textfield.class, "")).getText().replace(',', '.'));
                    }
                    if (i == 4) {
                        this.Outputs[j + this.anzahlZyklen * i] = 40.0f;
                    }
                    ++j;
                }
                ++i;
            }
            this.anzahlKonzentrationen = Kalibrierungssoftware.parseInt((String)((Textfield)this.anzahlKonzentrationen_.get(Textfield.class, "")).getText()) <= 0 ? 5 : Kalibrierungssoftware.parseInt((String)((Textfield)this.anzahlKonzentrationen_.get(Textfield.class, "")).getText());
            this.anzahlZyklen = Kalibrierungssoftware.parseInt((String)((Textfield)this.anzahlZyklen_.get(Textfield.class, "")).getText()) <= 0 ? 10 : Kalibrierungssoftware.parseInt((String)((Textfield)this.anzahlZyklen_.get(Textfield.class, "")).getText());
            this.baudrate = Kalibrierungssoftware.parseInt((String)((Textfield)this.baudRate.get(Textfield.class, "")).getText()) <= 0 ? 9600 : Kalibrierungssoftware.parseInt((String)((Textfield)this.baudRate.get(Textfield.class, "")).getText());
            this.ppmProMlWert = Kalibrierungssoftware.parseFloat((String)((Textfield)this.ppmProMl.get(Textfield.class, "")).getText().replace(',', '.')) <= 0.0f ? 0.0f : Kalibrierungssoftware.parseFloat((String)((Textfield)this.ppmProMl.get(Textfield.class, "")).getText().replace(',', '.'));
            this.Konzentration1Wert = Kalibrierungssoftware.parseInt((String)((Textfield)this.Konzentration1.get(Textfield.class, "")).getText().replace(',', '.')) <= 0 ? 10 : Kalibrierungssoftware.parseInt((String)((Textfield)this.Konzentration1.get(Textfield.class, "")).getText().replace(',', '.'));
            this.Konzentration2Wert = Kalibrierungssoftware.parseInt((String)((Textfield)this.Konzentration2.get(Textfield.class, "")).getText().replace(',', '.')) <= 0 ? 20 : Kalibrierungssoftware.parseInt((String)((Textfield)this.Konzentration2.get(Textfield.class, "")).getText().replace(',', '.'));
            this.Konzentration3Wert = Kalibrierungssoftware.parseInt((String)((Textfield)this.Konzentration3.get(Textfield.class, "")).getText().replace(',', '.')) <= 0 ? 30 : Kalibrierungssoftware.parseInt((String)((Textfield)this.Konzentration3.get(Textfield.class, "")).getText().replace(',', '.'));
            if (this.translation < -190) {
                this.translation = -190;
            }
            if (this.translation > 1) {
                this.translation = 0;
            }
            this.background(255);
            this.translate(0.0f, this.translation);
            if (this.menu) {
                this.image(this.SUSmobil, 0.0f, 0.0f);
                this.image(this.LMT, 200.0f, 830.0f);
                this.image(this.SFZSLS, 350.0f, 830.0f);
                this.image(this.iPhysicsLab, 660.0f, 830.0f);
                this.d1.hide();
                this.homeScreen();
            } else if (this.messung) {
                i = 0;
                while (i < 1500) {
                    this.stroke(255 - 255 * i / 1500);
                    this.line(0.0f, i, this.width, i);
                    ++i;
                }
                if (this.messungEinstellung) {
                    this.KonzProMl();
                } else {
                    this.Koordinatenkreuz();
                    this.Messung();
                    this.NormalizeData();
                    this.DatenZeichnen();
                    this.Buttons();
                    if (this.aktuellerZyklus == this.anzahlZyklen) {
                        this.Zufrieden();
                    } else if (this.aktuelleKonzentration != this.anzahlKonzentrationen) {
                        this.Temperaturzyklus();
                    } else {
                        this.ErklaerungMerkmale();
                    }
                    if (this.auswertung) {
                        this.messungGestartet = false;
                        if (this.MaxAktiv) {
                            this.Maximum();
                        }
                        if (this.MinAktiv) {
                            this.Minimum();
                        }
                        if (this.SteigAktiv) {
                            this.Steigung();
                        }
                        if (this.MWAktiv) {
                            this.Mittelwert();
                        }
                    }
                    this.Speichern();
                }
            } else if (this.tutor) {
                this.tutorial();
            } else if (this.settings) {
                this.Einstellungen();
            }
            if (this.Konzentration1Wert >= this.Konzentration2Wert || this.Konzentration1Wert >= this.Konzentration3Wert || this.Konzentration2Wert >= this.Konzentration3Wert || this.ppmProMlWert <= 0.0f || this.Konzentration1Wert >= 40 || this.Konzentration2Wert >= 40 || this.Konzentration3Wert >= 40) {
                this.Fehlermeldung();
                this.erlaubnis = false;
            } else {
                this.erlaubnis = true;
            }
        } else {
            this.background(255);
            this.fill(0);
            this.textAlign(3);
            this.textSize(40.0f);
            this.text("Kein Mikrocontroller erkannt. \u00dcberpr\u00fcfe den\nAnschluss. Sobald ein Ger\u00e4t erkannt wurde,\nstartet das Programm automatisch neu.", 525.0f, 300.0f);
            if (Serial.list().length > 0) {
                this.portName = Serial.list()[0];
                this.myPort = new Serial((PApplet)this, this.portName, 9600);
                this.startProgramm = true;
                this.textAlign(0);
            }
        }
        if (Serial.list().length == 0) {
            this.startProgramm = false;
        }
    }

    public void controlEvent(ControlEvent theEvent) {
        this.myPort.clear();
        this.myPort.stop();
        if (theEvent.isController() && this.d1.isMouseOver()) {
            this.portName = Serial.list()[PApplet.parseInt((float)theEvent.getController().getValue())];
            this.myPort = new Serial((PApplet)this, this.portName, this.baudrate);
            Kalibrierungssoftware.println((String)("Serial index set to: " + theEvent.getController().getValue()));
            this.delay(2000);
        }
    }

    public void Fehlermeldung() {
        this.pushMatrix();
        this.fill(255);
        this.rect(270.0f, 600.0f, 440.0f, 70.0f);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.fill(255.0f, 0.0f, 0.0f);
        this.textSize(30.0f);
        this.text("\u00dcberpr\u00fcfe deine Angaben!", 300.0f, 650.0f);
        this.popMatrix();
        this.fill(0);
    }

    public void Maximum() {
        this.fill(0.0f, 0.0f, 255.0f, 100.0f);
        this.rect(250 + this.GrenzeMaximumLinks * 10, 50.0f, 60.0f, 350.0f);
    }

    public void Minimum() {
        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
        this.rect(250 + this.GrenzeMinimumLinks * 10, 50.0f, 60.0f, 350.0f);
    }

    public void Steigung() {
        this.fill(255.0f, 255.0f, 0.0f, 100.0f);
        this.rect(250 + this.GrenzeSteigungLinks * 10, 50.0f, 60.0f, 350.0f);
    }

    public void Mittelwert() {
        this.fill(0.0f, 255.0f, 0.0f, 100.0f);
        this.rect(250 + this.GrenzeMittelwertLinks * 10, 50.0f, 60.0f, 350.0f);
    }

    public void mouseDragged() {
        if (this.MaxAktiv && this.mouseX > 250 + this.GrenzeMaximumLinks * 10 && this.mouseX < 310 + this.GrenzeMaximumLinks * 10 && this.mouseY - this.translation > 50 && this.mouseY - this.translation < 400 && this.mouseX > 260 && this.mouseX < 720 && !this.unbekannteKonzentration) {
            this.GrenzeMaximumLinks = Kalibrierungssoftware.floor((float)((this.mouseX - 270) / 10));
        }
        if (this.MinAktiv && this.mouseX > 250 + this.GrenzeMinimumLinks * 10 && this.mouseX < 310 + this.GrenzeMinimumLinks * 10 && this.mouseY - this.translation > 50 && this.mouseY - this.translation < 400 && this.mouseX > 260 && this.mouseX < 720 && !this.unbekannteKonzentration) {
            this.GrenzeMinimumLinks = Kalibrierungssoftware.floor((float)((this.mouseX - 270) / 10));
        }
        if (this.SteigAktiv && this.mouseX > 250 + this.GrenzeSteigungLinks * 10 && this.mouseX < 310 + this.GrenzeSteigungLinks * 10 && this.mouseY - this.translation > 50 && this.mouseY - this.translation < 400 && this.mouseX > 280 && this.mouseX < 700 && !this.unbekannteKonzentration) {
            this.GrenzeSteigungLinks = Kalibrierungssoftware.floor((float)((this.mouseX - 270) / 10));
        }
        if (this.MWAktiv && this.mouseX > 250 + this.GrenzeMittelwertLinks * 10 && this.mouseX < 310 + this.GrenzeMittelwertLinks * 10 && this.mouseY - this.translation > 50 && this.mouseY - this.translation < 400 && this.mouseX > 260 && this.mouseX < 720 && !this.unbekannteKonzentration) {
            this.GrenzeMittelwertLinks = Kalibrierungssoftware.floor((float)((this.mouseX - 270) / 10));
        }
    }

    public void mouseWheel(MouseEvent event) {
        int e = event.getCount();
        if (this.translation < 1 && this.translation > -200) {
            this.translation -= 5 * e;
        }
    }

    public void mouseReleased() {
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 145 && this.mouseY - this.translation < 195 && this.messung && !this.unbekannteKonzentration && !this.erklaerung) {
            this.MaxAktiv = !this.MaxAktiv;
        }
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 220 && this.mouseY - this.translation < 270 && this.messung && !this.unbekannteKonzentration && !this.erklaerung) {
            this.MinAktiv = !this.MinAktiv;
        }
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 295 && this.mouseY - this.translation < 345 && this.messung && !this.unbekannteKonzentration && !this.erklaerung) {
            this.SteigAktiv = !this.SteigAktiv;
        }
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 370 && this.mouseY - this.translation < 420 && this.messung && !this.unbekannteKonzentration && !this.erklaerung) {
            this.MWAktiv = !this.MWAktiv;
        }
        if (this.aktuelleKonzentration == this.anzahlKonzentrationen && this.anzahlMerkmale == 2 && this.mouseX > 475 && this.mouseX < 575 && this.mouseY - this.translation > 900 && this.mouseY - this.translation < 950) {
            Kalibrierungssoftware.launch((String[])new String[]{"test.html"});
            this.unbekannteKonzentration = true;
            Kalibrierungssoftware.println((String)"HI");
        }
        if (this.mouseX > 400 && this.mouseX < 700 && this.mouseY - this.translation > 625 && this.mouseY - this.translation < 700 && this.menu && !this.tutor) {
            this.menu = false;
            this.messung = true;
            this.tutor = false;
            this.Konzentration1.show();
            this.Konzentration2.show();
            this.Konzentration3.show();
            this.ppmProMl.show();
        }
        if (this.mouseX > 400 && this.mouseX < 630 && this.mouseY > 700 && this.mouseY < 750 && this.messung && this.messungEinstellung && this.erlaubnis) {
            this.messungEinstellung = false;
            this.Konzentration1.hide();
            this.Konzentration2.hide();
            this.Konzentration3.hide();
            this.ppmProMl.hide();
        }
        if (this.mouseX > 815 && this.mouseX < 915 && this.mouseY - this.translation > 900 && this.mouseY - this.translation < 950 && !this.menu && this.messung) {
            this.menu = true;
            this.messung = false;
            this.tutor = false;
            this.settings = false;
            this.messungEinstellung = true;
        }
        if (this.mouseX > 400 && this.mouseX < 700 && this.mouseY - this.translation > 525 && this.mouseY - this.translation < 600 && this.menu && !this.messung) {
            this.tutor = true;
            this.messung = false;
            this.menu = false;
            this.settings = false;
        }
        if (this.messung && this.aktuellerZyklus == this.anzahlZyklen && this.mouseX > 350 && this.mouseX < 450 && this.mouseY - this.translation > 550 && this.mouseY - this.translation < 590) {
            if (this.aktuelleKonzentration != this.anzahlKonzentrationen - 1) {
                this.Aufforderung = true;
            } else {
                this.myPort.clear();
                this.wait = true;
                this.aktuellerZyklus = 0;
                this.Aufforderung = false;
                if (this.aktuelleKonzentration < this.anzahlKonzentrationen) {
                    ++this.aktuelleKonzentration;
                }
                if (this.aktuelleKonzentration == this.anzahlKonzentrationen) {
                    this.auswertung = true;
                }
            }
        }
        if (this.messung && this.Aufforderung && this.aktuellerZyklus == this.anzahlZyklen && this.mouseX > 350 && this.mouseX > 450 && this.mouseX < 550 && this.mouseY - this.translation > 600 && this.mouseY - this.translation < 640) {
            this.myPort.clear();
            this.wait = true;
            this.aktuellerZyklus = 0;
            this.Aufforderung = false;
            if (this.aktuelleKonzentration < this.anzahlKonzentrationen) {
                ++this.aktuelleKonzentration;
            }
            if (this.aktuelleKonzentration == this.anzahlKonzentrationen) {
                this.auswertung = true;
            }
        }
        if (this.messung && this.mouseX > 475 && this.mouseX < 625 && this.mouseY > 500 && this.mouseY < 550 && this.aktuelleKonzentration == this.anzahlKonzentrationen) {
            this.erklaerung = false;
        }
        if (this.mouseX > 400 && this.mouseX < 500 && this.mouseY < 350 && this.mouseY > 300 && this.settings) {
            this.aktuelleKonzentration = 0;
            this.aktuellerZyklus = 0;
            int i = 0;
            while (i < this.aktuelleKonzentration * this.anzahlZyklen + this.anzahlZyklen) {
                int j = 0;
                while (j < 50) {
                    this.Messdaten[i][j] = 0.0f;
                    ++j;
                }
                ++i;
            }
        }
        if (this.tutor) {
            if (this.mouseX > 900 && this.mouseX < 1000 && this.mouseY - this.translation > 800 && this.mouseY - this.translation < 850 && this.seiteTutorial < 13 && this.seiteTutorial != 12) {
                if (this.seiteTutorial == 9) {
                    this.MaxAktiv = true;
                    this.SteigAktiv = true;
                    this.MinAktiv = false;
                    this.MWAktiv = false;
                }
                ++this.seiteTutorial;
            }
            if (this.mouseX > 900 && this.mouseX < 1000 && this.mouseY - this.translation > 850 && this.mouseY - this.translation < 900 && this.seiteTutorial == 12) {
                ++this.seiteTutorial;
            }
            if (this.mouseX > 50 && this.mouseX < 150 && this.mouseY - this.translation > 800 && this.mouseY - this.translation < 850 && this.seiteTutorial > 0 && this.seiteTutorial != 12) {
                --this.seiteTutorial;
            }
            if (this.mouseX > 50 && this.mouseX < 150 && this.mouseY - this.translation > 850 && this.mouseY - this.translation < 900 && this.seiteTutorial > 0 && this.seiteTutorial == 12) {
                --this.seiteTutorial;
            }
            if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 225 && this.mouseY - this.translation < 275 && this.seiteTutorial == 1) {
                ++this.seiteTutorial;
            }
            if (this.mouseX > 450 && this.mouseX < 580 && this.mouseY - this.translation > 800 && this.mouseY - this.translation < 850 && this.seiteTutorial != 3) {
                this.tutor = false;
                this.menu = true;
                this.messung = false;
                this.seiteTutorial = 0;
                this.settings = false;
            }
            if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 205 && this.mouseY - this.translation < 265 && this.seiteTutorial == 9) {
                this.MaxAktiv = !this.MaxAktiv;
            }
            if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 280 && this.mouseY - this.translation < 330 && this.seiteTutorial == 9) {
                this.MinAktiv = !this.MinAktiv;
            }
            if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 355 && this.mouseY - this.translation < 415 && this.seiteTutorial == 9) {
                this.SteigAktiv = !this.SteigAktiv;
            }
            if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 430 && this.mouseY - this.translation < 480 && this.seiteTutorial == 9) {
                this.MWAktiv = !this.MWAktiv;
            }
        }
        if (this.mouseX > 400 && this.mouseX < 700 && this.mouseY - this.translation > 725 && this.mouseY - this.translation < 800 && this.menu) {
            this.settings = true;
            this.menu = false;
            this.tutor = false;
            this.messung = false;
        }
        if (this.mouseX > 400 && this.mouseX < 550 && this.mouseY > 400 && this.mouseY < 450 && this.settings) {
            this.menu = true;
            this.settings = false;
            this.tutor = false;
            this.messung = false;
        }
    }

    public void Buttons() {
        this.textSize(20.0f);
        this.text("Merkmale", 75.0f, 120.0f);
        this.strokeWeight(4.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 145 && this.mouseY - this.translation < 195) {
            this.fill(0.0f, 0.0f, 255.0f, 20.0f);
        } else {
            this.fill(100.0f, 100.0f, 255.0f, 220.0f);
        }
        if (this.MaxAktiv) {
            this.strokeWeight(4.0f);
            this.stroke(255);
        } else {
            this.strokeWeight(1.0f);
            this.stroke(0);
        }
        this.rect(75.0f, 145.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 220 && this.mouseY - this.translation < 270) {
            this.fill(255.0f, 100.0f, 100.0f, 20.0f);
        } else {
            this.fill(255.0f, 0.0f, 0.0f, 220.0f);
        }
        if (this.MinAktiv) {
            this.strokeWeight(4.0f);
            this.stroke(255);
        } else {
            this.strokeWeight(1.0f);
            this.stroke(0);
        }
        this.rect(75.0f, 220.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 295 && this.mouseY - this.translation < 345) {
            this.fill(255.0f, 255.0f, 0.0f, 20.0f);
        } else {
            this.fill(255.0f, 255.0f, 0.0f, 220.0f);
        }
        if (this.SteigAktiv) {
            this.strokeWeight(4.0f);
            this.stroke(255);
        } else {
            this.strokeWeight(1.0f);
            this.stroke(0);
        }
        this.rect(75.0f, 295.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 370 && this.mouseY - this.translation < 420) {
            this.fill(0.0f, 255.0f, 0.0f, 20.0f);
        } else {
            this.fill(0.0f, 255.0f, 0.0f, 220.0f);
        }
        if (this.MWAktiv) {
            this.strokeWeight(4.0f);
            this.stroke(255);
        } else {
            this.stroke(0);
            this.strokeWeight(1.0f);
        }
        this.rect(75.0f, 370.0f, 100.0f, 50.0f);
        this.strokeWeight(1.0f);
        this.stroke(0);
        if (this.mouseX > 815 && this.mouseX < 915 && this.mouseY - this.translation > 350 && this.mouseY - this.translation < 400 && this.aktuelleKonzentration != this.anzahlKonzentrationen) {
            this.fill(255);
            if (this.mousePressed) {
                this.aktuellerZyklus = 0;
                this.wait = true;
                this.myPort.clear();
                int i = this.aktuelleKonzentration * this.anzahlZyklen;
                while (i < this.aktuelleKonzentration * this.anzahlZyklen + this.anzahlZyklen) {
                    int j = 0;
                    while (j < 50) {
                        this.Messdaten[i][j] = 0.0f;
                        ++j;
                    }
                    ++i;
                }
            }
        } else {
            this.fill(220);
        }
        if (this.aktuelleKonzentration != this.anzahlKonzentrationen) {
            this.rect(815.0f, 350.0f, 100.0f, 50.0f);
        }
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 25 && this.mouseY - this.translation < 75) {
            this.fill(255);
            if (this.mousePressed && !this.messungGestartet) {
                this.messungGestartet = true;
                this.myPort.clear();
            }
        } else {
            this.fill(220);
        }
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.textSize(16.0f);
        this.text("Maximum", 87.0f, 175.0f);
        this.text("Minimum", 87.0f, 250.0f);
        this.text("Steigung", 90.0f, 325.0f);
        this.text("Mittelwert", 87.0f, 400.0f);
        this.text("Messung \n starten", 91.0f, 45.0f);
        if (this.aktuelleKonzentration != this.anzahlKonzentrationen) {
            this.text("  Messung\nwiederholen", 818.0f, 368.0f);
        }
        if (this.mouseX > 815 && this.mouseX < 915 && this.mouseY - this.translation > 900 && this.mouseY - this.translation < 950) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(815.0f, 900.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Hauptmenu", 820.0f, 930.0f);
    }

    public void Einstellungen() {
        this.pushMatrix();
        int i = 0;
        while (i < 1500) {
            this.stroke(255 - 255 * i / 1500);
            this.line(0.0f, i, this.width, i);
            ++i;
        }
        this.textSize(20.0f);
        this.fill(0);
        this.text("W\u00e4hle COM-Port:", 20.0f, 200.0f);
        this.text("Anzahl Konzentrationen:", 20.0f, 100.0f);
        this.anzahlZyklen_.show();
        this.text("Anzahl Zyklen pro Konzentration:", 20.0f, 150.0f);
        this.anzahlKonzentrationen_.show();
        this.text("Baudrate: ", 550.0f, 200.0f);
        this.text("(default: 9600)", 800.0f, 200.0f);
        this.baudRate.show();
        if (this.mouseX > 400 && this.mouseX < 550 && this.mouseY > 400 && this.mouseY < 450) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(400.0f, 400.0f, 150.0f, 50.0f);
        this.d1.show();
        this.fill(0);
        this.text("Hauptmen\u00fc", 420.0f, 430.0f);
        if (this.d1.isMouseOver()) {
            this.d1.clear();
            i = 0;
            while (i < Serial.list().length) {
                this.d1.addItem(Serial.list()[i], (Object)i);
                ++i;
            }
        }
        if (this.mouseX > 400 && this.mouseX < 500 && this.mouseY < 350 && this.mouseY > 300) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(400.0f, 300.0f, 100.0f, 50.0f);
        this.fill(0);
        this.textSize(25.0f);
        this.text("RESET", 415.0f, 333.0f);
        this.textSize(12.0f);
        this.text("Bei Fragen zum Programm, lesen Sie bitte zun\u00e4chst das 'readme.pdf'. Bei sonstigen Fragen oder Problemen, wenden Sie sich bitte an:", 20.0f, 620.0f);
        this.text("Sebastian H\u00f6fner\nLehrstuhl f\u00fcr Messtechnik\nFachrichtung Systems Engineering\nUniversit\u00e4t des Saarlandes\nTel.: +49 681 302-2235\nmail: s.hoefner@lmt.uni-saarland.de\n", 20.0f, 650.0f);
        this.popMatrix();
    }

    public void homeScreen() {
        this.pushMatrix();
        this.textSize(30.0f);
        this.fill(0);
        this.text("Modul 2a) - Kalibrierung eines Sensors", 250.0f, 480.0f);
        if (this.mouseX > 400 && this.mouseX < 700 && this.mouseY - this.translation > 525 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(400.0f, 525.0f, 300.0f, 75.0f);
        if (this.mouseX > 400 && this.mouseX < 700 && this.mouseY - this.translation > 625 && this.mouseY - this.translation < 700) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(400.0f, 625.0f, 300.0f, 75.0f);
        if (this.mouseX > 400 && this.mouseX < 700 && this.mouseY - this.translation > 725 && this.mouseY - this.translation < 800) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(400.0f, 725.0f, 300.0f, 75.0f);
        this.fill(0);
        this.text("Tutorial", 500.0f, 570.0f);
        this.text("Messung", 495.0f, 670.0f);
        this.text("Einstellungen", 455.0f, 770.0f);
        this.popMatrix();
    }

    public void Koordinatenkreuz() {
        this.fill(255);
        this.rect(250.0f, 50.0f, 500.0f, 350.0f);
        this.fill(0);
        this.stroke(0);
        int i = 0;
        while (i < 20) {
            this.stroke(200);
            this.line(250.0f, 17.5f * (float)i + 50.0f, 750.0f, 17.5f * (float)i + 50.0f);
            this.stroke(0);
            ++i;
        }
        i = 0;
        while (i < 26) {
            this.stroke(200);
            this.line(250 + 20 * i, 50.0f, 250 + 20 * i, 400.0f);
            this.stroke(0);
            ++i;
        }
        this.stroke(0);
        this.line(250.0f, 50.0f, 250.0f, 410.0f);
        this.line(245.0f, 55.0f, 250.0f, 50.0f);
        this.line(250.0f, 50.0f, 255.0f, 55.0f);
        this.line(240.0f, 400.0f, 760.0f, 400.0f);
        this.line(755.0f, 395.0f, 760.0f, 400.0f);
        this.line(760.0f, 400.0f, 755.0f, 405.0f);
        this.fill(0);
        this.text("0", 250.0f, 420.0f);
        this.text("25", 492.0f, 420.0f);
        this.text("50", 750.0f, 420.0f);
        this.text("Messpunkt (~Zeit)", 450.0f, 440.0f);
        this.text(Kalibrierungssoftware.nf((float)(this.max / 1000.0f), (int)0, (int)1), 200.0f, 50.0f);
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2);
        this.rotate(4.712389f);
        this.text("Widerstand [k\u03a9]", 250.0f, -this.width / 2 + 220);
        this.popMatrix();
    }

    public void NormalizeData() {
        this.max = 0.0f;
        int i = 0;
        while (i < this.anzahlKonzentrationen * this.anzahlZyklen) {
            int j = 0;
            while (j < 50) {
                if (this.Messdaten[i][j] > this.max) {
                    this.max = this.Messdaten[i][j];
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 51) {
            if (this.UnbekannteKonzentrationMessdaten[0][i] > this.max) {
                this.max = this.UnbekannteKonzentrationMessdaten[0][i];
            }
            ++i;
        }
    }

    public void DatenZeichnen() {
        int i;
        int j;
        int i2 = 0;
        while (i2 < this.anzahlKonzentrationen) {
            j = 0;
            while (j < 50) {
                this.Durchschnitt[i2][j] = 0.0f;
                ++j;
            }
            ++i2;
        }
        int k = 0;
        while (k < this.anzahlKonzentrationen) {
            i = 0;
            while (i < this.anzahlZyklen) {
                int j2 = 0;
                while (j2 < 50) {
                    float[] fArray = this.Durchschnitt[k];
                    int n = j2;
                    fArray[n] = fArray[n] + this.Messdaten[k * this.anzahlZyklen + i][j2];
                    ++j2;
                }
                ++i;
            }
            ++k;
        }
        i2 = 0;
        while (i2 < this.anzahlKonzentrationen) {
            j = 0;
            while (j < 50) {
                this.Durchschnitt[i2][j] = this.Durchschnitt[i2][j] / (float)this.anzahlZyklen;
                ++j;
            }
            ++i2;
        }
        this.textSize(14.0f);
        if (this.aktuelleKonzentration == 0) {
            this.fill(0);
            this.noStroke();
            this.strokeWeight(1.0f);
            this.text("0 ppm", 810.0f, 150.0f);
        } else if (this.aktuelleKonzentration == 1) {
            this.fill(0);
            this.noStroke();
            this.strokeWeight(1.0f);
            this.text(String.valueOf(this.Konzentration1Wert) + " ppm", 810.0f, 170.0f);
        } else if (this.aktuelleKonzentration == 2) {
            this.noStroke();
            this.strokeWeight(1.0f);
            this.text(String.valueOf(this.Konzentration2Wert) + " ppm", 810.0f, 190.0f);
        } else if (this.aktuelleKonzentration == 3) {
            this.noStroke();
            this.strokeWeight(1.0f);
            this.text(String.valueOf(this.Konzentration3Wert) + " ppm", 810.0f, 210.0f);
        } else if (this.aktuelleKonzentration == 4 && !this.unbekannteKonzentration) {
            this.noStroke();
            this.strokeWeight(1.0f);
            this.text("40 ppm", 810.0f, 230.0f);
        } else {
            this.noStroke();
            this.strokeWeight(1.0f);
            this.text("?? ppm", 810.0f, 250.0f);
        }
        int j3 = 0;
        while (j3 < this.aktuelleKonzentration) {
            i = 1;
            while (i < 50) {
                if (j3 == 0) {
                    this.fill(255.0f, 0.0f, 0.0f);
                    this.noStroke();
                    this.strokeWeight(1.0f);
                    this.text("0 ppm", 810.0f, 150.0f);
                    this.strokeWeight(2.0f);
                    this.stroke(255.0f, 0.0f, 0.0f);
                } else if (j3 == 1) {
                    this.fill(0.0f, 0.0f, 255.0f);
                    this.noStroke();
                    this.strokeWeight(1.0f);
                    this.text(String.valueOf(this.Konzentration1Wert) + " ppm", 810.0f, 170.0f);
                    this.strokeWeight(2.0f);
                    this.stroke(0.0f, 0.0f, 255.0f);
                } else if (j3 == 2) {
                    this.fill(0.0f, 200.0f, 0.0f);
                    this.noStroke();
                    this.strokeWeight(1.0f);
                    this.text(String.valueOf(this.Konzentration2Wert) + " ppm", 810.0f, 190.0f);
                    this.strokeWeight(2.0f);
                    this.stroke(0.0f, 200.0f, 0.0f);
                } else if (j3 == 3) {
                    this.fill(255.0f, 0.0f, 255.0f);
                    this.noStroke();
                    this.strokeWeight(1.0f);
                    this.text(String.valueOf(this.Konzentration3Wert) + " ppm", 810.0f, 210.0f);
                    this.strokeWeight(2.0f);
                    this.stroke(255.0f, 0.0f, 255.0f);
                } else if (j3 == 4) {
                    this.fill(255.0f, 255.0f, 0.0f);
                    this.noStroke();
                    this.strokeWeight(1.0f);
                    this.text("40 ppm", 810.0f, 230.0f);
                    this.strokeWeight(2.0f);
                    this.stroke(255.0f, 255.0f, 0.0f);
                }
                this.line(250 + 10 * i, 400.0f - 350.0f * this.Durchschnitt[j3][i] / this.max, 250 + 10 * (i - 1), 400.0f - 350.0f * this.Durchschnitt[j3][i - 1] / this.max);
                ++i;
            }
            ++j3;
        }
        this.strokeWeight(1.0f);
        i2 = this.aktuelleKonzentration * this.anzahlZyklen;
        while (i2 < this.aktuelleKonzentration * this.anzahlZyklen + this.aktuellerZyklus) {
            j = 1;
            while (j < 50) {
                this.stroke(100);
                this.line(250 + 10 * j, 400.0f - 350.0f * this.Messdaten[i2][j] / this.max, 250 + 10 * (j - 1), 400.0f - 350.0f * this.Messdaten[i2][j - 1] / this.max);
                ++j;
            }
            ++i2;
        }
        this.stroke(0);
        if (!this.unbekannteKonzentration) {
            i2 = 1;
            while (i2 < this.aktuellerMesspunkt) {
                this.line(250 + 10 * i2, 400.0f - 350.0f * this.Messdaten[this.aktuellerZyklus + this.aktuelleKonzentration * this.anzahlZyklen][i2] / this.max, 250 + 10 * (i2 - 1), 400.0f - 350.0f * this.Messdaten[this.aktuellerZyklus + this.aktuelleKonzentration * this.anzahlZyklen][i2 - 1] / this.max);
                ++i2;
            }
        }
        i2 = 1;
        while (i2 < 50) {
            this.line(250 + 10 * i2, 400.0f - 350.0f * this.UnbekannteKonzentrationMessdaten[0][i2] / this.max, 250 + 10 * (i2 - 1), 400.0f - 350.0f * this.UnbekannteKonzentrationMessdaten[0][i2 - 1] / this.max);
            ++i2;
        }
        this.noStroke();
        this.textSize(14.0f);
        this.fill(0);
        if (this.aktuellerZyklus + 1 < 0) {
            this.text("abgeschlossene Zyklen: 0/" + this.anzahlZyklen, 810.0f, 20.0f);
        } else if (this.aktuellerZyklus == -1) {
            this.text("abgeschlossene Zyklen: " + (this.aktuellerZyklus + 1) + "/" + this.anzahlZyklen, 810.0f, 20.0f);
        } else {
            this.text("abgeschlossene Zyklen: " + this.aktuellerZyklus + "/" + this.anzahlZyklen, 810.0f, 20.0f);
        }
        this.text("Anzahl Zyklen: " + this.anzahlZyklen, 810.0f, 60.0f);
        this.text("Anzahl Konzentrationen: " + this.anzahlKonzentrationen, 810.0f, 80.0f);
        if (this.wait && this.messungGestartet) {
            this.textSize(30.0f);
            this.text("Synchronisiere...", 410.0f, 30.0f);
            this.textSize(14.0f);
        } else {
            this.text("Messpunkt: " + this.aktuellerMesspunkt + "/50", 810.0f, 100.0f);
        }
        if (this.aktuelleKonzentration != this.anzahlKonzentrationen) {
            int conc = 0;
            if (this.aktuelleKonzentration == 0) {
                conc = 0;
            }
            if (this.aktuelleKonzentration == 1) {
                conc = this.Konzentration1Wert;
            }
            if (this.aktuelleKonzentration == 2) {
                conc = this.Konzentration2Wert;
            }
            if (this.aktuelleKonzentration == 3) {
                conc = this.Konzentration3Wert;
            }
            if (this.aktuelleKonzentration == 4) {
                conc = 40;
            }
            this.text("Konzentration: " + conc + " ppm", 810.0f, 40.0f);
        } else {
            this.anzahlMerkmale = 0;
            if (this.MaxAktiv) {
                ++this.anzahlMerkmale;
            }
            if (this.MinAktiv) {
                ++this.anzahlMerkmale;
            }
            if (this.SteigAktiv) {
                ++this.anzahlMerkmale;
            }
            if (this.MWAktiv) {
                ++this.anzahlMerkmale;
            }
            if (!this.unbekannteKonzentration) {
                this.fill(255);
                this.stroke(0);
                this.rect(800.0f, 330.0f, 240.0f, 110.0f);
                this.noStroke();
                this.fill(0);
                this.text("Anzahl ausgew\u00e4hlter Merkmale: " + this.anzahlMerkmale, 810.0f, 40.0f);
                if (this.anzahlMerkmale == 1) {
                    this.text("Du hast momentan " + this.anzahlMerkmale + " Merkmal\nausgew\u00e4hlt.", 810.0f, 350.0f);
                } else {
                    this.text("Du hast momentan " + this.anzahlMerkmale + " Merkmale\nausgew\u00e4hlt.", 810.0f, 350.0f);
                }
                if (this.anzahlMerkmale == 2) {
                    this.text("Wenn du zufrieden bist, klicke\nauf 'weiter'.", 810.0f, 400.0f);
                } else {
                    this.text("W\u00e4hle genau 2 Merkmale aus.", 810.0f, 400.0f);
                }
            }
        }
    }

    public void Temperaturzyklus() {
        this.pushMatrix();
        this.fill(255);
        this.noStroke();
        this.rect(250.0f, 500.0f, 500.0f, 350.0f);
        this.noFill();
        int i = 0;
        while (i < 20) {
            this.stroke(200);
            this.line(250.0f, 17.5f * (float)i + 500.0f, 750.0f, 17.5f * (float)i + 500.0f);
            this.stroke(0);
            ++i;
        }
        i = 0;
        while (i < 26) {
            this.stroke(200);
            this.line(250 + 20 * i, 500.0f, 250 + 20 * i, 850.0f);
            this.stroke(0);
            ++i;
        }
        this.strokeWeight(3.0f);
        this.stroke(0);
        this.line(250.0f, 510.0f, 300.0f, 510.0f);
        this.line(300.0f, 661.0f, 500.0f, 661.0f);
        this.line(500.0f, 510.0f, 550.0f, 510.0f);
        this.line(550.0f, 699.0f, 750.0f, 699.0f);
        this.stroke(0);
        this.strokeWeight(2.0f);
        i = 0;
        while (i < 44) {
            this.ellipse(300.0f, 504 + 8 * i, 1.0f, 1.0f);
            this.ellipse(500.0f, 504 + 8 * i, 1.0f, 1.0f);
            this.ellipse(550.0f, 504 + 8 * i, 1.0f, 1.0f);
            ++i;
        }
        this.strokeWeight(1.0f);
        this.stroke(150);
        this.line(this.aktuellerMesspunkt * 10 + 250, 480.0f, this.aktuellerMesspunkt * 10 + 250, 850.0f);
        this.noStroke();
        this.stroke(0);
        this.line(250.0f, 500.0f, 250.0f, 860.0f);
        this.line(245.0f, 505.0f, 250.0f, 500.0f);
        this.line(250.0f, 500.0f, 255.0f, 505.0f);
        this.line(240.0f, 850.0f, 760.0f, 850.0f);
        this.line(755.0f, 845.0f, 760.0f, 850.0f);
        this.line(760.0f, 850.0f, 755.0f, 855.0f);
        this.fill(0);
        this.text("Messpunkt (~Zeit)", 450.0f, 890.0f);
        this.text("0", 250.0f, 870.0f);
        this.text("25", 492.0f, 870.0f);
        this.text("50", 750.0f, 870.0f);
        this.text("400", 210.0f, 548.0f);
        this.text("200", 210.0f, 699.0f);
        this.text("0", 210.0f, 850.0f);
        this.text("450 \u00b0C", 253.0f, 535.0f);
        this.text("250 \u00b0C", 380.0f, 655.0f);
        this.text("450 \u00b0C", 503.0f, 535.0f);
        this.text("200 \u00b0C", 630.0f, 692.0f);
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2);
        this.rotate(4.712389f);
        this.fill(0);
        this.text("Temperatur \u03d1 [\u00b0C]", -215.0f, -350.0f);
        this.popMatrix();
        this.popMatrix();
    }

    public void matLog(float[][] m) {
        int spalten = m[0].length;
        int reihen = m.length;
        Kalibrierungssoftware.println();
        Kalibrierungssoftware.println((String)(String.valueOf(reihen) + "x" + spalten));
        Kalibrierungssoftware.println((String)"______________");
        int i = 0;
        while (i < reihen) {
            int j = 0;
            while (j < spalten) {
                Kalibrierungssoftware.print((String)(String.valueOf(m[i][j]) + " "));
                ++j;
            }
            Kalibrierungssoftware.println();
            ++i;
        }
    }

    public void arrLog(float[] m) {
        int reihen = m.length;
        Kalibrierungssoftware.println();
        int i = 0;
        while (i < reihen) {
            Kalibrierungssoftware.println((String)(String.valueOf(m[i]) + " "));
            ++i;
        }
    }

    public void Messung() {
        float SensorDaten;
        int Widerstand;
        String Daten;
        if (this.messungGestartet && this.myPort.available() > 0) {
            Daten = "...";
            if (this.aktuelleKonzentration < this.anzahlKonzentrationen) {
                if (this.aktuellerZyklus != this.anzahlZyklen) {
                    Daten = this.myPort.readStringUntil(10);
                }
                Widerstand = 0;
                if (Daten != null && (Widerstand = PApplet.parseInt((float)(SensorDaten = PApplet.parseFloat((String)Daten)))) == 1) {
                    this.wait = false;
                }
                if (Widerstand == 1 || Widerstand == 25 || Widerstand == 50 && !this.wait) {
                    this.aktuellerMesspunkt = Widerstand;
                } else if (this.aktuelleKonzentration < this.anzahlKonzentrationen && Daten != null && Widerstand != 0 && !this.wait) {
                    this.Messdaten[this.aktuellerZyklus + this.aktuelleKonzentration * this.anzahlZyklen][this.aktuellerMesspunkt] = Widerstand;
                    ++this.aktuellerMesspunkt;
                }
                if (this.aktuellerMesspunkt == 49) {
                    this.aktuellerMesspunkt = 0;
                    if (this.aktuellerZyklus < this.anzahlZyklen) {
                        ++this.aktuellerZyklus;
                        this.wait = true;
                    }
                }
            }
        }
        if (this.unbekannteKonzentration) {
            if (this.res) {
                this.myPort.clear();
                this.res = false;
            }
            if (this.myPort.available() > 0) {
                Daten = "...";
                if (this.aktuellerZyklus != this.anzahlZyklen) {
                    Daten = this.myPort.readStringUntil(10);
                }
                Widerstand = 0;
                if (Daten != null && (Widerstand = PApplet.parseInt((float)(SensorDaten = PApplet.parseFloat((String)Daten)))) == 1) {
                    this.wait = false;
                }
                if (Widerstand == 1 || Widerstand == 25 || Widerstand == 50) {
                    this.aktuellerMesspunkt = Widerstand;
                } else if (Daten != null && Widerstand != 0) {
                    this.UnbekannteKonzentrationMessdaten[0][this.aktuellerMesspunkt] = Widerstand;
                    ++this.aktuellerMesspunkt;
                }
                if (this.aktuellerMesspunkt == 49) {
                    this.aktuellerMesspunkt = 0;
                }
                if (this.aktuellerMesspunkt == this.GrenzeMaximumLinks) {
                    this.MerkmalMaximumUnbekannt = 0.0f;
                }
                if (this.aktuellerMesspunkt == this.GrenzeMinimumLinks) {
                    this.MerkmalMinimumUnbekannt = 1.0E9f;
                }
            }
        }
    }

    public void tutorial() {
        this.pushMatrix();
        int i = 0;
        while (i < 1500) {
            this.stroke(255 - 255 * i / 2500);
            this.line(0.0f, i, this.width, i);
            ++i;
        }
        if (this.seiteTutorial == 0) {
            this.seite0();
        } else if (this.seiteTutorial == 1) {
            this.seite1();
        } else if (this.seiteTutorial == 2) {
            this.seite2();
        } else if (this.seiteTutorial == 3) {
            this.seite3();
        } else if (this.seiteTutorial == 4) {
            this.seite4();
        } else if (this.seiteTutorial == 5) {
            this.seite5();
        } else if (this.seiteTutorial == 6) {
            this.seite6();
        } else if (this.seiteTutorial == 7) {
            this.seite7();
        } else if (this.seiteTutorial == 8) {
            this.seite8();
        } else if (this.seiteTutorial == 9) {
            this.seite9();
        } else if (this.seiteTutorial == 10) {
            this.seite10();
        } else if (this.seiteTutorial == 11) {
            this.seite11();
        } else if (this.seiteTutorial == 12) {
            this.seite12();
        } else if (this.seiteTutorial == 13) {
            this.seite13();
        }
        if (this.seiteTutorial > 0) {
            if (this.mouseX > 50 && this.mouseX < 150 && this.mouseY - this.translation > 800 && this.mouseY - this.translation < 850) {
                this.fill(255);
            } else {
                this.fill(220);
            }
            if (this.seiteTutorial == 12) {
                if (this.mouseX > 50 && this.mouseX < 150 && this.mouseY - this.translation > 850 && this.mouseY - this.translation < 900) {
                    this.fill(255);
                } else {
                    this.fill(220);
                }
            }
            this.rect(50.0f, 800.0f, 100.0f, 50.0f);
            this.fill(0);
            this.text("zur\u00fcck", 65.0f, 830.0f);
        }
        if (this.seiteTutorial < 13) {
            if (this.mouseX > 900 && this.mouseX < 1000 && this.mouseY - this.translation > 800 && this.mouseY - this.translation < 850) {
                this.fill(255);
            } else {
                this.fill(220);
            }
            if (this.seiteTutorial == 12) {
                if (this.mouseX > 900 && this.mouseX < 1000 && this.mouseY - this.translation > 850 && this.mouseY - this.translation < 900) {
                    this.fill(255);
                } else {
                    this.fill(220);
                }
            }
            this.rect(900.0f, 800.0f, 100.0f, 50.0f);
            this.fill(0);
            this.text("weiter", 920.0f, 830.0f);
        }
        if (this.seiteTutorial != 3) {
            if (this.mouseX > 450 && this.mouseX < 580 && this.mouseY - this.translation > 800 && this.mouseY - this.translation < 850) {
                this.fill(255);
            } else {
                this.fill(220);
            }
            if (this.seiteTutorial == 12) {
                if (this.mouseX > 450 && this.mouseX < 580 && this.mouseY - this.translation > 850 && this.mouseY - this.translation < 900) {
                    this.fill(255);
                } else {
                    this.fill(220);
                }
            }
            this.rect(450.0f, 800.0f, 130.0f, 50.0f);
            this.fill(0);
            this.text("Hauptmen\u00fc", 460.0f, 830.0f);
        }
        this.popMatrix();
    }

    public void seite0() {
        this.fill(0);
        this.textSize(20.0f);
        this.text("Willkommen zum Tutorial des Kalibrierprogramms!", 20.0f, 50.0f);
        this.textSize(16.0f);
        this.fill(255);
        this.rect(10.0f, 130.0f, 1000.0f, 75.0f);
        this.fill(0);
        this.text("Hier wird dir der Ablauf des Versuchs erkl\u00e4rt. Sobald du das Tutorial abgeschlossen hast, kannst du loslegen.", 20.0f, 150.0f);
        this.text("Klicke auf 'weiter', um den n\u00e4chsten Schritt anzuzeigen. Du kannst jederzeit wieder Schritte zur\u00fcckgehen, oder das Tutorial\nbeenden.", 20.0f, 174.0f);
        this.textSize(20.0f);
    }

    public void seite1() {
        this.textSize(16.0f);
        this.fill(255);
        this.rect(10.0f, 25.0f, 1000.0f, 90.0f);
        this.fill(0);
        this.text("Im Programm gibt es einen Graphen, auf dem die gemessenen Widerst\u00e4nde gegen die Zeit aufgetragen sind. Ein Durchlauf ent-\nspricht einem Temperaturzyklus. Sobald auf auf 'Messung starten' klickst, wird der Sensor zun\u00e4chst mit dem Programm syn-\nchronisiert. Anschlie\u00dfend werden die Messwerte live eingetragen. ", 20.0f, 50.0f);
        this.translate(0.0f, 200.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 225 && this.mouseY - this.translation < 275) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -200.0f);
        this.textSize(20.0f);
        this.noFill();
        this.stroke(255.0f, 0.0f, 0.0f);
        this.strokeWeight(4.0f);
        this.ellipse(125.0f, 250.0f, 150.0f, 100.0f);
        this.strokeWeight(1.0f);
        this.stroke(0);
    }

    public void seite2() {
        this.textSize(16.0f);
        this.text("Ein solcher Messablauf kann beispielsweise so aussehen:", 20.0f, 50.0f);
        if (this.timerTutorial < 10.0f) {
            this.textSize(30.0f);
            this.text("Synchronisiere...", 400.0f, 200.0f);
        }
        this.translate(0.0f, 200.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 225 && this.mouseY - this.translation < 275) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -200.0f);
        int i = 1;
        while ((float)i < this.timerTutorial - 10.0f) {
            if (i > 0 && i < 50) {
                this.line(250 + 10 * i, 600.0f - 70.0f * this.fakeZyklus[i], 250 + 10 * (i - 1), 600.0f - 70.0f * this.fakeZyklus[i - 1]);
            }
            ++i;
        }
        i = 220;
        while (i < 270) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 249.0f);
        this.textSize(20.0f);
        this.stroke(0);
        this.timerTutorial += 0.1f;
        if (this.timerTutorial > 100.0f) {
            this.timerTutorial = 0.0f;
        }
    }

    public void seite3() {
        this.textSize(16.0f);
        this.text("Unterhalb des Zeit-Widerstands-Graphen, siehst du den Temperaturzyklus.", 20.0f, 50.0f);
        if (this.timerTutorial < 10.0f) {
            this.textSize(30.0f);
            this.text("Synchronisiere...", 400.0f, 200.0f);
        }
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 75 && this.mouseY - this.translation < 125) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -200.0f);
        int i = 1;
        while ((float)i < this.timerTutorial - 10.0f) {
            if (i > 0 && i < 50) {
                this.line(250 + 10 * i, 600.0f - 70.0f * this.fakeZyklus[i], 250 + 10 * (i - 1), 600.0f - 70.0f * this.fakeZyklus[i - 1]);
            }
            ++i;
        }
        i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i + 150, 245.0f, i + 150);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 249.0f);
        this.textSize(20.0f);
        this.stroke(0);
        this.timerTutorial += 0.1f;
        if (this.timerTutorial > 100.0f) {
            this.timerTutorial = 0.0f;
        }
        this.translate(0.0f, 175.0f);
        this.textSize(16.0f);
        this.Temperaturzyklus();
        this.textSize(20.0f);
        this.translate(0.0f, -25.0f);
    }

    public void seite4() {
        this.textSize(20.0f);
        this.text("Auf der rechten Seite werden dir die folgenden Informationen angezeigt:", 20.0f, 50.0f);
        this.textSize(16.0f);
        this.fill(255);
        this.rect(95.0f, 75.0f, 870.0f, 80.0f);
        this.fill(0);
        this.text("1) abgeschlossene Zyklen: F\u00fcr jede Konzentration sollst du 10 Messkurven aufnehmen", 100.0f, 100.0f);
        this.text("2) Konzentration: Eine Info f\u00fcr dich, welche Konzentration sich momentan in der Messkammer befinden sollte", 100.0f, 120.0f);
        this.text("3) Messpunkt: Zeigt an, an welchem Punkt im Zyklus sich der Sensor befindet", 100.0f, 140.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 1/10", 800.0f, 250.0f);
        this.text("Konzentration: 0 ppm", 800.0f, 270.0f);
        this.text("Messpunkt: 37/50", 800.0f, 290.0f);
        this.translate(0.0f, 200.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 225 && this.mouseY - this.translation < 275) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -200.0f);
        int i = 1;
        while (i < 50) {
            this.line(250 + 10 * i, 600.0f - 70.0f * this.fakeZyklus[i], 250 + 10 * (i - 1), 600.0f - 70.0f * this.fakeZyklus[i - 1]);
            ++i;
        }
        i = 220;
        while (i < 270) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 249.0f);
        this.textSize(20.0f);
        this.noFill();
        this.stroke(255.0f, 0.0f, 0.0f);
        this.strokeWeight(4.0f);
        this.ellipse(900.0f, 265.0f, 240.0f, 120.0f);
        this.strokeWeight(1.0f);
        this.stroke(0);
    }

    public void seite5() {
        this.textSize(16.0f);
        this.text("Wenn 10 Messkurven aufgenommen wurden, wirst du gefragt, ob du mit der Messung zufrieden bist:", 20.0f, 50.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 10/10", 800.0f, 100.0f);
        this.text("Konzentration: 0 ppm", 800.0f, 120.0f);
        this.text("Messpunkt: 50/50", 800.0f, 140.0f);
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 125 && this.mouseY - this.translation < 175) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -50.0f);
        int j = 0;
        while (j < 10) {
            int i = 1;
            while (i < 50) {
                this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / (0.1f * (float)j + 1.0f), 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / (0.1f * (float)j + 1.0f));
                ++i;
            }
            ++j;
        }
        int i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 99.0f);
        this.textSize(20.0f);
        this.stroke(0);
        this.translate(0.0f, 60.0f);
        this.fill(255);
        this.stroke(0);
        this.rect(200.0f, 450.0f, 600.0f, 100.0f);
        this.rect(350.0f, 500.0f, 100.0f, 40.0f);
        this.rect(550.0f, 500.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        if (this.mouseX > 350 && this.mouseX < 450 && this.mouseY - this.translation > 560 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(350.0f, 500.0f, 100.0f, 40.0f);
        if (this.mouseX > 550 && this.mouseX < 650 && this.mouseY - this.translation > 560 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(550.0f, 500.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        this.text("Bist du mit der Messung zufrieden?", 250.0f, 483.0f);
        this.text("Ja", 390.0f, 530.0f);
        this.text("Nein", 570.0f, 530.0f);
        this.noFill();
        this.stroke(255.0f, 0.0f, 0.0f);
        this.strokeWeight(3.0f);
        this.ellipse(500.0f, 500.0f, 750.0f, 100.0f);
        this.strokeWeight(1.0f);
        this.translate(0.0f, -60.0f);
        this.stroke(0);
        this.textSize(20.0f);
    }

    public void seite6() {
        this.textSize(16.0f);
        this.text("Wenn 10 Messkurven aufgenommen wurden, wirst du gefragt, ob du mit der Messung zufrieden bist:", 20.0f, 50.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 10/10", 800.0f, 100.0f);
        this.text("Konzentration: 0 ppm", 800.0f, 120.0f);
        this.text("Messpunkt: 50/50", 800.0f, 140.0f);
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 75 && this.mouseY - this.translation < 125) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -50.0f);
        this.strokeWeight(1.0f);
        int j = 0;
        while (j < 10) {
            int i = 1;
            while (i < 50) {
                this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / (0.1f * (float)j + 1.0f), 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / (0.1f * (float)j + 1.0f));
                ++i;
            }
            ++j;
        }
        this.strokeWeight(1.0f);
        int i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 99.0f);
        this.textSize(20.0f);
        this.stroke(0);
        this.translate(0.0f, 60.0f);
        this.fill(255);
        this.stroke(0);
        this.rect(200.0f, 450.0f, 600.0f, 100.0f);
        this.rect(350.0f, 500.0f, 100.0f, 40.0f);
        this.rect(550.0f, 500.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        if (this.mouseX > 350 && this.mouseX < 450 && this.mouseY - this.translation > 560 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(350.0f, 500.0f, 100.0f, 40.0f);
        if (this.mouseX > 550 && this.mouseX < 650 && this.mouseY - this.translation > 560 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(550.0f, 500.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        this.text("Bist du mit der Messung zufrieden?", 250.0f, 483.0f);
        this.text("Ja", 390.0f, 530.0f);
        this.text("Nein", 570.0f, 530.0f);
        this.translate(0.0f, -60.0f);
        this.textSize(16.0f);
        this.noFill();
        this.strokeWeight(4.0f);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.ellipse(600.0f, 580.0f, 120.0f, 60.0f);
        this.fill(0);
        this.strokeWeight(1.0f);
        this.fill(255);
        this.stroke(0);
        this.rect(150.0f, 640.0f, 700.0f, 110.0f);
        this.fill(0);
        this.noStroke();
        this.text("Das Ethanol braucht eine gewisse Zeit bis es sich gleichm\u00e4\u00dfig in der Messkammer ver-\nteilt hat. In dieser Zeit \u00e4ndert sich das Messignal noch deutlich (siehe oben).\nWenn du auf 'Nein' klickst, werden die Messkurven der aktuellen Konzentration gel\u00f6scht,\nund erneut 10 Zyklen aufgenommen.", 160.0f, 662.0f);
        this.textSize(20.0f);
        this.stroke(0);
    }

    public void seite7() {
        this.textSize(16.0f);
        this.text("Wenn 10 Messkurven aufgenommen wurden, wirst du gefragt, ob du mit der Messung zufrieden bist:", 20.0f, 50.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 5/10", 800.0f, 100.0f);
        this.text("Konzentration: 0 ppm", 800.0f, 120.0f);
        this.text("Messpunkt: 50/50", 800.0f, 140.0f);
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 75 && this.mouseY - this.translation < 125) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -50.0f);
        int j = 0;
        while (j < 5) {
            int i = 1;
            while (i < 50) {
                this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / (0.05f * (float)j + 1.0f), 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / (0.05f * (float)j + 1.0f));
                ++i;
            }
            ++j;
        }
        int i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 99.0f);
        this.textSize(20.0f);
        this.stroke(0);
        this.translate(0.0f, 60.0f);
        this.fill(255);
        this.stroke(0);
        this.rect(200.0f, 450.0f, 600.0f, 100.0f);
        this.rect(350.0f, 500.0f, 100.0f, 40.0f);
        this.rect(550.0f, 500.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        if (this.mouseX > 350 && this.mouseX < 450 && this.mouseY - this.translation > 560 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(350.0f, 500.0f, 100.0f, 40.0f);
        if (this.mouseX > 550 && this.mouseX < 650 && this.mouseY - this.translation > 560 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(550.0f, 500.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        this.text("Bist du mit der Messung zufrieden?", 250.0f, 483.0f);
        this.text("Ja", 390.0f, 530.0f);
        this.text("Nein", 570.0f, 530.0f);
        this.translate(0.0f, -60.0f);
        this.textSize(16.0f);
        this.fill(255);
        this.stroke(0);
        this.rect(150.0f, 640.0f, 700.0f, 110.0f);
        this.fill(0);
        this.noStroke();
        this.text("Wenn du bereits nach wenigen Zyklen merkst, dass das Ethanol sich noch nicht gleich-\nm\u00e4\u00dfig verteilt hat, kannst auch direkt auf 'Messung wiederholen' klicken.\nAuch dann werden die Zyklen dieser Konzentration gel\u00f6scht, und die 10 Zyklen starten\nerneut.", 160.0f, 662.0f);
        this.stroke(0);
        if (this.mouseX > 810 && this.mouseX < 930 && this.mouseY > 400 && this.mouseY < 450) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(810.0f, 400.0f, 120.0f, 50.0f);
        this.fill(0);
        this.text("  Messung\nwiederholen", 825.0f, 418.0f);
        this.noFill();
        this.strokeWeight(4.0f);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.ellipse(870.0f, 425.0f, 120.0f, 60.0f);
        this.strokeWeight(1.0f);
        this.textSize(20.0f);
        this.stroke(0);
    }

    public void seite8() {
        this.textSize(16.0f);
        this.text("Wenn 10 Messkurven aufgenommen wurden, wirst du gefragt, ob du mit der Messung zufrieden bist:", 20.0f, 50.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 10/10", 800.0f, 100.0f);
        this.text("Konzentration: 0 ppm", 800.0f, 120.0f);
        this.text("Messpunkt: 50/50", 800.0f, 140.0f);
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 75 && this.mouseY - this.translation < 125) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -50.0f);
        int j = 0;
        while (j < 10) {
            int i = 1;
            while (i < 50) {
                this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / (0.003f * (float)j + 1.0f), 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / (0.003f * (float)j + 1.0f));
                ++i;
            }
            ++j;
        }
        int i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 99.0f);
        this.textSize(20.0f);
        this.stroke(0);
        this.translate(0.0f, 60.0f);
        this.fill(255);
        this.stroke(0);
        this.rect(200.0f, 450.0f, 600.0f, 100.0f);
        this.rect(350.0f, 500.0f, 100.0f, 40.0f);
        this.rect(550.0f, 500.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        if (this.mouseX > 350 && this.mouseX < 450 && this.mouseY - this.translation > 560 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(350.0f, 500.0f, 100.0f, 40.0f);
        if (this.mouseX > 550 && this.mouseX < 650 && this.mouseY - this.translation > 560 && this.mouseY - this.translation < 600) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(550.0f, 500.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        this.text("Bist du mit der Messung zufrieden?", 250.0f, 483.0f);
        this.text("Ja", 390.0f, 530.0f);
        this.text("Nein", 570.0f, 530.0f);
        this.translate(0.0f, -60.0f);
        this.textSize(16.0f);
        this.noFill();
        this.strokeWeight(4.0f);
        this.stroke(255.0f, 0.0f, 0.0f);
        this.ellipse(400.0f, 580.0f, 120.0f, 60.0f);
        this.fill(0);
        this.strokeWeight(1.0f);
        this.fill(255);
        this.stroke(0);
        this.rect(150.0f, 640.0f, 700.0f, 85.0f);
        this.fill(0);
        this.noStroke();
        this.text("Wenn die Messkurven sich nicht stark unterscheiden, hat sich das Ethanol gleich-\nm\u00e4\u00dfig verteilt. In diesem Fall kannst du auf 'Ja' klicken. Dann wirst du aufgefordert die\nEthanol-Konzentration zu erh\u00f6hen.", 160.0f, 662.0f);
        this.stroke(0);
        if (this.mouseX > 810 && this.mouseX < 930 && this.mouseY > 400 && this.mouseY < 450) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(810.0f, 400.0f, 120.0f, 50.0f);
        this.fill(0);
        this.text("  Messung\nwiederholen", 825.0f, 418.0f);
        this.textSize(20.0f);
        this.stroke(0);
    }

    public void seite9() {
        this.textSize(16.0f);
        this.text("Der Durchschnitt der Signale einer Konzentration wird farbig dargestellt:", 20.0f, 50.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 10/10", 800.0f, 100.0f);
        this.text("Konzentration: 40 ppm", 800.0f, 120.0f);
        this.text("Messpunkt: 50/50", 800.0f, 140.0f);
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 125 && this.mouseY - this.translation < 175) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -50.0f);
        this.strokeWeight(3.0f);
        int j = 0;
        while (j < 5) {
            int i = 1;
            while (i < 50) {
                if (j == 0) {
                    this.stroke(255.0f, 0.0f, 0.0f);
                } else if (j == 1) {
                    this.stroke(0.0f, 200.0f, 0.0f);
                } else if (j == 2) {
                    this.stroke(255.0f, 0.0f, 255.0f);
                } else if (j == 3) {
                    this.stroke(255.0f, 255.0f, 0.0f);
                } else if (j == 4) {
                    this.stroke(0.0f, 255.0f, 255.0f);
                }
                this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / (float)(j + 1), 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / (float)(j + 1));
                ++i;
            }
            ++j;
        }
        this.fill(255.0f, 0.0f, 0.0f);
        this.text("0 ppm", 810.0f, 200.0f);
        this.fill(0.0f, 200.0f, 0.0f);
        this.text("10 ppm", 810.0f, 220.0f);
        this.fill(255.0f, 0.0f, 255.0f);
        this.text("20 ppm", 810.0f, 240.0f);
        this.fill(255.0f, 255.0f, 0.0f);
        this.text("30 ppm", 810.0f, 260.0f);
        this.fill(0.0f, 255.0f, 255.0f);
        this.text("40 ppm", 810.0f, 280.0f);
        this.strokeWeight(1.0f);
        int i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 99.0f);
        this.textSize(20.0f);
        this.stroke(0);
        this.textSize(20.0f);
    }

    public void seite10() {
        this.textSize(20.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 10/10", 800.0f, 100.0f);
        this.text("Konzentration: 40 ppm", 800.0f, 120.0f);
        this.text("Messpunkt: 50/50", 800.0f, 140.0f);
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 75 && this.mouseY - this.translation < 125) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -50.0f);
        this.strokeWeight(3.0f);
        int j = 0;
        while (j < 5) {
            int i = 1;
            while (i < 50) {
                if (j == 0) {
                    this.stroke(255.0f, 0.0f, 0.0f);
                } else if (j == 1) {
                    this.stroke(0.0f, 200.0f, 0.0f);
                } else if (j == 2) {
                    this.stroke(255.0f, 0.0f, 255.0f);
                } else if (j == 3) {
                    this.stroke(255.0f, 255.0f, 0.0f);
                } else if (j == 4) {
                    this.stroke(0.0f, 255.0f, 255.0f);
                }
                this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / (float)(j + 1), 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / (float)(j + 1));
                ++i;
            }
            ++j;
        }
        this.fill(255.0f, 0.0f, 0.0f);
        this.text("0 ppm", 810.0f, 200.0f);
        this.fill(0.0f, 200.0f, 0.0f);
        this.text("10 ppm", 810.0f, 220.0f);
        this.fill(255.0f, 0.0f, 255.0f);
        this.text("20 ppm", 810.0f, 240.0f);
        this.fill(255.0f, 255.0f, 0.0f);
        this.text("30 ppm", 810.0f, 260.0f);
        this.fill(0.0f, 255.0f, 255.0f);
        this.text("40 ppm", 810.0f, 280.0f);
        this.strokeWeight(1.0f);
        int i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 99.0f);
        this.stroke(0);
        this.translate(0.0f, 50.0f);
        this.fill(255);
        this.rect(10.0f, 475.0f, 1015.0f, 190.0f);
        this.fill(0);
        this.text("Wenn 5 verschiedene Konzentrationen aufgenommen wurden, hast du die Aufgabe 2 Merkmale der Kurven zu bestim-\nmen. Dazu stehen dir Maximum, Minimum, Mittelwert und Steigung innerhalb eines Intervalls zur Auswahl.\nKlicke auf die jeweiligen Buttons (links) und w\u00e4hle 2 Merkmale aus. Wenn du mit der Maus in das Intervall klickst, kanns du es\nverschieben. Durch erneutes Klicken auf den Button w\u00e4hlst du das Merkmal ab.\n\nWenn du genau 2 Merkmale ausgew\u00e4hlt hast erscheint ein Button. Wenn du zufrieden bist, kommst du mit einem Klick darauf\nweiter.", 20.0f, 500.0f);
        this.textSize(20.0f);
        this.text("Merkmale", 75.0f, 120.0f);
        this.stroke(0);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 195 && this.mouseY - this.translation < 245) {
            this.fill(0.0f, 0.0f, 255.0f, 20.0f);
        } else {
            this.fill(100.0f, 100.0f, 255.0f, 220.0f);
        }
        this.rect(75.0f, 145.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 270 && this.mouseY - this.translation < 320) {
            this.fill(255.0f, 100.0f, 100.0f, 20.0f);
        } else {
            this.fill(255.0f, 0.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 220.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 345 && this.mouseY - this.translation < 395) {
            this.fill(255.0f, 255.0f, 0.0f, 20.0f);
        } else {
            this.fill(255.0f, 255.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 295.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 420 && this.mouseY - this.translation < 470) {
            this.fill(0.0f, 255.0f, 0.0f, 20.0f);
        } else {
            this.fill(0.0f, 255.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 370.0f, 100.0f, 50.0f);
        this.fill(0);
        this.textSize(16.0f);
        this.text("Maximum", 87.0f, 175.0f);
        this.text("Minimum", 87.0f, 250.0f);
        this.text("Steigung", 90.0f, 325.0f);
        this.text("Mittelwert", 87.0f, 400.0f);
        this.textSize(20.0f);
        if (this.SteigAktiv) {
            this.Steigung();
        }
        if (this.MWAktiv) {
            this.Mittelwert();
        }
        if (this.MaxAktiv) {
            this.Maximum();
        }
        if (this.MinAktiv) {
            this.Minimum();
        }
        this.translate(0.0f, -50.0f);
    }

    public void seite11() {
        this.textSize(20.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 10/10", 800.0f, 100.0f);
        this.text("Konzentration: 40 ppm", 800.0f, 120.0f);
        this.text("Messpunkt: 50/50", 800.0f, 140.0f);
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 75 && this.mouseY - this.translation < 125) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -50.0f);
        this.strokeWeight(3.0f);
        int j = 0;
        while (j < 5) {
            int i = 1;
            while (i < 50) {
                if (j == 0) {
                    this.stroke(255.0f, 0.0f, 0.0f);
                } else if (j == 1) {
                    this.stroke(0.0f, 200.0f, 0.0f);
                } else if (j == 2) {
                    this.stroke(255.0f, 0.0f, 255.0f);
                } else if (j == 3) {
                    this.stroke(255.0f, 255.0f, 0.0f);
                } else if (j == 4) {
                    this.stroke(0.0f, 255.0f, 255.0f);
                }
                this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / (float)(j + 1), 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / (float)(j + 1));
                ++i;
            }
            ++j;
        }
        this.fill(255.0f, 0.0f, 0.0f);
        this.text("0 ppm", 810.0f, 200.0f);
        this.fill(0.0f, 200.0f, 0.0f);
        this.text("10 ppm", 810.0f, 220.0f);
        this.fill(255.0f, 0.0f, 255.0f);
        this.text("20 ppm", 810.0f, 240.0f);
        this.fill(255.0f, 255.0f, 0.0f);
        this.text("30 ppm", 810.0f, 260.0f);
        this.fill(0.0f, 255.0f, 255.0f);
        this.text("40 ppm", 810.0f, 280.0f);
        this.strokeWeight(1.0f);
        int i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 99.0f);
        this.stroke(0);
        this.translate(0.0f, 50.0f);
        this.fill(255);
        this.rect(210.0f, 460.0f, 580.0f, 30.0f);
        this.fill(0);
        this.text("Du kannst dir die Merkmale, auch in dem unteren Graphen anschauen.", 220.0f, 480.0f);
        this.textSize(20.0f);
        this.text("Merkmale", 75.0f, 120.0f);
        this.stroke(0);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 195 && this.mouseY - this.translation < 245) {
            this.fill(0.0f, 0.0f, 255.0f, 20.0f);
        } else {
            this.fill(100.0f, 100.0f, 255.0f, 220.0f);
        }
        this.rect(75.0f, 145.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 270 && this.mouseY - this.translation < 320) {
            this.fill(255.0f, 100.0f, 100.0f, 20.0f);
        } else {
            this.fill(255.0f, 0.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 220.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 345 && this.mouseY - this.translation < 395) {
            this.fill(255.0f, 255.0f, 0.0f, 20.0f);
        } else {
            this.fill(255.0f, 255.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 295.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 420 && this.mouseY - this.translation < 470) {
            this.fill(0.0f, 255.0f, 0.0f, 20.0f);
        } else {
            this.fill(0.0f, 255.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 370.0f, 100.0f, 50.0f);
        this.fill(0);
        this.textSize(16.0f);
        this.text("Maximum", 87.0f, 175.0f);
        this.text("Minimum", 87.0f, 250.0f);
        this.text("Steigung", 90.0f, 325.0f);
        this.text("Mittelwert", 87.0f, 400.0f);
        this.textSize(20.0f);
        if (this.SteigAktiv) {
            this.Steigung();
        }
        if (this.MWAktiv) {
            this.Mittelwert();
        }
        if (this.MaxAktiv) {
            this.Maximum();
        }
        if (this.MinAktiv) {
            this.Minimum();
        }
        this.fill(0);
        this.text("Maximum", 230.0f, 520.0f);
        this.text("Steigung", 635.0f, 520.0f);
        this.fill(255);
        this.rect(125.0f, 525.0f, 300.0f, 200.0f);
        this.rect(525.0f, 525.0f, 300.0f, 200.0f);
        this.fill(100.0f, 100.0f, 255.0f, 50.0f);
        this.rect(125.0f, 525.0f, 300.0f, 200.0f);
        this.fill(255.0f, 255.0f, 0.0f, 50.0f);
        this.rect(525.0f, 525.0f, 300.0f, 200.0f);
        this.stroke(0);
        this.line(125.0f, 525.0f, 125.0f, 730.0f);
        this.line(120.0f, 725.0f, 400.0f, 725.0f);
        i = 0;
        while (i < 5) {
            this.line(175 + 50 * i, 525.0f, 175 + 50 * i, 730.0f);
            this.line(575 + 50 * i, 525.0f, 575 + 50 * i, 730.0f);
            ++i;
        }
        this.line(625.0f, 525.0f, 625.0f, 730.0f);
        this.line(620.0f, 725.0f, 800.0f, 725.0f);
        this.textSize(12.0f);
        this.fill(0);
        this.text("0 ppm", 130.0f, 740.0f);
        this.text("10 ppm", 180.0f, 740.0f);
        this.text("20 ppm", 230.0f, 740.0f);
        this.text("30 ppm", 280.0f, 740.0f);
        this.text("40 ppm", 330.0f, 740.0f);
        this.text("?? ppm", 380.0f, 740.0f);
        this.text("0 ppm", 530.0f, 740.0f);
        this.text("10 ppm", 580.0f, 740.0f);
        this.text("20 ppm", 630.0f, 740.0f);
        this.text("30 ppm", 680.0f, 740.0f);
        this.text("40 ppm", 730.0f, 740.0f);
        this.text("?? ppm", 780.0f, 740.0f);
        this.textSize(20.0f);
        this.translate(0.0f, -50.0f);
        this.GrenzeMaximumLinks = 10;
        this.GrenzeSteigungLinks = 30;
        this.noStroke();
        i = 0;
        while (i < 10) {
            this.fill(255.0f, 0.0f, 0.0f, 100.0f);
            this.ellipse(150.0f, 610 + i, 10.0f, 10.0f);
            this.ellipse(550.0f, 740.0f + 0.1f * (float)i, 10.0f, 10.0f);
            this.fill(0.0f, 200.0f, 0.0f, 100.0f);
            this.ellipse(200.0f, 660 + i, 10.0f, 10.0f);
            this.ellipse(600.0f, 690.0f + 0.1f * (float)i, 10.0f, 10.0f);
            this.fill(255.0f, 0.0f, 255.0f, 100.0f);
            this.ellipse(250.0f, 695 + i, 10.0f, 10.0f);
            this.ellipse(650.0f, 660.0f + 0.1f * (float)i, 10.0f, 10.0f);
            this.fill(255.0f, 255.0f, 0.0f, 100.0f);
            this.ellipse(300.0f, 710 + i, 10.0f, 10.0f);
            this.ellipse(700.0f, 630.0f + 0.1f * (float)i, 10.0f, 10.0f);
            this.fill(0.0f, 255.0f, 255.0f, 100.0f);
            this.ellipse(350.0f, 720 + i, 10.0f, 10.0f);
            this.ellipse(750.0f, 610.0f + 0.1f * (float)i, 10.0f, 10.0f);
            ++i;
        }
        this.stroke(0);
    }

    public void seite12() {
        this.textSize(20.0f);
        this.textSize(14.0f);
        this.text("abgeschlossene Zyklen: 10/10", 800.0f, 100.0f);
        this.text("Konzentration: 40 ppm", 800.0f, 120.0f);
        this.text("Messpunkt: 50/50", 800.0f, 140.0f);
        this.translate(0.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 75 && this.mouseY - this.translation < 125) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.textSize(16.0f);
        this.rect(75.0f, 25.0f, 100.0f, 50.0f);
        this.fill(0);
        this.text("Messung \n starten", 91.0f, 45.0f);
        this.Koordinatenkreuz();
        this.translate(0.0f, -50.0f);
        this.strokeWeight(3.0f);
        int j = 0;
        while (j < 5) {
            int i = 1;
            while (i < 50) {
                if (j == 0) {
                    this.stroke(255.0f, 0.0f, 0.0f);
                } else if (j == 1) {
                    this.stroke(0.0f, 200.0f, 0.0f);
                } else if (j == 2) {
                    this.stroke(255.0f, 0.0f, 255.0f);
                } else if (j == 3) {
                    this.stroke(255.0f, 255.0f, 0.0f);
                } else if (j == 4) {
                    this.stroke(0.0f, 255.0f, 255.0f);
                }
                this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / (float)(j + 1), 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / (float)(j + 1));
                ++i;
            }
            ++j;
        }
        int i = 1;
        while (i < 50) {
            this.stroke(0);
            this.line(250 + 10 * i, 450.0f - 70.0f * this.fakeZyklus[i] / 2.7f, 250 + 10 * (i - 1), 450.0f - 70.0f * this.fakeZyklus[i - 1] / 2.7f);
            ++i;
        }
        this.fill(255.0f, 0.0f, 0.0f);
        this.text("0 ppm", 810.0f, 200.0f);
        this.fill(0.0f, 200.0f, 0.0f);
        this.text("10 ppm", 810.0f, 220.0f);
        this.fill(255.0f, 0.0f, 255.0f);
        this.text("20 ppm", 810.0f, 240.0f);
        this.fill(255.0f, 255.0f, 0.0f);
        this.text("30 ppm", 810.0f, 260.0f);
        this.fill(0.0f, 255.0f, 255.0f);
        this.text("40 ppm", 810.0f, 280.0f);
        this.fill(0);
        this.text("?? ppm", 810.0f, 300.0f);
        this.strokeWeight(1.0f);
        i = 70;
        while (i < 120) {
            this.stroke(255 - 255 * i / 2500);
            this.line(200.0f, i, 245.0f, i);
            ++i;
        }
        this.textSize(16.0f);
        this.fill(0);
        this.text(200, 198.0f, 99.0f);
        this.stroke(0);
        this.translate(0.0f, 50.0f);
        this.fill(255);
        this.rect(10.0f, 460.0f, 1020.0f, 85.0f);
        this.fill(0);
        this.text("Nachdem du alle Trainingsdaten aufgenommen hast, werden wir ein mathematisches Modell erstellen, das uns, bei gegebenen\nMerkmalen, eine Vorhersage f\u00fcr die Konzentration liefert. Das Modell werden wir dann an einer unbekannten Konzentration\ntesten, indem wir erneut Merkmale aufnehmen.", 20.0f, 480.0f);
        this.textSize(20.0f);
        this.text("Merkmale", 75.0f, 120.0f);
        this.stroke(0);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 195 && this.mouseY - this.translation < 245) {
            this.fill(0.0f, 0.0f, 255.0f, 20.0f);
        } else {
            this.fill(100.0f, 100.0f, 255.0f, 220.0f);
        }
        this.rect(75.0f, 145.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 270 && this.mouseY - this.translation < 320) {
            this.fill(255.0f, 100.0f, 100.0f, 20.0f);
        } else {
            this.fill(255.0f, 0.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 220.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 345 && this.mouseY - this.translation < 395) {
            this.fill(255.0f, 255.0f, 0.0f, 20.0f);
        } else {
            this.fill(255.0f, 255.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 295.0f, 100.0f, 50.0f);
        if (this.mouseX > 75 && this.mouseX < 175 && this.mouseY - this.translation > 420 && this.mouseY - this.translation < 470) {
            this.fill(0.0f, 255.0f, 0.0f, 20.0f);
        } else {
            this.fill(0.0f, 255.0f, 0.0f, 220.0f);
        }
        this.rect(75.0f, 370.0f, 100.0f, 50.0f);
        this.fill(0);
        this.textSize(16.0f);
        this.text("Maximum", 87.0f, 175.0f);
        this.text("Minimum", 87.0f, 250.0f);
        this.text("Steigung", 90.0f, 325.0f);
        this.text("Mittelwert", 87.0f, 400.0f);
        this.textSize(20.0f);
        if (this.SteigAktiv) {
            this.Steigung();
        }
        if (this.MWAktiv) {
            this.Mittelwert();
        }
        if (this.MaxAktiv) {
            this.Maximum();
        }
        if (this.MinAktiv) {
            this.Minimum();
        }
        this.translate(0.0f, 50.0f);
        this.fill(0);
        this.text("Maximum", 230.0f, 520.0f);
        this.text("Steigung", 635.0f, 520.0f);
        this.fill(255);
        this.rect(125.0f, 525.0f, 300.0f, 200.0f);
        this.rect(525.0f, 525.0f, 300.0f, 200.0f);
        this.fill(100.0f, 100.0f, 255.0f, 50.0f);
        this.rect(125.0f, 525.0f, 300.0f, 200.0f);
        this.fill(255.0f, 255.0f, 0.0f, 50.0f);
        this.rect(525.0f, 525.0f, 300.0f, 200.0f);
        this.stroke(0);
        this.line(125.0f, 525.0f, 125.0f, 730.0f);
        this.line(120.0f, 725.0f, 400.0f, 725.0f);
        i = 0;
        while (i < 5) {
            this.line(175 + 50 * i, 525.0f, 175 + 50 * i, 730.0f);
            this.line(575 + 50 * i, 525.0f, 575 + 50 * i, 730.0f);
            ++i;
        }
        this.line(625.0f, 525.0f, 625.0f, 730.0f);
        this.line(620.0f, 725.0f, 800.0f, 725.0f);
        this.textSize(12.0f);
        this.fill(0);
        this.text("0 ppm", 130.0f, 740.0f);
        this.text("10 ppm", 180.0f, 740.0f);
        this.text("20 ppm", 230.0f, 740.0f);
        this.text("30 ppm", 280.0f, 740.0f);
        this.text("40 ppm", 330.0f, 740.0f);
        this.text("?? ppm", 380.0f, 740.0f);
        this.text("0 ppm", 530.0f, 740.0f);
        this.text("10 ppm", 580.0f, 740.0f);
        this.text("20 ppm", 630.0f, 740.0f);
        this.text("30 ppm", 680.0f, 740.0f);
        this.text("40 ppm", 730.0f, 740.0f);
        this.text("?? ppm", 780.0f, 740.0f);
        this.textSize(20.0f);
        this.translate(0.0f, -50.0f);
        this.GrenzeMaximumLinks = 10;
        this.GrenzeSteigungLinks = 30;
        this.noStroke();
        i = 0;
        while (i < 10) {
            this.fill(255.0f, 0.0f, 0.0f, 100.0f);
            this.ellipse(150.0f, 610 + i, 10.0f, 10.0f);
            this.ellipse(550.0f, 740.0f + 0.1f * (float)i, 10.0f, 10.0f);
            this.fill(0.0f, 200.0f, 0.0f, 100.0f);
            this.ellipse(200.0f, 660 + i, 10.0f, 10.0f);
            this.ellipse(600.0f, 690.0f + 0.1f * (float)i, 10.0f, 10.0f);
            this.fill(255.0f, 0.0f, 255.0f, 100.0f);
            this.ellipse(250.0f, 695 + i, 10.0f, 10.0f);
            this.ellipse(650.0f, 660.0f + 0.1f * (float)i, 10.0f, 10.0f);
            this.fill(255.0f, 255.0f, 0.0f, 100.0f);
            this.ellipse(300.0f, 710 + i, 10.0f, 10.0f);
            this.ellipse(700.0f, 630.0f + 0.1f * (float)i, 10.0f, 10.0f);
            this.fill(0.0f, 255.0f, 255.0f, 100.0f);
            this.ellipse(350.0f, 720 + i, 10.0f, 10.0f);
            this.ellipse(750.0f, 610.0f + 0.1f * (float)i, 10.0f, 10.0f);
            ++i;
        }
        this.fill(0, 100.0f);
        this.ellipse(400.0f, 670.0f, 10.0f, 10.0f);
        this.ellipse(800.0f, 660.0f, 10.0f, 10.0f);
        this.noFill();
        this.stroke(255.0f, 0.0f, 0.0f);
        this.strokeWeight(4.0f);
        this.ellipse(840.0f, 250.0f, 90.0f, 50.0f);
        this.ellipse(400.0f, 670.0f, 30.0f, 30.0f);
        this.ellipse(800.0f, 660.0f, 30.0f, 30.0f);
        this.stroke(0);
        this.strokeWeight(1.0f);
    }

    public void seite13() {
        this.textSize(20.0f);
        this.textAlign(3);
        this.text("Du kannst nun zur echten Messung. Wenn du w\u00e4hrend des Versuchs Fragen hast, stehen dir die Betreuer\nzur Verf\u00fcgung.", 525.0f, 300.0f);
        this.textAlign(1);
    }

    public void Zufrieden() {
        this.pushMatrix();
        this.fill(255);
        this.stroke(0);
        this.rect(200.0f, 500.0f, 600.0f, 100.0f);
        this.rect(350.0f, 550.0f, 100.0f, 40.0f);
        this.rect(550.0f, 550.0f, 100.0f, 40.0f);
        this.fill(0);
        this.textSize(30.0f);
        if (this.aktuelleKonzentration < this.anzahlKonzentrationen + 1) {
            this.fill(255);
            this.stroke(0);
            this.rect(200.0f, 500.0f, 600.0f, 150.0f);
            if (!this.Aufforderung) {
                if (this.mouseX > 350 && this.mouseX < 450 && this.mouseY - this.translation > 550 && this.mouseY - this.translation < 590) {
                    this.fill(255);
                } else {
                    this.fill(220);
                }
                this.rect(350.0f, 550.0f, 100.0f, 40.0f);
                if (this.mouseX > 550 && this.mouseX < 650 && this.mouseY - this.translation > 550 && this.mouseY - this.translation < 590) {
                    this.fill(255);
                } else {
                    this.fill(220);
                }
                this.rect(550.0f, 550.0f, 100.0f, 40.0f);
            } else {
                if (this.mouseX > 450 && this.mouseX < 550 && this.mouseY - this.translation > 600 && this.mouseY - this.translation < 640) {
                    this.fill(255);
                } else {
                    this.fill(220);
                }
                this.rect(450.0f, 600.0f, 100.0f, 40.0f);
            }
            this.fill(0);
            this.textSize(30.0f);
            if (!this.Aufforderung) {
                this.text("Bist du mit der Messung zufrieden?", 250.0f, 533.0f);
                this.text("Ja", 390.0f, 580.0f);
                this.text("Nein", 570.0f, 580.0f);
            } else if (this.aktuelleKonzentration != this.anzahlKonzentrationen - 1) {
                String temp3;
                String temp2;
                float temp0;
                this.textSize(20.0f);
                if (this.aktuelleKonzentration == 0) {
                    float temp = (float)this.Konzentration1Wert / this.ppmProMlWert;
                    String temp22 = Kalibrierungssoftware.nf((float)temp, (int)0, (int)2);
                    String temp32 = Kalibrierungssoftware.nf((float)Kalibrierungssoftware.round((float)this.Konzentration1Wert), (int)0, (int)0).replace('.', ',');
                    this.text("Spritze nun " + temp22.replace('.', ',') + "ml in die Messkammer, um eine Konzen-\ntration von " + temp32 + " ppm zu erhalten.", 220.0f, 533.0f);
                }
                if (this.aktuelleKonzentration == 1) {
                    temp0 = this.Konzentration2Wert - this.Konzentration1Wert;
                    float temp = temp0 / this.ppmProMlWert;
                    temp2 = Kalibrierungssoftware.nf((float)temp, (int)0, (int)2);
                    temp3 = Kalibrierungssoftware.nf((float)Kalibrierungssoftware.round((float)this.Konzentration2Wert), (int)0, (int)0).replace('.', ',');
                    this.text("Spritze nun " + temp2.replace('.', ',') + "ml in die Messkammer, um eine Konzen-\ntration von " + temp3 + " ppm zu erhalten.", 220.0f, 533.0f);
                }
                if (this.aktuelleKonzentration == 2) {
                    temp0 = this.Konzentration3Wert - this.Konzentration2Wert;
                    float temp = temp0 / this.ppmProMlWert;
                    temp2 = Kalibrierungssoftware.nf((float)temp, (int)0, (int)2);
                    temp3 = Kalibrierungssoftware.nf((float)Kalibrierungssoftware.round((float)this.Konzentration3Wert), (int)0, (int)0).replace('.', ',');
                    this.text("Spritze nun " + temp2.replace('.', ',') + " ml in die Messkammer, um eine Konzen-\ntration von " + temp3 + " ppm zu erhalten.", 220.0f, 533.0f);
                }
                if (this.aktuelleKonzentration == 3) {
                    temp0 = 40 - this.Konzentration3Wert;
                    float temp = temp0 / this.ppmProMlWert;
                    temp2 = Kalibrierungssoftware.nf((float)temp, (int)0, (int)2);
                    this.text("Spritze nun " + temp2.replace('.', ',') + " ml in die Messkammer, um eine Konzen-\ntration von 40 ppm zu erhalten.", 220.0f, 533.0f);
                }
                this.textSize(26.0f);
                this.text("weiter", 465.0f, 630.0f);
            }
        }
        this.textSize(14.0f);
        if (this.mousePressed && this.mouseX > 550 && this.mouseX < 650 && this.mouseY - this.translation > 550 && this.mouseY - this.translation < 590) {
            this.aktuellerZyklus = 0;
            this.wait = true;
            this.myPort.clear();
            int i = this.aktuelleKonzentration * this.anzahlZyklen;
            while (i < this.aktuelleKonzentration * this.anzahlZyklen + this.anzahlZyklen) {
                int j = 0;
                while (j < 50) {
                    this.Messdaten[i][j] = 0.0f;
                    ++j;
                }
                ++i;
            }
        }
        this.popMatrix();
    }

    public void ErklaerungMerkmale() {
        if (this.erklaerung) {
            this.fill(200, 220.0f);
            this.noStroke();
            this.rect(0.0f, 0.0f, this.width, this.height);
            this.fill(255);
            this.stroke(0);
            this.rect(50.0f, 150.0f, 950.0f, 335.0f);
            this.fill(0);
            this.noStroke();
            this.textSize(20.0f);
            this.text("Bestimme nun die Unterschiede zwischen den Kurven. Du hast die Auswahl zwischen Maxi-\nmum, Minimum, Steigung und Mittelwert in verschiedenen Bereichen.", 60.0f, 180.0f);
            this.text("Klicke mit der Maus auf die Buttons auf der linken Seite, um ein Merkmal auszuw\u00e4hlen. Du\nkannst den Bereich, in dem diese Merkmale bestimmt werden, im Graphen verschieben,\nindem du mit der Maus in diesen Bereich klickst und die Maus gedr\u00fcckt h\u00e4lst.", 60.0f, 270.0f);
            this.text("Klickst du ein zweites Mal auf die linken Buttons wird deine Auswahl aufgehoben.", 60.0f, 380.0f);
            this.text("W\u00e4hle zwei Merkmale aus. Anschlie\u00dfend erscheint ein 'weiter' Button, der dich wieder in\nden Selbstlernkurs f\u00fchrt.", 60.0f, 430.0f);
            this.fill(255);
            if (this.mouseX > 475 && this.mouseX < 625 && this.mouseY > 500 && this.mouseY < 550) {
                this.fill(255);
            } else {
                this.fill(220);
            }
            this.stroke(0);
            this.rect(475.0f, 500.0f, 150.0f, 50.0f);
            this.fill(0);
            this.text("Verstanden", 495.0f, 530.0f);
        } else {
            this.preview();
            if (this.mouseX > 475 && this.mouseX < 575 && this.mouseY - this.translation > 900 && this.mouseY - this.translation < 950) {
                this.fill(200);
            } else {
                this.fill(255);
            }
            if (this.anzahlMerkmale == 2 && !this.unbekannteKonzentration) {
                this.rect(475.0f, 900.0f, 100.0f, 50.0f);
                this.fill(0);
                this.text("weiter", 495.0f, 930.0f);
            }
        }
    }

    public void preview() {
        int j;
        int i;
        this.fill(255);
        this.rect(120.0f, 500.0f, 360.0f, 300.0f);
        this.rect(520.0f, 500.0f, 360.0f, 300.0f);
        if (this.unbekannteKonzentration) {
            this.fill(255);
            this.textSize(20.0f);
            this.text("Merkmale der unbekannten Konzentration:", 275.0f, 860.0f);
        }
        float MerkmaleMaxMax = 0.0f;
        float MerkmaleMinMax = 0.0f;
        float MerkmaleMWMax = 0.0f;
        float MerkmaleSlopeMax = 0.0f;
        float MerkmaleSlopeMin = 1.0E9f;
        int i2 = 0;
        while (i2 < this.anzahlKonzentrationen) {
            int j2 = 0;
            while (j2 < this.anzahlZyklen) {
                if (this.MerkmalMaximum[i2 * this.anzahlZyklen + j2] > MerkmaleMaxMax) {
                    MerkmaleMaxMax = this.MerkmalMaximum[i2 * this.anzahlZyklen + j2] * 1.115f;
                }
                if (this.MerkmalMinimum[i2 * this.anzahlZyklen + j2] > MerkmaleMinMax) {
                    MerkmaleMinMax = this.MerkmalMinimum[i2 * this.anzahlZyklen + j2] * 1.115f;
                }
                if (this.MerkmalMittelwert[i2 * this.anzahlZyklen + j2] > MerkmaleMWMax) {
                    MerkmaleMWMax = this.MerkmalMittelwert[i2 * this.anzahlZyklen + j2] * 1.115f;
                }
                if (this.MerkmalSteigung[i2 * this.anzahlZyklen + j2] > MerkmaleSlopeMax) {
                    MerkmaleSlopeMax = this.MerkmalSteigung[i2 * this.anzahlZyklen + j2];
                }
                if (this.MerkmalSteigung[i2 * this.anzahlZyklen + j2] < MerkmaleSlopeMin) {
                    MerkmaleSlopeMin = this.MerkmalSteigung[i2 * this.anzahlZyklen + j2];
                }
                ++j2;
            }
            ++i2;
        }
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2);
        this.rotate(4.712389f);
        this.fill(0);
        this.text("k\u03a9", -125.0f, -420.0f);
        this.text("0", -265.0f, -420.0f);
        this.stroke(200);
        this.line(10.0f, -405.0f, 10.0f, -45.0f);
        this.line(10.0f, -5.0f, 10.0f, 355.0f);
        this.popMatrix();
        int anz = 0;
        if (this.MaxAktiv) {
            ++anz;
        }
        if (this.MinAktiv) {
            ++anz;
        }
        if (this.MWAktiv) {
            ++anz;
        }
        if (this.SteigAktiv && anz == 1) {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(4.712389f);
            this.fill(0);
            this.text("k\u03a9/Messpunkt", -160.0f, -20.0f);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleSlopeMax / 1000.0f)), -10.0f, -20.0f);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleSlopeMin / 1000.0f)), -255.0f, -20.0f);
            this.stroke(200);
            this.line(-230.0f, -5.0f, -230.0f, 355.0f);
            this.popMatrix();
        } else {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(4.712389f);
            this.fill(0);
            this.text("k\u03a9", -125.0f, -20.0f);
            this.text("0", -265.0f, -20.0f);
            this.popMatrix();
        }
        this.stroke(0);
        this.textAlign(3);
        if (this.MaxAktiv && this.MinAktiv && !this.MWAktiv && !this.SteigAktiv) {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(4.712389f);
            this.fill(0);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMaxMax / 1000.0f)), 10.0f, -420.0f);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMinMax / 1000.0f)), 10.0f, -20.0f);
            this.popMatrix();
            this.fill(0.0f, 0.0f, 255.0f, 50.0f);
            this.rect(120.0f, 500.0f, 360.0f, 300.0f);
            this.fill(255.0f, 0.0f, 0.0f, 50.0f);
            this.rect(520.0f, 500.0f, 360.0f, 300.0f);
            this.fill(0);
            this.textSize(18.0f);
            this.text("Maximum", 295.0f, 485.0f);
            this.text("Minimum", 695.0f, 485.0f);
            i = 0;
            while (i < this.anzahlKonzentrationen) {
                j = 0;
                while (j < this.anzahlZyklen) {
                    this.noStroke();
                    if (i == 0) {
                        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
                    } else if (i == 1) {
                        this.fill(0.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 2) {
                        this.fill(0.0f, 200.0f, 0.0f, 100.0f);
                    } else if (i == 3) {
                        this.fill(255.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 4) {
                        this.fill(255.0f, 255.0f, 0.0f, 100.0f);
                    }
                    this.ellipse(150 + 60 * i, 800.0f - 300.0f * this.MerkmalMaximum[i * this.anzahlZyklen + j] / MerkmaleMaxMax, 10.0f, 10.0f);
                    this.ellipse(550 + 60 * i, 800.0f - 300.0f * this.MerkmalMinimum[i * this.anzahlZyklen + j] / MerkmaleMinMax, 10.0f, 10.0f);
                    ++j;
                }
                ++i;
            }
            if (this.unbekannteKonzentration) {
                this.fill(0, 100.0f);
                this.ellipse(450.0f, 800.0f - 300.0f * this.MerkmalMaximumUnbekannt / MerkmaleMaxMax, 10.0f, 10.0f);
                this.ellipse(850.0f, 800.0f - 300.0f * this.MerkmalMinimumUnbekannt / MerkmaleMinMax, 10.0f, 10.0f);
                this.fill(255);
                this.text("Maximum: " + PApplet.parseInt((float)this.MerkmalMaximumUnbekannt) / 1000 + " k\u03a9", 500.0f, 910.0f);
                this.text("Minimum: " + PApplet.parseInt((float)this.MerkmalMinimumUnbekannt) / 1000 + " k\u03a9", 500.0f, 940.0f);
            }
        } else if (this.MaxAktiv && this.SteigAktiv && !this.MWAktiv && !this.MinAktiv) {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(4.712389f);
            this.fill(0);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMaxMax / 1000.0f)), 10.0f, -420.0f);
            this.popMatrix();
            this.fill(0.0f, 0.0f, 255.0f, 50.0f);
            this.rect(120.0f, 500.0f, 360.0f, 300.0f);
            this.fill(255.0f, 255.0f, 0.0f, 50.0f);
            this.rect(520.0f, 500.0f, 360.0f, 300.0f);
            this.fill(0);
            this.textSize(18.0f);
            this.text("Maximum", 295.0f, 485.0f);
            this.text("Steigung", 695.0f, 485.0f);
            i = 0;
            while (i < this.anzahlKonzentrationen) {
                j = 0;
                while (j < this.anzahlZyklen) {
                    this.noStroke();
                    if (i == 0) {
                        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
                    } else if (i == 1) {
                        this.fill(0.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 2) {
                        this.fill(0.0f, 200.0f, 0.0f, 100.0f);
                    } else if (i == 3) {
                        this.fill(255.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 4) {
                        this.fill(255.0f, 255.0f, 0.0f, 100.0f);
                    }
                    this.ellipse(150 + 60 * i, 800.0f - 300.0f * this.MerkmalMaximum[i * this.anzahlZyklen + j] / MerkmaleMaxMax, 10.0f, 10.0f);
                    this.ellipse(550 + 60 * i, 770.0f - 240.0f * ((this.MerkmalSteigung[i * this.anzahlZyklen + j] - MerkmaleSlopeMin) / (MerkmaleSlopeMax - MerkmaleSlopeMin)), 10.0f, 10.0f);
                    ++j;
                }
                ++i;
            }
            if (this.unbekannteKonzentration) {
                this.fill(0, 100.0f);
                this.ellipse(450.0f, 800.0f - 300.0f * this.MerkmalMaximumUnbekannt / MerkmaleMaxMax, 10.0f, 10.0f);
                this.ellipse(850.0f, 800.0f - 300.0f * (this.MerkmalSteigungUnbekannt - MerkmaleSlopeMin) / (MerkmaleSlopeMax - MerkmaleSlopeMin), 10.0f, 10.0f);
                this.fill(255);
                this.text("Maximum: " + PApplet.parseInt((float)this.MerkmalMaximumUnbekannt) / 1000 + " k\u03a9", 500.0f, 910.0f);
                this.text("Steigung: " + PApplet.parseInt((float)this.MerkmalSteigungUnbekannt) / 1000 + " k\u03a9/Messpunkt", 500.0f, 940.0f);
            }
        } else if (this.MaxAktiv && this.MWAktiv && !this.MinAktiv && !this.SteigAktiv) {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(4.712389f);
            this.fill(0);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMaxMax / 1000.0f)), 10.0f, -420.0f);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMWMax / 1000.0f)), 10.0f, -20.0f);
            this.popMatrix();
            this.fill(0.0f, 0.0f, 255.0f, 50.0f);
            this.rect(120.0f, 500.0f, 360.0f, 300.0f);
            this.fill(0.0f, 255.0f, 0.0f, 50.0f);
            this.rect(520.0f, 500.0f, 360.0f, 300.0f);
            this.fill(0);
            this.textSize(18.0f);
            this.text("Maximum", 295.0f, 485.0f);
            this.text("Mittelwert", 695.0f, 485.0f);
            i = 0;
            while (i < this.anzahlKonzentrationen) {
                j = 0;
                while (j < this.anzahlZyklen) {
                    this.noStroke();
                    if (i == 0) {
                        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
                    } else if (i == 1) {
                        this.fill(0.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 2) {
                        this.fill(0.0f, 200.0f, 0.0f, 100.0f);
                    } else if (i == 3) {
                        this.fill(255.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 4) {
                        this.fill(255.0f, 255.0f, 0.0f, 100.0f);
                    }
                    this.ellipse(150 + 60 * i, 800.0f - 300.0f * this.MerkmalMaximum[i * this.anzahlZyklen + j] / MerkmaleMaxMax, 10.0f, 10.0f);
                    this.ellipse(550 + 60 * i, 800.0f - 300.0f * (this.MerkmalMittelwert[i * this.anzahlZyklen + j] / MerkmaleMWMax), 10.0f, 10.0f);
                    ++j;
                }
                ++i;
            }
            if (this.unbekannteKonzentration) {
                this.fill(0, 100.0f);
                this.ellipse(450.0f, 800.0f - 300.0f * this.MerkmalMaximumUnbekannt / MerkmaleMaxMax, 10.0f, 10.0f);
                this.ellipse(850.0f, 800.0f - 300.0f * this.MerkmalMittelwertUnbekannt / MerkmaleMWMax, 10.0f, 10.0f);
                this.fill(255);
                this.text("Maximum: " + PApplet.parseInt((float)this.MerkmalMaximumUnbekannt) / 1000 + " k\u03a9", 500.0f, 910.0f);
                this.text("Mittelwert: " + PApplet.parseInt((float)this.MerkmalMittelwertUnbekannt) / 1000 + " k\u03a9", 500.0f, 940.0f);
            }
        } else if (this.MinAktiv && this.MWAktiv && !this.MaxAktiv && !this.SteigAktiv) {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(4.712389f);
            this.fill(0);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMinMax / 1000.0f)), 10.0f, -420.0f);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMWMax / 1000.0f)), 10.0f, -20.0f);
            this.popMatrix();
            this.fill(255.0f, 0.0f, 0.0f, 50.0f);
            this.rect(120.0f, 500.0f, 360.0f, 300.0f);
            this.fill(0.0f, 255.0f, 0.0f, 50.0f);
            this.rect(520.0f, 500.0f, 360.0f, 300.0f);
            this.fill(0);
            this.textSize(18.0f);
            this.text("Minimum", 265.0f, 485.0f);
            this.text("Mittelwert", 665.0f, 485.0f);
            i = 0;
            while (i < this.anzahlKonzentrationen) {
                j = 0;
                while (j < this.anzahlZyklen) {
                    this.noStroke();
                    if (i == 0) {
                        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
                    } else if (i == 1) {
                        this.fill(0.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 2) {
                        this.fill(0.0f, 200.0f, 0.0f, 100.0f);
                    } else if (i == 3) {
                        this.fill(255.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 4) {
                        this.fill(255.0f, 255.0f, 0.0f, 100.0f);
                    }
                    this.ellipse(150 + 60 * i, 800.0f - 300.0f * this.MerkmalMinimum[i * this.anzahlZyklen + j] / MerkmaleMinMax, 10.0f, 10.0f);
                    this.ellipse(550 + 60 * i, 800.0f - 300.0f * (this.MerkmalMittelwert[i * this.anzahlZyklen + j] / MerkmaleMWMax), 10.0f, 10.0f);
                    ++j;
                }
                ++i;
            }
            if (this.unbekannteKonzentration) {
                this.fill(0, 100.0f);
                this.ellipse(450.0f, 800.0f - 300.0f * this.MerkmalMinimumUnbekannt / MerkmaleMinMax, 10.0f, 10.0f);
                this.ellipse(850.0f, 800.0f - 300.0f * this.MerkmalMittelwertUnbekannt / MerkmaleMWMax, 10.0f, 10.0f);
                this.fill(255);
                this.text("Minimum: " + PApplet.parseInt((float)this.MerkmalMinimumUnbekannt) / 1000 + " k\u03a9", 500.0f, 910.0f);
                this.text("Mittelwert: " + PApplet.parseInt((float)this.MerkmalMittelwertUnbekannt) / 1000 + " k\u03a9", 500.0f, 940.0f);
            }
        } else if (this.MinAktiv && this.SteigAktiv && !this.MaxAktiv && !this.MWAktiv) {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(4.712389f);
            this.fill(0);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMinMax / 1000.0f)), 10.0f, -420.0f);
            this.popMatrix();
            this.fill(255.0f, 0.0f, 0.0f, 50.0f);
            this.rect(120.0f, 500.0f, 360.0f, 300.0f);
            this.fill(255.0f, 255.0f, 0.0f, 50.0f);
            this.rect(520.0f, 500.0f, 360.0f, 300.0f);
            this.fill(0);
            this.textSize(18.0f);
            this.text("Minimum", 295.0f, 485.0f);
            this.text("Steigung", 695.0f, 485.0f);
            i = 0;
            while (i < this.anzahlKonzentrationen) {
                j = 0;
                while (j < this.anzahlZyklen) {
                    this.noStroke();
                    if (i == 0) {
                        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
                    } else if (i == 1) {
                        this.fill(0.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 2) {
                        this.fill(0.0f, 200.0f, 0.0f, 100.0f);
                    } else if (i == 3) {
                        this.fill(255.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 4) {
                        this.fill(255.0f, 255.0f, 0.0f, 100.0f);
                    }
                    this.ellipse(150 + 60 * i, 800.0f - 300.0f * this.MerkmalMinimum[i * this.anzahlZyklen + j] / MerkmaleMinMax, 10.0f, 10.0f);
                    this.ellipse(550 + 60 * i, 750.0f - 280.0f * ((this.MerkmalSteigung[i * this.anzahlZyklen + j] - MerkmaleSlopeMin) / (MerkmaleSlopeMax - MerkmaleSlopeMin)), 10.0f, 10.0f);
                    ++j;
                }
                ++i;
            }
            if (this.unbekannteKonzentration) {
                this.fill(0, 100.0f);
                this.ellipse(450.0f, 800.0f - 300.0f * this.MerkmalMinimumUnbekannt / MerkmaleMinMax, 10.0f, 10.0f);
                this.ellipse(850.0f, 800.0f - 300.0f * (this.MerkmalSteigungUnbekannt - MerkmaleSlopeMin) / (MerkmaleSlopeMax - MerkmaleSlopeMin), 10.0f, 10.0f);
                this.fill(255);
                this.text("Minimum: " + PApplet.parseInt((float)this.MerkmalMinimumUnbekannt) / 1000 + " k\u03a9", 500.0f, 910.0f);
                this.text("Steigung: " + PApplet.parseInt((float)this.MerkmalSteigungUnbekannt) / 1000 + " k\u03a9/Messpunkt", 500.0f, 940.0f);
            }
        } else if (this.MWAktiv && this.SteigAktiv && !this.MaxAktiv && !this.MinAktiv) {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2);
            this.rotate(4.712389f);
            this.fill(0);
            this.text(Kalibrierungssoftware.round((float)(MerkmaleMWMax / 1000.0f)), 10.0f, -420.0f);
            this.popMatrix();
            this.fill(0.0f, 255.0f, 0.0f, 50.0f);
            this.rect(120.0f, 500.0f, 360.0f, 300.0f);
            this.fill(255.0f, 255.0f, 0.0f, 50.0f);
            this.rect(520.0f, 500.0f, 360.0f, 300.0f);
            this.fill(0);
            this.textSize(18.0f);
            this.text("Mittelwert", 295.0f, 485.0f);
            this.text("Steigung", 695.0f, 485.0f);
            i = 0;
            while (i < this.anzahlKonzentrationen) {
                j = 0;
                while (j < this.anzahlZyklen) {
                    this.noStroke();
                    if (i == 0) {
                        this.fill(255.0f, 0.0f, 0.0f, 100.0f);
                    } else if (i == 1) {
                        this.fill(0.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 2) {
                        this.fill(0.0f, 200.0f, 0.0f, 100.0f);
                    } else if (i == 3) {
                        this.fill(255.0f, 0.0f, 255.0f, 100.0f);
                    } else if (i == 4) {
                        this.fill(255.0f, 255.0f, 0.0f, 100.0f);
                    }
                    this.ellipse(150 + 60 * i, 800.0f - 300.0f * (this.MerkmalMittelwert[i * this.anzahlZyklen + j] / MerkmaleMWMax), 10.0f, 10.0f);
                    this.ellipse(550 + 60 * i, 750.0f - 280.0f * ((this.MerkmalSteigung[i * this.anzahlZyklen + j] - MerkmaleSlopeMin) / (MerkmaleSlopeMax - MerkmaleSlopeMin)), 10.0f, 10.0f);
                    ++j;
                }
                ++i;
            }
            if (this.unbekannteKonzentration) {
                this.fill(0, 100.0f);
                this.ellipse(450.0f, 800.0f - 300.0f * this.MerkmalMittelwertUnbekannt / MerkmaleMWMax, 10.0f, 10.0f);
                this.ellipse(850.0f, 800.0f - 300.0f * (this.MerkmalSteigungUnbekannt - MerkmaleSlopeMin) / (MerkmaleSlopeMax - MerkmaleSlopeMin), 10.0f, 10.0f);
                this.fill(255);
                this.text("Mittelwert: " + PApplet.parseInt((float)this.MerkmalMittelwertUnbekannt) / 1000 + " k\u03a9", 500.0f, 910.0f);
                this.text("Steigung: " + PApplet.parseInt((float)this.MerkmalSteigungUnbekannt) / 1000 + " k\u03a9/Messpunkt", 500.0f, 940.0f);
            }
        }
        this.stroke(0);
        i = 0;
        while (i < 5) {
            this.line(180 + 60 * i, 500.0f, 180 + 60 * i, 810.0f);
            this.line(580 + 60 * i, 500.0f, 580 + 60 * i, 810.0f);
            ++i;
        }
        this.textAlign(0);
        this.fill(0);
        this.noStroke();
        this.textSize(14.0f);
        this.text("0 ppm", 130.0f, 820.0f);
        this.text(String.valueOf(this.Konzentration1Wert) + " ppm", 185.0f, 820.0f);
        this.text(String.valueOf(this.Konzentration2Wert) + " ppm", 245.0f, 820.0f);
        this.text(String.valueOf(this.Konzentration3Wert) + " ppm", 305.0f, 820.0f);
        this.text("40 ppm", 365.0f, 820.0f);
        this.text("?? ppm", 425.0f, 820.0f);
        this.text("0ppm", 530.0f, 820.0f);
        this.text(String.valueOf(this.Konzentration1Wert) + " ppm", 585.0f, 820.0f);
        this.text(String.valueOf(this.Konzentration2Wert) + " ppm", 645.0f, 820.0f);
        this.text(String.valueOf(this.Konzentration3Wert) + " ppm", 705.0f, 820.0f);
        this.text("40 ppm", 765.0f, 820.0f);
        this.text("?? ppm", 825.0f, 820.0f);
        this.stroke(0);
        this.textSize(20.0f);
    }

    public void KonzProMl() {
        this.textSize(20.0f);
        this.text("Bevor du kalibrieren kannst, f\u00fclle bitte die folgenden Felder aus:", 20.0f, 50.0f);
        this.textSize(18.0f);
        this.text("1. Um wieviel ppm erh\u00f6ht sich die Konzentration in der Messkammer pro eingespritzten ml?", 100.0f, 120.0f);
        this.text("2. Welche 5 Konzentrationen m\u00f6chtest du f\u00fcr die Kalibrierung verwenden? Trage sie in aufsteigender\nReihenfolge ein.\nBeachte: 0ppm und 40ppm musst du auf jeden Fall messen!", 100.0f, 250.0f);
        this.textSize(25.0f);
        this.text("ppm/ml", 525.0f, 175.0f);
        this.text("1:", 350.0f, 370.0f);
        this.text("2:", 350.0f, 420.0f);
        this.text("3:", 350.0f, 470.0f);
        this.text("4:", 350.0f, 520.0f);
        this.text("5:", 350.0f, 570.0f);
        this.text("0    ppm", 410.0f, 370.0f);
        this.text("ppm", 458.0f, 420.0f);
        this.text("ppm", 458.0f, 470.0f);
        this.text("ppm", 458.0f, 520.0f);
        this.text("40  ppm", 408.0f, 570.0f);
        if (this.mouseX > 400 && this.mouseX < 630 && this.mouseY > 700 && this.mouseY < 750) {
            this.fill(255);
        } else {
            this.fill(220);
        }
        this.rect(400.0f, 700.0f, 180.0f, 50.0f);
        this.fill(0);
        this.textSize(20.0f);
        this.text("Messung starten", 410.0f, 730.0f);
    }

    public void Speichern() {
        int i = 0;
        while (i < this.anzahlZyklen * this.anzahlKonzentrationen) {
            float max = 0.0f;
            float min = 1.0E9f;
            float slope = 0.0f;
            float mean = 0.0f;
            int j = 0;
            while (j < 50) {
                if (j >= this.GrenzeMaximumLinks && j < this.GrenzeMaximumLinks + 6 && max < this.Messdaten[i][j]) {
                    max = this.Messdaten[i][j];
                    this.MerkmalMaximum[i] = this.Messdaten[i][j];
                }
                if (j >= this.GrenzeMinimumLinks && j < this.GrenzeMinimumLinks + 6 && min > this.Messdaten[i][j]) {
                    min = this.Messdaten[i][j];
                    this.MerkmalMinimum[i] = this.Messdaten[i][j];
                }
                ++j;
            }
            this.MerkmalSteigung[i] = slope = (-this.Messdaten[i][this.GrenzeSteigungLinks] + this.Messdaten[i][this.GrenzeSteigungLinks + 6]) / 6.0f;
            j = 0;
            while (j < 6) {
                mean += this.Messdaten[i][this.GrenzeMittelwertLinks + j];
                ++j;
            }
            this.MerkmalMittelwert[i] = mean /= 6.0f;
            ++i;
        }
        int j = 0;
        while (j < 50) {
            if (j >= this.GrenzeMaximumLinks && j < this.GrenzeMaximumLinks + 6 && this.MerkmalMaximumUnbekannt < this.UnbekannteKonzentrationMessdaten[0][j]) {
                this.MerkmalMaximumUnbekannt = this.UnbekannteKonzentrationMessdaten[0][j];
            }
            if (j >= this.GrenzeMinimumLinks && j < this.GrenzeMinimumLinks + 6 && this.MerkmalMinimumUnbekannt > this.UnbekannteKonzentrationMessdaten[0][j]) {
                this.MerkmalMinimumUnbekannt = this.UnbekannteKonzentrationMessdaten[0][j];
            }
            ++j;
        }
        float mean = 0.0f;
        int j2 = 0;
        while (j2 < 6) {
            mean += this.UnbekannteKonzentrationMessdaten[0][this.GrenzeMittelwertLinks + j2];
            ++j2;
        }
        this.MerkmalMittelwertUnbekannt = mean /= 6.0f;
        this.MerkmalSteigungUnbekannt = (-this.UnbekannteKonzentrationMessdaten[0][this.GrenzeSteigungLinks] + this.UnbekannteKonzentrationMessdaten[0][this.GrenzeSteigungLinks + 6]) / 6.0f;
        String[] Training = new String[this.anzahlKonzentrationen * this.anzahlZyklen];
        int i2 = 0;
        while (i2 < this.anzahlKonzentrationen * this.anzahlZyklen) {
            Training[i2] = "";
            ++i2;
        }
        Training[0] = "let max = false; let min = false; let slope = false; let mean = false; let training_data = [";
        if (this.MaxAktiv && this.MinAktiv) {
            i2 = 0;
            while (i2 < this.anzahlKonzentrationen * this.anzahlZyklen) {
                Training[i2] = String.valueOf(Training[i2]) + "{inputs: [" + this.MerkmalMaximum[i2] + "," + this.MerkmalMinimum[i2] + "], outputs:[" + this.Outputs[i2] + "]},";
                ++i2;
            }
            Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1] = String.valueOf(Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1]) + "]; max = true; min = true;";
        } else if (this.MaxAktiv && this.SteigAktiv) {
            i2 = 0;
            while (i2 < this.anzahlKonzentrationen * this.anzahlZyklen) {
                Training[i2] = String.valueOf(Training[i2]) + "{inputs: [" + this.MerkmalMaximum[i2] + "," + this.MerkmalSteigung[i2] + "], outputs:[" + this.Outputs[i2] + "]},";
                ++i2;
            }
            Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1] = String.valueOf(Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1]) + "]; max = true; slope = true;";
        } else if (this.MaxAktiv && this.MWAktiv) {
            i2 = 0;
            while (i2 < this.anzahlKonzentrationen * this.anzahlZyklen) {
                Training[i2] = String.valueOf(Training[i2]) + "{inputs: [" + this.MerkmalMaximum[i2] + "," + this.MerkmalMittelwert[i2] + "], outputs:[" + this.Outputs[i2] + "]},";
                ++i2;
            }
            Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1] = String.valueOf(Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1]) + "]; max = true; mean = true;";
        } else if (this.MinAktiv && this.SteigAktiv) {
            i2 = 0;
            while (i2 < this.anzahlKonzentrationen * this.anzahlZyklen) {
                Training[i2] = String.valueOf(Training[i2]) + "{inputs: [" + this.MerkmalMinimum[i2] + "," + this.MerkmalSteigung[i2] + "], outputs:[" + this.Outputs[i2] + "]},";
                ++i2;
            }
            Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1] = String.valueOf(Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1]) + "]; min = true; slope = true;";
        } else if (this.MinAktiv && this.MWAktiv) {
            i2 = 0;
            while (i2 < this.anzahlKonzentrationen * this.anzahlZyklen) {
                Training[i2] = String.valueOf(Training[i2]) + "{inputs: [" + this.MerkmalMinimum[i2] + "," + this.MerkmalMittelwert[i2] + "], outputs:[" + this.Outputs[i2] + "]},";
                ++i2;
            }
            Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1] = String.valueOf(Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1]) + "]; min = true; mean = true;";
        } else if (this.SteigAktiv && this.MWAktiv) {
            i2 = 0;
            while (i2 < this.anzahlKonzentrationen * this.anzahlZyklen) {
                Training[i2] = String.valueOf(Training[i2]) + "{inputs: [" + this.MerkmalSteigung[i2] + "," + this.MerkmalMittelwert[i2] + "], outputs:[" + this.Outputs[i2] + "]},";
                ++i2;
            }
            Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1] = String.valueOf(Training[this.anzahlKonzentrationen * this.anzahlZyklen - 1]) + "]; slope = true; mean = true;";
        }
        this.saveStrings("lib/Trainingsdaten.js", Training);
    }

    public void settings() {
        this.size(1050, this.displayHeight);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Kalibrierungssoftware"};
        if (passedArgs != null) {
            PApplet.main((String[])Kalibrierungssoftware.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

