/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Canvas;
import controlP5.ControlEvent;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.ControllerPlug;
import controlP5.Slider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import processing.core.PGraphics;

public class ColorPicker
extends ControlGroup<ColorPicker> {
    protected Slider sliderRed;
    protected Slider sliderGreen;
    protected Slider sliderBlue;
    protected Slider sliderAlpha;
    protected Canvas currentColor;
    private Object _myPlug;
    private String _myPlugName;
    private boolean broadcast;

    public ColorPicker(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0, 0, 255, 10);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected ColorPicker(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this.isBarVisible = false;
        this.isCollapse = false;
        this._myArrayValue = new float[]{255.0f, 255.0f, 255.0f, 255.0f};
        this.currentColor = this.addCanvas(new ColorField());
        this.sliderRed = this.cp5.addSlider(string + "-red", 0.0f, 255.0f, 0, 0, n3, n4);
        this.cp5.removeProperty(this.sliderRed);
        this.sliderRed.setId(0);
        this.sliderRed.setBroadcast(false);
        this.sliderRed.addListener(this);
        this.sliderRed.moveTo(this);
        this.sliderRed.setMoveable(false);
        this.sliderRed.setColorBackground(-10092544);
        this.sliderRed.setColorForeground(-5636096);
        this.sliderRed.setColorActive(-65536);
        this.sliderRed.getCaptionLabel().setVisible(false);
        this.sliderRed.setDecimalPrecision(0);
        this.sliderRed.setValue(255.0f);
        this.sliderGreen = this.cp5.addSlider(string + "-green", 0.0f, 255.0f, 0, n4 + 1, n3, n4);
        this.cp5.removeProperty(this.sliderGreen);
        this.sliderGreen.setId(1);
        this.sliderGreen.setBroadcast(false);
        this.sliderGreen.addListener(this);
        this.sliderGreen.moveTo(this);
        this.sliderGreen.setMoveable(false);
        this.sliderGreen.setColorBackground(-16751104);
        this.sliderGreen.setColorForeground(-16733696);
        this.sliderGreen.setColorActive(-16711936);
        this.sliderGreen.getCaptionLabel().setVisible(false);
        this.sliderGreen.setDecimalPrecision(0);
        this.sliderGreen.setValue(255.0f);
        this.sliderBlue = this.cp5.addSlider(string + "-blue", 0.0f, 255.0f, 0, (n4 + 1) * 2, n3, n4);
        this.cp5.removeProperty(this.sliderBlue);
        this.sliderBlue.setId(2);
        this.sliderBlue.setBroadcast(false);
        this.sliderBlue.addListener(this);
        this.sliderBlue.moveTo(this);
        this.sliderBlue.setMoveable(false);
        this.sliderBlue.setColorBackground(-16777114);
        this.sliderBlue.setColorForeground(-16777046);
        this.sliderBlue.setColorActive(-16776961);
        this.sliderBlue.getCaptionLabel().setVisible(false);
        this.sliderBlue.setDecimalPrecision(0);
        this.sliderBlue.setValue(255.0f);
        this.sliderAlpha = this.cp5.addSlider(string + "-alpha", 0.0f, 255.0f, 0, (n4 + 1) * 3, n3, n4);
        this.cp5.removeProperty(this.sliderAlpha);
        this.sliderAlpha.setId(3);
        this.sliderAlpha.setBroadcast(false);
        this.sliderAlpha.addListener(this);
        this.sliderAlpha.moveTo(this);
        this.sliderAlpha.setMoveable(false);
        this.sliderAlpha.setColorBackground(-10066330);
        this.sliderAlpha.setColorForeground(-5592406);
        this.sliderAlpha.setColorActive(-1);
        this.sliderAlpha.getCaptionLabel().setVisible(false);
        this.sliderAlpha.setDecimalPrecision(0);
        this.sliderAlpha.getValueLabel().setColor(-16777216);
        this.sliderAlpha.setValue(255.0f);
        this._myPlug = this.cp5.papplet;
        this._myPlugName = this.getName();
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        this.broadcast = true;
    }

    public ColorPicker plugTo(Object object) {
        this._myPlug = object;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        return this;
    }

    public ColorPicker plugTo(Object object, String string) {
        this._myPlug = object;
        this._myPlugName = string;
        if (!ControllerPlug.checkPlug(this._myPlug, this._myPlugName, new Class[]{Integer.TYPE})) {
            this._myPlug = null;
        }
        return this;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent controlEvent) {
        if (this.broadcast) {
            this._myArrayValue[controlEvent.getId()] = controlEvent.getValue();
            this.broadcast();
        }
    }

    private ColorPicker broadcast() {
        ControlEvent controlEvent = new ControlEvent(this);
        this.setValue(this.getColorValue());
        this.cp5.getControlBroadcaster().broadcast(controlEvent, 2);
        if (this._myPlug != null) {
            try {
                Method method = this._myPlug.getClass().getMethod(this._myPlugName, Integer.TYPE);
                method.invoke(this._myPlug, this.getColorValue());
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public ColorPicker setArrayValue(float[] fArray) {
        this.broadcast = false;
        this.sliderRed.setValue(fArray[0]);
        this.sliderGreen.setValue(fArray[1]);
        this.sliderBlue.setValue(fArray[2]);
        this.sliderAlpha.setValue(fArray[3]);
        this.broadcast = true;
        this._myArrayValue = fArray;
        return this.broadcast();
    }

    @Override
    public ColorPicker setColorValue(int n) {
        this.setArrayValue(new float[]{n >> 16 & 0xFF, n >> 8 & 0xFF, n >> 0 & 0xFF, n >> 24 & 0xFF});
        return this;
    }

    public int getColorValue() {
        return 0xFFFFFFFF & (int)this._myArrayValue[3] << 24 | (int)this._myArrayValue[0] << 16 | (int)this._myArrayValue[1] << 8 | (int)this._myArrayValue[2] << 0;
    }

    @Override
    public String getInfo() {
        return "type:\tColorPicker\n" + super.toString();
    }

    private class ColorField
    extends Canvas {
        private ColorField() {
        }

        @Override
        public void draw(PGraphics pGraphics) {
            pGraphics.fill(ColorPicker.this._myArrayValue[0], ColorPicker.this._myArrayValue[1], ColorPicker.this._myArrayValue[2], ColorPicker.this._myArrayValue[3]);
            pGraphics.rect(0.0f, 44.0f, (float)ColorPicker.this.getWidth(), 15.0f);
        }
    }
}

