/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CallbackEvent;
import controlP5.Canvas;
import controlP5.ColorWheel;
import controlP5.ControlFont;
import controlP5.ControlKey;
import controlP5.ControlP5;
import controlP5.ControlP5Base;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerList;
import controlP5.Knob;
import controlP5.Numberbox;
import controlP5.Slider;
import controlP5.Tab;
import controlP5.Textarea;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public final class ControlWindow {
    protected ControlP5 cp5;
    protected Controller<?> isControllerActive;
    public int background = 0;
    protected CColor color = new CColor();
    private String _myName = "main";
    protected PApplet _myApplet;
    protected ControllerList _myTabs;
    protected boolean isVisible = true;
    protected boolean isInit = false;
    protected boolean isRemove = false;
    protected CDrawable _myDrawable;
    protected boolean isAutoDraw;
    protected boolean isUpdate;
    protected List<Canvas> _myCanvas;
    protected boolean isDrawBackground = true;
    protected boolean isUndecorated = false;
    protected float[] autoPosition = new float[]{10.0f, 30.0f, 0.0f};
    protected float tempAutoPositionHeight = 0.0f;
    protected boolean rendererNotification = false;
    protected float[] positionOfTabs = new float[]{0.0f, 0.0f, 0.0f};
    private int _myFrameCount = 0;
    private boolean isMouse = true;
    private Pointer _myPointer;
    private int mouseWheelMoved = 0;
    private List<ControllerInterface<?>> mouseoverlist;
    private boolean isMouseOver;
    protected int mouseX;
    protected int mouseY;
    protected int pmouseX;
    protected int pmouseY;
    protected boolean mousePressed;
    protected long mousePressedTime;
    protected long pmousePressedTime;
    protected boolean mouselock;
    protected char key;
    protected int keyCode;
    private final int numKeys = 1024;
    private boolean[] keys = new boolean[1024];
    private int numOfActiveKeys = 0;
    private boolean focused = true;
    private boolean isReset = false;
    boolean pmouseReleased;
    boolean pmousePressed;

    public ControlWindow(ControlP5 controlP5, PApplet pApplet) {
        this.mouseoverlist = new ArrayList();
        this.cp5 = controlP5;
        this._myApplet = pApplet;
        this.isAutoDraw = true;
        this.init();
    }

    protected void init() {
        this._myPointer = new Pointer();
        this._myCanvas = new ArrayList<Canvas>();
        this._myTabs = new ControllerList();
        this._myTabs.add(new Tab(this.cp5, this, "global"));
        this._myTabs.add(new Tab(this.cp5, this, "default"));
        this.activateTab((Tab)this._myTabs.get(1));
        if (!this.isInit) {
            this._myApplet.registerMethod("pre", (Object)this);
            this._myApplet.registerMethod("draw", (Object)this);
            if (!this.cp5.isAndroid) {
                this._myApplet.registerMethod("keyEvent", (Object)this);
                this._myApplet.registerMethod("mouseEvent", (Object)this);
            }
        }
        this.mousePressedTime = System.currentTimeMillis();
        this.pmousePressedTime = System.currentTimeMillis();
        this.isInit = true;
    }

    public Tab getCurrentTab() {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).isActive()) continue;
            return (Tab)this._myTabs.get(i);
        }
        return null;
    }

    public ControlWindow activateTab(String string) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).getName().equals(string)) continue;
            if (!((Tab)this._myTabs.get((int)i)).isActive) {
                this.resetMouseOver();
            }
            this.activateTab((Tab)this._myTabs.get(i));
        }
        return this;
    }

    public ControlWindow removeTab(Tab tab) {
        this._myTabs.remove(tab);
        return this;
    }

    public Tab add(Tab tab) {
        this._myTabs.add(tab);
        return tab;
    }

    public Tab addTab(String string) {
        return this.getTab(string);
    }

    protected ControlWindow activateTab(Tab tab) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (this._myTabs.get(i) == tab) {
                if (!((Tab)this._myTabs.get((int)i)).isActive) {
                    this.resetMouseOver();
                }
                ((Tab)this._myTabs.get(i)).setActive(true);
                continue;
            }
            ((Tab)this._myTabs.get(i)).setActive(false);
        }
        return this;
    }

    public ControllerList getTabs() {
        return this._myTabs;
    }

    public Tab getTab(String string) {
        return this.cp5.getTab(this, string);
    }

    public ControlWindow setPositionOfTabs(int n, int n2) {
        this.positionOfTabs[0] = n;
        this.positionOfTabs[1] = n2;
        return this;
    }

    public float[] getPositionOfTabs() {
        return this.positionOfTabs;
    }

    void setAllignmentOfTabs(int n, int n2) {
    }

    void setAllignmentOfTabs(int n, int n2, int n3) {
    }

    void setAllignmentOfTabs(int n) {
    }

    public void remove() {
        for (int i = this._myTabs.size() - 1; i >= 0; --i) {
            ((Tab)this._myTabs.get(i)).remove();
        }
        this._myTabs.clear();
        this._myTabs.clearDrawable();
    }

    public ControlWindow clear() {
        this.remove();
        return this;
    }

    protected void updateFont(ControlFont controlFont) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).updateFont(controlFont);
        }
    }

    @ControlP5.Invisible
    public void updateEvents() {
        this.handleMouseOver();
        this.handleMouseWheelMoved();
        if (this._myTabs.size() <= 0) {
            return;
        }
        this._myTabs.get(0).updateEvents();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).continuousUpdateEvents();
            if (!((Tab)this._myTabs.get(i)).isActive() || !((Tab)this._myTabs.get(i)).isVisible()) continue;
            this._myTabs.get(i).updateEvents();
        }
    }

    public boolean isMouseOver() {
        if (this._myFrameCount + 1 < this._myApplet.frameCount) {
            this.resetMouseOver();
        }
        return this.isVisible ? this.isMouseOver : false;
    }

    public boolean isMouseOver(ControllerInterface<?> controllerInterface) {
        return this.mouseoverlist.contains(controllerInterface);
    }

    public void resetMouseOver() {
        this.isMouseOver = false;
        for (int i = this.mouseoverlist.size() - 1; i >= 0; --i) {
            this.mouseoverlist.get(i).setMouseOver(false);
        }
        this.mouseoverlist.clear();
    }

    public ControllerInterface<?> getFirstFromMouseOverList() {
        if (this.getMouseOverList().isEmpty()) {
            return null;
        }
        return this.getMouseOverList().get(0);
    }

    public List<ControllerInterface<?>> getMouseOverList() {
        return this.mouseoverlist;
    }

    private ControlWindow handleMouseOver() {
        for (int i = this.mouseoverlist.size() - 1; i >= 0; --i) {
            if (this.mouseoverlist.get(i).isMouseOver() && this.isVisible) continue;
            this.mouseoverlist.remove(i);
        }
        this.isMouseOver = this.mouseoverlist.size() > 0;
        return this;
    }

    public ControlWindow removeMouseOverFor(ControllerInterface<?> controllerInterface) {
        this.mouseoverlist.remove(controllerInterface);
        return this;
    }

    protected ControlWindow setMouseOverController(ControllerInterface<?> controllerInterface) {
        if (!this.mouseoverlist.contains(controllerInterface) && this.isVisible && controllerInterface.isVisible()) {
            this.mouseoverlist.add(controllerInterface);
        }
        this.isMouseOver = true;
        return this;
    }

    public void update() {
        this._myTabs.get(0).update();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).update();
        }
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).setUpdate(bl);
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public ControlWindow addCanvas(Canvas canvas) {
        this._myCanvas.add(canvas);
        canvas.setControlWindow(this);
        canvas.setup(this._myApplet.g);
        return this;
    }

    public ControlWindow removeCanvas(Canvas canvas) {
        this._myCanvas.remove(canvas);
        return this;
    }

    public ControlWindow pre() {
        if (this._myFrameCount + 1 < this._myApplet.frameCount) {
            if (this.isReset) {
                this.resetMouseOver();
                this.isReset = false;
            }
        } else {
            this.isReset = true;
        }
        if (this.papplet().focused != this.focused) {
            this.clearKeys();
            this.mousePressed = false;
            this.focused = this.papplet().focused;
        }
        return this;
    }

    public void mouseEvent(int n, int n2, boolean bl) {
        this.mouseX = n - this.cp5.pgx - this.cp5.ox;
        this.mouseY = n2 - this.cp5.pgy - this.cp5.oy;
        if (bl && !this.pmousePressed) {
            this.updateEvents();
            this.mousePressedEvent();
            this.pmousePressedTime = this.mousePressedTime;
            this.mousePressedTime = System.currentTimeMillis();
            this.pmousePressed = true;
            this.pmouseReleased = false;
        } else if (!bl && !this.pmouseReleased) {
            this.updateEvents();
            this.mouseReleasedEvent();
            for (ControllerInterface<?> controllerInterface : this.mouseoverlist) {
                if (controllerInterface instanceof Controller) {
                    Controller controller = (Controller)controllerInterface;
                    controller.onLeave();
                    controller.onRelease();
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(controller, 7));
                    controller.callListener(7);
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent(controller, 2));
                    controller.callListener(2);
                    continue;
                }
                if (!(controllerInterface instanceof ControllerGroup)) continue;
                ((ControllerGroup)controllerInterface).mouseReleased();
            }
            this.resetMouseOver();
            this.pmousePressed = false;
            this.pmouseReleased = true;
        }
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (this.isMouse) {
            this.mouseX = mouseEvent.getX() - this.cp5.pgx - this.cp5.ox;
            this.mouseY = mouseEvent.getY() - this.cp5.pgy - this.cp5.oy;
            if (mouseEvent.getAction() == 1) {
                this.mousePressedEvent();
            }
            if (mouseEvent.getAction() == 2) {
                this.mouseReleasedEvent();
            }
            if (mouseEvent.getAction() == 8) {
                this.setMouseWheelRotation(mouseEvent.getCount());
            }
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (keyEvent.getAction() == 1) {
            this.keys[keyEvent.getKeyCode()] = true;
            ++this.numOfActiveKeys;
            this.cp5.modifiers = keyEvent.getModifiers();
            this.key = keyEvent.getKey();
            this.keyCode = keyEvent.getKeyCode();
        }
        if (keyEvent.getAction() == 2) {
            this.keys[keyEvent.getKeyCode()] = false;
            --this.numOfActiveKeys;
            this.cp5.modifiers = keyEvent.getModifiers();
        }
        if (keyEvent.getAction() == 1 && this.cp5.isShortcuts()) {
            int n = 0;
            boolean[] objectArray = this.keys;
            int keyCode = objectArray.length;
            for (int i = 0; i < keyCode; ++i) {
                boolean controlKey = objectArray[i];
                n += controlKey ? 1 : 0;
            }
            char[] cArray = new char[n];
            n = 0;
            for (keyCode = 0; keyCode < this.keys.length; ++keyCode) {
                if (!this.keys[keyCode]) continue;
                cArray[n++] = (char)keyCode;
            }
            ControlP5Base.KeyCode keyCode2 = new ControlP5Base.KeyCode(cArray);
            if (this.cp5.keymap.containsKey(keyCode2)) {
                for (ControlKey controlKey : (List)this.cp5.keymap.get(keyCode2)) {
                    controlKey.keyEvent();
                }
            }
        }
        this.handleKeyEvent(keyEvent);
    }

    public void clearKeys() {
        this.keys = new boolean[1024];
        this.numOfActiveKeys = 0;
    }

    public void draw(PGraphics pGraphics, int n, int n2) {
    }

    public void draw() {
        this._myFrameCount = this._myApplet.frameCount;
        this.draw(this.cp5.pg);
    }

    public void draw(PGraphics pGraphics) {
        pGraphics.pushMatrix();
        pGraphics.translate((float)this.cp5.ox, (float)this.cp5.oy);
        if (!this.cp5.blockDraw) {
            if (this.cp5.isAndroid) {
                this.mouseEvent(this.cp5.papplet.mouseX, this.cp5.papplet.mouseY, this.cp5.papplet.mousePressed);
            } else {
                this.updateEvents();
            }
            if (this.isVisible) {
                int n;
                int n2;
                if (this.cp5.isGraphics) {
                    pGraphics.beginDraw();
                    if ((this.background >> 24 & 0xFF) != 0) {
                        pGraphics.background(this.background);
                    }
                }
                int n3 = pGraphics.rectMode;
                int n4 = pGraphics.ellipseMode;
                int n5 = pGraphics.imageMode;
                pGraphics.pushStyle();
                pGraphics.rectMode(0);
                pGraphics.ellipseMode(0);
                pGraphics.imageMode(0);
                pGraphics.noStroke();
                if (this._myDrawable != null) {
                    this._myDrawable.draw(pGraphics);
                }
                for (n2 = 0; n2 < this._myCanvas.size(); ++n2) {
                    if (this._myCanvas.get(n2).mode() != 0) continue;
                    this._myCanvas.get(n2).update(this._myApplet);
                    this._myCanvas.get(n2).draw(pGraphics);
                }
                pGraphics.noStroke();
                pGraphics.noFill();
                n2 = (int)this.getPositionOfTabs()[0];
                int n6 = (int)this.getPositionOfTabs()[1];
                int n7 = 0;
                if (this._myTabs.size() > 0) {
                    for (n = 1; n < this._myTabs.size(); ++n) {
                        if (!((Tab)this._myTabs.get(n)).isVisible()) continue;
                        if (n7 < ((Tab)this._myTabs.get(n)).height()) {
                            n7 = ((Tab)this._myTabs.get(n)).height();
                        }
                        ((Tab)this._myTabs.get(n)).setOffset(n2, n6);
                        if (((Tab)this._myTabs.get(n)).isActive()) {
                            ((Tab)this._myTabs.get(n)).draw(pGraphics);
                        }
                        if (((Tab)this._myTabs.get(n)).updateLabel()) {
                            ((Tab)this._myTabs.get(n)).drawLabel(pGraphics);
                        }
                        n2 += ((Tab)this._myTabs.get(n)).width();
                    }
                    this._myTabs.get(0).draw(pGraphics);
                }
                for (n = 0; n < this._myCanvas.size(); ++n) {
                    if (this._myCanvas.get(n).mode() != 1) continue;
                    this._myCanvas.get(n).draw(pGraphics);
                }
                this.pmouseX = this.mouseX;
                this.pmouseY = this.mouseY;
                this.cp5.getTooltip().draw(this);
                pGraphics.rectMode(n3);
                pGraphics.ellipseMode(n4);
                pGraphics.imageMode(n5);
                pGraphics.popStyle();
                if (this.cp5.isGraphics) {
                    pGraphics.endDraw();
                    this.cp5.papplet.image((PImage)pGraphics, (float)this.cp5.pgx, (float)this.cp5.pgy);
                }
            }
        }
        pGraphics.popMatrix();
    }

    public ControlWindow setContext(CDrawable cDrawable) {
        this._myDrawable = cDrawable;
        return this;
    }

    public String name() {
        return this._myName;
    }

    private void mousePressedEvent() {
        if (this.isVisible) {
            this.mousePressed = true;
            this.pmousePressedTime = this.mousePressedTime;
            this.mousePressedTime = System.currentTimeMillis();
            for (int i = 0; i < this._myTabs.size(); ++i) {
                if (!this._myTabs.get(i).setMousePressed(true)) continue;
                this.mouselock = true;
                return;
            }
        }
    }

    private void mouseReleasedEvent() {
        if (this.isVisible) {
            this.mousePressed = false;
            this.mouselock = false;
            for (int i = 0; i < this._myTabs.size(); ++i) {
                this._myTabs.get(i).setMousePressed(false);
            }
        }
    }

    void setMouseWheelRotation(int n) {
        if (this.isMouseOver()) {
            this.mouseWheelMoved = n;
        }
    }

    private void handleMouseWheelMoved() {
        if (this.mouseWheelMoved != 0) {
            CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList(this.mouseoverlist);
            for (ControllerInterface controllerInterface : copyOnWriteArrayList) {
                if (!controllerInterface.isVisible()) continue;
                if (controllerInterface instanceof Controller) {
                    ((Controller)controllerInterface).onScroll(this.mouseWheelMoved);
                    this.cp5.getControlBroadcaster().invokeAction(new CallbackEvent((Controller)controllerInterface, 8));
                    ((Controller)controllerInterface).callListener(8);
                }
                if (controllerInterface instanceof ControllerGroup) {
                    ((ControllerGroup)controllerInterface).onScroll(this.mouseWheelMoved);
                }
                if (controllerInterface instanceof Slider) {
                    ((Slider)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (controllerInterface instanceof Knob) {
                    ((Knob)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (controllerInterface instanceof Numberbox) {
                    ((Numberbox)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (controllerInterface instanceof Textarea) {
                    ((Textarea)controllerInterface).scrolled(this.mouseWheelMoved);
                    break;
                }
                if (!(controllerInterface instanceof ColorWheel)) break;
                ((ColorWheel)controllerInterface).scrolled(this.mouseWheelMoved);
                break;
            }
        }
        this.mouseWheelMoved = 0;
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public void handleKeyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).keyEvent(keyEvent);
        }
    }

    public ControlWindow setColorActive(int n) {
        this.color.setActive(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorActive(n);
        }
        return this;
    }

    public ControlWindow setColorForeground(int n) {
        this.color.setForeground(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorForeground(n);
        }
        return this;
    }

    public ControlWindow setColorBackground(int n) {
        this.color.setBackground(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorBackground(n);
        }
        return this;
    }

    public ControlWindow setColorLabel(int n) {
        this.color.setCaptionLabel(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorLabel(n);
        }
        return this;
    }

    public ControlWindow setColorValue(int n) {
        this.color.setValueLabel(n);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            ((Tab)this.getTabs().get(i)).setColorValue(n);
        }
        return this;
    }

    public ControlWindow setBackground(int n) {
        this.background = n;
        return this;
    }

    public PApplet papplet() {
        return this._myApplet;
    }

    public ControlWindow frameRate(int n) {
        this._myApplet.frameRate((float)n);
        return this;
    }

    public ControlWindow show() {
        this.isVisible = true;
        return this;
    }

    public ControlWindow setDrawBackground(boolean bl) {
        this.isDrawBackground = bl;
        return this;
    }

    public boolean isDrawBackground() {
        return this.isDrawBackground;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected boolean isControllerActive(Controller<?> controller) {
        if (this.isControllerActive == null) {
            return false;
        }
        return this.isControllerActive.equals(controller);
    }

    protected ControlWindow setControllerActive(Controller<?> controller) {
        this.isControllerActive = controller;
        return this;
    }

    public ControlWindow toggleUndecorated() {
        this.setUndecorated(!this.isUndecorated());
        return this;
    }

    public ControlWindow setUndecorated(boolean bl) {
        if (bl != this.isUndecorated()) {
            this.isUndecorated = bl;
            this._myApplet.frame.removeNotify();
            this._myApplet.frame.setUndecorated(this.isUndecorated);
            this._myApplet.setSize(this._myApplet.width, this._myApplet.height);
            this._myApplet.setBounds(0, 0, this._myApplet.width, this._myApplet.height);
            this._myApplet.frame.setSize(this._myApplet.width, this._myApplet.height);
            this._myApplet.frame.addNotify();
        }
        return this;
    }

    public boolean isUndecorated() {
        return this.isUndecorated;
    }

    public ControlWindow setPosition(int n, int n2) {
        return this.setLocation(n, n2);
    }

    public ControlWindow setLocation(int n, int n2) {
        this._myApplet.frame.setLocation(n, n2);
        return this;
    }

    public Pointer getPointer() {
        return this._myPointer;
    }

    public ControlWindow disablePointer() {
        this._myPointer.disable();
        return this;
    }

    public ControlWindow enablePointer() {
        this._myPointer.enable();
        return this;
    }

    public ControlWindow hide() {
        this.isVisible = false;
        this.isMouseOver = false;
        return this;
    }

    public class Pointer {
        public Pointer setX(int n) {
            ControlWindow.this.mouseX = n;
            return this;
        }

        public Pointer setY(int n) {
            ControlWindow.this.mouseY = n;
            return this;
        }

        public int getY() {
            return ControlWindow.this.mouseY;
        }

        public int getX() {
            return ControlWindow.this.mouseX;
        }

        public int getPreviousX() {
            return ControlWindow.this.pmouseX;
        }

        public int getPreviousY() {
            return ControlWindow.this.pmouseY;
        }

        public Pointer set(int n, int n2) {
            this.setX(n);
            this.setY(n2);
            return this;
        }

        public Pointer set(int n, int n2, boolean bl) {
            this.setX(n);
            this.setY(n2);
            if (bl) {
                if (!ControlWindow.this.mousePressed) {
                    this.pressed();
                }
            } else if (ControlWindow.this.mousePressed) {
                this.released();
            }
            return this;
        }

        public Pointer pressed() {
            ControlWindow.this.mousePressedEvent();
            return this;
        }

        public Pointer released() {
            ControlWindow.this.mouseReleasedEvent();
            return this;
        }

        public void enable() {
            ControlWindow.this.isMouse = false;
        }

        public void disable() {
            ControlWindow.this.isMouse = true;
        }

        public boolean isEnabled() {
            return !ControlWindow.this.isMouse;
        }
    }
}

