/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.Sort;

public class DoubleList
implements Iterable<Double> {
    int count;
    double[] data;

    public DoubleList() {
        this.data = new double[10];
    }

    public DoubleList(int length) {
        this.data = new double[length];
    }

    public DoubleList(double[] list) {
        this.count = list.length;
        this.data = new double[this.count];
        System.arraycopy(list, 0, this.data, 0, this.count);
    }

    public DoubleList(Iterable<Object> iter) {
        this(10);
        for (Object o : iter) {
            if (o == null) {
                this.append(Double.NaN);
                continue;
            }
            if (o instanceof Number) {
                this.append(((Number)o).doubleValue());
                continue;
            }
            this.append(PApplet.parseFloat(o.toString().trim()));
        }
        this.crop();
    }

    public DoubleList(Object ... items) {
        this.count = items.length;
        this.data = new double[this.count];
        int index = 0;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            double value = Double.NaN;
            if (o != null) {
                if (o instanceof Number) {
                    value = ((Number)o).doubleValue();
                } else {
                    try {
                        value = Double.parseDouble(o.toString().trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        value = Double.NaN;
                    }
                }
            }
            this.data[index++] = value;
            ++n2;
        }
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int length) {
        if (length > this.data.length) {
            double[] temp = new double[length];
            System.arraycopy(this.data, 0, temp, 0, this.count);
            this.data = temp;
        } else if (length > this.count) {
            Arrays.fill(this.data, this.count, length, 0.0);
        }
        this.count = length;
    }

    public void clear() {
        this.count = 0;
    }

    public double get(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void set(int index, double what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
            int i = this.count;
            while (i < index) {
                this.data[i] = 0.0;
                ++i;
            }
            this.count = index + 1;
        }
        this.data[index] = what;
    }

    public void push(double value) {
        this.append(value);
    }

    public double pop() {
        if (this.count == 0) {
            throw new RuntimeException("Can't call pop() on an empty list");
        }
        double value = this.get(this.count - 1);
        --this.count;
        return value;
    }

    public double remove(int index) {
        if (index < 0 || index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        double entry = this.data[index];
        int i = index;
        while (i < this.count - 1) {
            this.data[i] = this.data[i + 1];
            ++i;
        }
        --this.count;
        return entry;
    }

    public int removeValue(int value) {
        int index = this.index(value);
        if (index != -1) {
            this.remove(index);
            return index;
        }
        return -1;
    }

    public int removeValues(int value) {
        int i;
        int ii = 0;
        if (Double.isNaN(value)) {
            i = 0;
            while (i < this.count) {
                if (!Double.isNaN(this.data[i])) {
                    this.data[ii++] = this.data[i];
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.count) {
                if (this.data[i] != (double)value) {
                    this.data[ii++] = this.data[i];
                }
                ++i;
            }
        }
        int removed = this.count - ii;
        this.count = ii;
        return removed;
    }

    public boolean replaceValue(double value, double newValue) {
        if (Double.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Double.isNaN(this.data[i])) {
                    this.data[i] = newValue;
                    return true;
                }
                ++i;
            }
        } else {
            int index = this.index(value);
            if (index != -1) {
                this.data[index] = newValue;
                return true;
            }
        }
        return false;
    }

    public boolean replaceValues(double value, double newValue) {
        boolean changed = false;
        if (Double.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Double.isNaN(this.data[i])) {
                    this.data[i] = newValue;
                    changed = true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == value) {
                    this.data[i] = newValue;
                    changed = true;
                }
                ++i;
            }
        }
        return changed;
    }

    public void append(double value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void append(double[] values) {
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void append(DoubleList list) {
        double[] dArray = list.values();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            this.append(v);
            ++n2;
        }
    }

    public void appendUnique(double value) {
        if (!this.hasValue(value)) {
            this.append(value);
        }
    }

    public void insert(int index, double value) {
        this.insert(index, new double[]{value});
    }

    public void insert(int index, double[] values) {
        if (index < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + index);
        }
        if (index >= this.data.length) {
            throw new IllegalArgumentException("insert() index " + index + " is past the end of this list");
        }
        double[] temp = new double[this.count + values.length];
        System.arraycopy(this.data, 0, temp, 0, Math.min(this.count, index));
        System.arraycopy(values, 0, temp, index, values.length);
        System.arraycopy(this.data, index, temp, index + values.length, this.count - index);
        this.count += values.length;
        this.data = temp;
    }

    public void insert(int index, DoubleList list) {
        this.insert(index, list.values());
    }

    public int index(double what) {
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == what) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasValue(double value) {
        if (Double.isNaN(value)) {
            int i = 0;
            while (i < this.count) {
                if (Double.isNaN(this.data[i])) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.count) {
                if (this.data[i] == value) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void boundsProblem(int index, String method) {
        String msg = String.format("The list size is %d. You cannot %s() to element %d.", this.count, method, index);
        throw new ArrayIndexOutOfBoundsException(msg);
    }

    public void add(int index, double amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] + amount;
        } else {
            this.boundsProblem(index, "add");
        }
    }

    public void sub(int index, double amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] - amount;
        } else {
            this.boundsProblem(index, "sub");
        }
    }

    public void mult(int index, double amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] * amount;
        } else {
            this.boundsProblem(index, "mult");
        }
    }

    public void div(int index, double amount) {
        if (index < this.count) {
            int n = index;
            this.data[n] = this.data[n] / amount;
        } else {
            this.boundsProblem(index, "div");
        }
    }

    private void checkMinMax(String functionName) {
        if (this.count == 0) {
            String msg = String.format("Cannot use %s() on an empty %s.", functionName, this.getClass().getSimpleName());
            throw new RuntimeException(msg);
        }
    }

    public double min() {
        this.checkMinMax("min");
        int index = this.minIndex();
        return index == -1 ? Double.NaN : this.data[index];
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        double m = Double.NaN;
        int mi = -1;
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == this.data[i]) {
                m = this.data[i];
                mi = i;
                int j = i + 1;
                while (j < this.count) {
                    double d = this.data[j];
                    if (!Double.isNaN(d) && d < m) {
                        m = this.data[j];
                        mi = j;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return mi;
    }

    public double max() {
        this.checkMinMax("max");
        int index = this.maxIndex();
        return index == -1 ? Double.NaN : this.data[index];
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        double m = Double.NaN;
        int mi = -1;
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == this.data[i]) {
                m = this.data[i];
                mi = i;
                int j = i + 1;
                while (j < this.count) {
                    double d = this.data[j];
                    if (!Double.isNaN(d) && d > m) {
                        m = this.data[j];
                        mi = j;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return mi;
    }

    public double sum() {
        double sum = 0.0;
        int i = 0;
        while (i < this.count) {
            sum += this.data[i];
            ++i;
        }
        return sum;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                if (DoubleList.this.count == 0) {
                    return 0;
                }
                int right = DoubleList.this.count - 1;
                while (DoubleList.this.data[right] != DoubleList.this.data[right]) {
                    if (--right != -1) continue;
                    return 0;
                }
                int i = right;
                while (i >= 0) {
                    double v = DoubleList.this.data[i];
                    if (v != v) {
                        DoubleList.this.data[i] = DoubleList.this.data[right];
                        DoubleList.this.data[right] = v;
                        --right;
                    }
                    --i;
                }
                return right + 1;
            }

            @Override
            public int compare(int a, int b) {
                double diff = DoubleList.this.data[b] - DoubleList.this.data[a];
                return diff == 0.0 ? 0 : (diff < 0.0 ? -1 : 1);
            }

            @Override
            public void swap(int a, int b) {
                double temp = DoubleList.this.data[a];
                DoubleList.this.data[a] = DoubleList.this.data[b];
                DoubleList.this.data[b] = temp;
            }
        }.run();
    }

    public void reverse() {
        int ii = this.count - 1;
        int i = 0;
        while (i < this.count / 2) {
            double t = this.data[i];
            this.data[i] = this.data[ii];
            this.data[ii] = t;
            --ii;
            ++i;
        }
    }

    public void shuffle() {
        Random r = new Random();
        int num = this.count;
        while (num > 1) {
            int value = r.nextInt(num);
            double temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public void shuffle(PApplet sketch) {
        int num = this.count;
        while (num > 1) {
            int value = (int)sketch.random(num);
            double temp = this.data[--num];
            this.data[num] = this.data[value];
            this.data[value] = temp;
        }
    }

    public DoubleList copy() {
        DoubleList outgoing = new DoubleList(this.data);
        outgoing.count = this.count;
        return outgoing;
    }

    public double[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Double> iterator() {
        return new Iterator<Double>(){
            int index = -1;

            @Override
            public void remove() {
                DoubleList.this.remove(this.index);
                --this.index;
            }

            @Override
            public Double next() {
                return DoubleList.this.data[++this.index];
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < DoubleList.this.count;
            }
        };
    }

    public double[] array() {
        return this.array(null);
    }

    public double[] array(double[] array) {
        if (array == null || array.length != this.count) {
            array = new double[this.count];
        }
        System.arraycopy(this.data, 0, array, 0, this.count);
        return array;
    }

    public DoubleList getPercent() {
        double sum = 0.0;
        double[] dArray = this.array();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            sum += value;
            ++n2;
        }
        DoubleList outgoing = new DoubleList(this.count);
        int i = 0;
        while (i < this.count) {
            double percent = this.data[i] / sum;
            outgoing.set(i, percent);
            ++i;
        }
        return outgoing;
    }

    public DoubleList getSubset(int start) {
        return this.getSubset(start, this.count - start);
    }

    public DoubleList getSubset(int start, int num) {
        double[] subset = new double[num];
        System.arraycopy(this.data, start, subset, 0, num);
        return new DoubleList(subset);
    }

    public String join(String separator) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.data[0]);
        int i = 1;
        while (i < this.count) {
            sb.append(separator);
            sb.append(this.data[i]);
            ++i;
        }
        return sb.toString();
    }

    public void print() {
        int i = 0;
        while (i < this.count) {
            System.out.format("[%d] %f%n", i, this.data[i]);
            ++i;
        }
    }

    public void save(File file) {
        PrintWriter writer = PApplet.createWriter(file);
        this.write(writer);
        writer.close();
    }

    public void write(PrintWriter writer) {
        int i = 0;
        while (i < this.count) {
            writer.println(this.data[i]);
            ++i;
        }
        writer.flush();
    }

    public String toJSON() {
        return "[ " + this.join(", ") + " ]";
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " size=" + this.size() + " " + this.toJSON();
    }
}

