import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import processing.serial.*; 
import controlP5.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class Kalibrierungssoftware extends PApplet {

 
Serial myPort;
PImage SUSmobil;
PImage LMT;
PImage DBU;
PImage UdS;
PImage SFZSLS;
PImage iPhysicsLab;




ControlP5 cp5;
DropdownList d1;


ControlP5 anzahlKonzentrationen_, anzahlZyklen_, ppmProMl, Konzentration1, Konzentration2, Konzentration3, baudRate;
String textValue = "";
String portName;
int serialListIndex;

boolean startProgramm = false;


public void setup() {
  
  SUSmobil = loadImage("img/SUSmobil.png");
  LMT = loadImage("img/LMT.png");
  UdS = loadImage("img/UdS.png");
  DBU = loadImage("img/DBU.png");
    iPhysicsLab = loadImage("img/iPhysicsLab.png");
  SFZSLS = loadImage("img/SFZSLS.png");
  
  
  surface.setIcon(SUSmobil);
  cp5 = new ControlP5(this);
  //surface.setResizable(true);
  PFont pfont = createFont("Arial", 10, true); //Create a font
  ControlFont font = new ControlFont(pfont, 20); //font, font-size

  d1 = cp5.addDropdownList("myList-d1")
    .setPosition(400, 170)
    .setSize(100, 50)
    .setHeight(210)
    .setItemHeight(40)
    .setBarHeight(50)
    .setFont(font)
    .setColorBackground(color(60))
    .setColorActive(color(255, 128))
    ;

  d1.getCaptionLabel().set("PORT"); //set PORT before anything is selected
  d1.hide();

  // Einstellungen:
  anzahlKonzentrationen_ = new ControlP5(this);

  anzahlKonzentrationen_.addTextfield("")
    .setPosition(400, 80)
    .setSize(100, 30)
    .setFont(font)
    .setFocus(false)
    .setColor(color(255))
    ;
  anzahlKonzentrationen_.hide();
  baudRate = new ControlP5(this);

  baudRate.addTextfield("")
    .setPosition(650, 180)
    .setSize(100, 30)
    .setFont(font)
    .setFocus(false)
    .setColor(color(255))
    ;
  baudRate.hide();

  anzahlZyklen_ = new ControlP5(this);

  anzahlZyklen_.addTextfield("")
    .setPosition(400, 125)
    .setSize(100, 30)
    .setFont(font)
    .setFocus(false)
    .setColor(color(255))
    ;
  anzahlZyklen_.hide();


  ppmProMl = new ControlP5(this);

  ppmProMl.addTextfield("")
    .setPosition(400, 150)
    .setSize(100, 30)
    .setFont(font)
    .setFocus(false)
    .setColor(color(255))
    ;
  ppmProMl.hide();

  Konzentration1 = new ControlP5(this);

  Konzentration1.addTextfield("")
    .setPosition(410, 395)
    .setSize(40, 30)
    .setFont(font)
    .setFocus(false)
    .setColor(color(255))
    ;
  Konzentration1.hide();

  Konzentration2 = new ControlP5(this);

  Konzentration2.addTextfield("")
    .setPosition(410, 445)
    .setSize(40, 30)
    .setFont(font)
    .setFocus(false)
    .setColor(color(255))
    ;
  Konzentration2.hide();

  Konzentration3 = new ControlP5(this);

  Konzentration3.addTextfield("")
    .setPosition(410, 495)
    .setSize(40, 30)
    .setFont(font)
    .setFocus(false)
    .setColor(color(255))
    ;
  Konzentration3.hide();

  ////
  if (Serial.list().length > 0) {
    portName = Serial.list()[0]; //0 as default
    myPort = new Serial(this, portName, 9600);
    startProgramm = true;
  }
  //Alle Messdaten zu Beginn auf 0 setzem
  for (int i = 0; i < anzahlKonzentrationen*anzahlZyklen; i++) {
    for (int j = 0; j < 50; j++) {
      Messdaten[i][j] = 0;
    }
  }
}


boolean auswahl = false;
boolean menu = true;
boolean messung = false;
boolean COM = false;
boolean settings = false;
int translation = 0;
boolean Aufforderung = false;
boolean erklaerung = true;
boolean messungEinstellung = true;

float ppmProMlWert = 10;
int baudrate = 9600;

int Konzentration1Wert = 10;
int Konzentration2Wert = 20;
int Konzentration3Wert = 30;


public void draw() {
  if (startProgramm) {
    anzahlZyklen_.hide();
    anzahlKonzentrationen_.hide();
    baudRate.hide();

    //Outputs werden erstellt
    for (int i = 0; i < anzahlKonzentrationen; i++) {
      for (int j = 0; j < anzahlZyklen; j++) {
        if (i == 0) {
          Outputs[j + anzahlZyklen*i] = 0;
        }
        if (i == 1) {

          if (Float.isNaN(parseFloat(Konzentration1.get(Textfield.class, "").getText().replace(',', '.')))) {
            Outputs[j + anzahlZyklen*i] = 10;
          } else {
            Outputs[j + anzahlZyklen*i] = parseFloat(Konzentration1.get(Textfield.class, "").getText().replace(',', '.'));
          }
        }

        if (i == 2) {
          if (Float.isNaN(parseFloat(Konzentration2.get(Textfield.class, "").getText().replace(',', '.')))) {
            Outputs[j + anzahlZyklen*i] = 20;
          } else {
            Outputs[j + anzahlZyklen*i] = parseFloat(Konzentration2.get(Textfield.class, "").getText().replace(',', '.'));
          }
        }

        if (i == 3) {
          if (Float.isNaN(parseFloat(Konzentration3.get(Textfield.class, "").getText().replace(',', '.')))) {
            Outputs[j + anzahlZyklen*i] = 30;
          } else {
            Outputs[j + anzahlZyklen*i] = parseFloat(Konzentration3.get(Textfield.class, "").getText().replace(',', '.'));
          }
        }

        if (i == 4) {
          Outputs[j + anzahlZyklen*i] =40;
        }
      }
    }





    if (parseInt(anzahlKonzentrationen_.get(Textfield.class, "").getText()) <= 0) {
      anzahlKonzentrationen = 5;
    } else {
      anzahlKonzentrationen = parseInt(anzahlKonzentrationen_.get(Textfield.class, "").getText());
    }

    if (parseInt(anzahlZyklen_.get(Textfield.class, "").getText()) <= 0) {
      anzahlZyklen = 10;
    } else {
      anzahlZyklen = parseInt(anzahlZyklen_.get(Textfield.class, "").getText());
    }

    if (parseInt(baudRate.get(Textfield.class, "").getText()) <= 0) {
      baudrate = 9600;
    } else {
      baudrate = parseInt(baudRate.get(Textfield.class, "").getText());
    }

    if (parseFloat(ppmProMl.get(Textfield.class, "").getText().replace(',', '.')) <= 0) {
      ppmProMlWert = 0;
    } else {
      ppmProMlWert = parseFloat(ppmProMl.get(Textfield.class, "").getText().replace(',', '.'));
    }





    if (parseInt(Konzentration1.get(Textfield.class, "").getText().replace(',', '.')) <= 0) {
      Konzentration1Wert = 10;
    } else {
      Konzentration1Wert = parseInt(Konzentration1.get(Textfield.class, "").getText().replace(',', '.'));
    }

    if (parseInt(Konzentration2.get(Textfield.class, "").getText().replace(',', '.')) <= 0) {
      Konzentration2Wert = 20;
    } else {
      Konzentration2Wert = parseInt(Konzentration2.get(Textfield.class, "").getText().replace(',', '.'));
    }

    if (parseInt(Konzentration3.get(Textfield.class, "").getText().replace(',', '.')) <= 0) {
      Konzentration3Wert = 30;
    } else {
      Konzentration3Wert = parseInt(Konzentration3.get(Textfield.class, "").getText().replace(',', '.'));
    }

    if (translation < -190) {
      translation = -190;
    }
    if (translation > 1) {
      translation = 0;
    }
    background(255);

    translate(0, translation);
    if (menu) {
      image(SUSmobil, 0, 0);
      image(LMT,200,830);
      //image(UdS, 400, 850);
      image(SFZSLS, 350, 830);
      image(iPhysicsLab, 660, 830);
      
      d1.hide();
      homeScreen();
    } else if (messung) {
      for (int i = 0; i < 1500; i++) {
        stroke(255 - 255 * i / 1500);
        line(0, i, width, i);
      }

      if (messungEinstellung) {
        KonzProMl();
      } else {

        Koordinatenkreuz();
        Messung();
        NormalizeData();
        DatenZeichnen();
        Buttons();
        if (aktuellerZyklus == anzahlZyklen) {
          Zufrieden();
        } else {
          if (aktuelleKonzentration != anzahlKonzentrationen) {
            Temperaturzyklus();
          } else {
            ErklaerungMerkmale();
          }
        }
        if (auswertung) {
          messungGestartet = false;
          if (MaxAktiv) {
            Maximum();
          }
          if (MinAktiv) {
            Minimum();
          }
          if (SteigAktiv) {
            Steigung();
          }
          if (MWAktiv) {
            Mittelwert();
          }
        }
        Speichern();
      }
    } else if (tutor) {
      tutorial();
    } else if (settings) {
      Einstellungen();
    }

    if (Konzentration1Wert >= Konzentration2Wert || Konzentration1Wert >= Konzentration3Wert || Konzentration2Wert >= Konzentration3Wert || ppmProMlWert <= 0 || Konzentration1Wert >= 40 || Konzentration2Wert >= 40 || Konzentration3Wert >= 40) {
      Fehlermeldung();
      erlaubnis = false;
    } else {
      erlaubnis = true;
    }
  } else {
    background(255);
    fill(0);
    textAlign(CENTER);
    textSize(40);
    text("Kein Mikrocontroller erkannt. Überprüfe den\nAnschluss. Sobald ein Gerät erkannt wurde,\nstartet das Programm automatisch neu.", 525, 300);
    if (Serial.list().length > 0) {
      portName = Serial.list()[0]; //0 as default
      myPort = new Serial(this, portName, 9600);
      startProgramm = true;
      textAlign(CORNER);
    }
  }
  if (Serial.list().length == 0) {
    startProgramm = false;
  }
}


public void controlEvent(ControlEvent theEvent) { //when something in the list is selected
  myPort.clear(); //delete the port
  myPort.stop(); //stop the port
  if (theEvent.isController() && d1.isMouseOver()) {
    portName = Serial.list()[PApplet.parseInt(theEvent.getController().getValue())]; //port name is set to the selected port in the dropDownMeny
    myPort = new Serial(this, portName, baudrate); //Create a new connection
    println("Serial index set to: " + theEvent.getController().getValue());
    delay(2000);
  }
}

boolean erlaubnis = false;


public void Fehlermeldung() {
  pushMatrix();
  fill(255);
  rect(270, 600, 440, 70);
  stroke(255, 0, 0);
  fill(255, 0, 0);
  textSize(30);
  text("Überprüfe deine Angaben!", 300, 650);


  popMatrix();

  fill(0);
}
boolean MaxAktiv = false;
boolean MinAktiv = false;
boolean SteigAktiv = false;
boolean MWAktiv = false;



boolean unbekannteKonzentration = false;


int GrenzeMaximumLinks = 6;
int GrenzeMinimumLinks = 10;
int GrenzeSteigungLinks = 14;
int GrenzeMittelwertLinks = 18;



public void Maximum() {
  // Graphische Darstellung
  fill(0, 0, 255, 100);
  rect(250+GrenzeMaximumLinks*10, 50, 6*10, 350);
}

public void Minimum() {
  // Graphische Darstellung
  fill(255, 0, 0, 100);
  rect(250+GrenzeMinimumLinks*10, 50, 6*10, 350);
}

public void Steigung() {
  // Graphische Darstellung
  fill(255, 255, 0, 100);
  rect(250+GrenzeSteigungLinks*10, 50, 6*10, 350);
}

public void Mittelwert() {
  // Graphische Darstellung
  fill(0, 255, 0, 100);
  rect(250+GrenzeMittelwertLinks*10, 50, 6*10, 350);
}

public void mouseDragged() {
  //Wenn der Maximumsbereich zu sehen ist und man die Maus auf ihm hat, kann man ihn durch Maus gedrückt halten verschieben
  if (MaxAktiv && mouseX > 250+GrenzeMaximumLinks*10 && mouseX < 310+GrenzeMaximumLinks*10 && (mouseY-translation) > 50 && (mouseY-translation) < 400 && mouseX > 260 && mouseX < 720 && unbekannteKonzentration == false) {
    GrenzeMaximumLinks = floor((mouseX - 270)/10);
    //GrenzeMaximumLinks += (mouseX - pmouseX)/4;
  }
  if (MinAktiv && mouseX > 250+GrenzeMinimumLinks*10 && mouseX < 310+GrenzeMinimumLinks*10 && (mouseY-translation) > 50 && (mouseY-translation) < 400 && mouseX > 260 && mouseX < 720 && unbekannteKonzentration == false) {
    GrenzeMinimumLinks = floor((mouseX - 270)/10);
  }
  if (SteigAktiv && mouseX > 250+GrenzeSteigungLinks*10 && mouseX < 310+GrenzeSteigungLinks*10 && (mouseY-translation) > 50 && (mouseY-translation) < 400 && mouseX > 280 && mouseX < 700 && unbekannteKonzentration == false) {
    GrenzeSteigungLinks = floor((mouseX - 270)/10);
  }
  if (MWAktiv && mouseX > 250+GrenzeMittelwertLinks*10 && mouseX < 310+GrenzeMittelwertLinks*10 && (mouseY-translation) > 50 && (mouseY-translation) < 400 && mouseX > 260 && mouseX < 720 && unbekannteKonzentration == false) {
    GrenzeMittelwertLinks = floor((mouseX - 270)/10);
  }
}
public void mouseWheel(MouseEvent event) {
  int e = event.getCount();
  //println(e);

  if (translation < 1 && translation > -200) {
    translation -= 5*e;
  }
}


public void mouseReleased() {
  //Maximum ausgewählt
  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 145 && (mouseY-translation) < 195 && messung && unbekannteKonzentration == false && erklaerung == false) {
    if (MaxAktiv) {
      MaxAktiv = false;
    } else {
      MaxAktiv = true;
    }
  }
  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 220 && (mouseY-translation) < 270 && messung && unbekannteKonzentration == false && erklaerung == false) {

    if (MinAktiv) {
      MinAktiv = false;
    } else {
      MinAktiv = true;
    }
  }


  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 295 && (mouseY-translation) < 345 && messung && unbekannteKonzentration == false && erklaerung == false) {

    if (SteigAktiv) {
      SteigAktiv = false;
    } else {
      SteigAktiv = true;
    }
  }

  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 370 && (mouseY-translation) < 420 && messung && unbekannteKonzentration == false && erklaerung == false) {

    if (MWAktiv) {
      MWAktiv = false;
    } else {
      MWAktiv = true;
    }
  }

  if (aktuelleKonzentration == anzahlKonzentrationen && anzahlMerkmale == 2) {
    if (mouseX > 475 && mouseX < 575 && (mouseY-translation) > 900 && (mouseY-translation) < 950) {
      launch("test.html");
      unbekannteKonzentration = true;
      println("HI");
    }
  }


  //Vom Hauptmenu zur Messung
  if (mouseX > 400 && mouseX < 700 && (mouseY-translation) > 625 && (mouseY-translation) < 700 && menu && tutor == false) {
    menu = false;    
    messung = true;
    tutor = false;
    Konzentration1.show();
    Konzentration2.show();
    Konzentration3.show();
    ppmProMl.show();
  }

  if (mouseX > 400 && mouseX < 630 && mouseY > 700 && mouseY < 750 && messung && messungEinstellung && erlaubnis) {
    messungEinstellung = false;     
    Konzentration1.hide();
    Konzentration2.hide();
    Konzentration3.hide();
    ppmProMl.hide();
  }


  //Von Messung zurück zum Hauptmenu
  if (mouseX > 815 && mouseX < 915 && (mouseY-translation) > 900 && (mouseY-translation) < 950 && menu == false && messung) {
    menu = true;
    messung = false;
    tutor = false;
    settings = false;
    messungEinstellung = true;
  }


  //Starte Tutorial
  if (mouseX > 400 && mouseX < 700 && (mouseY-translation) > 525 && (mouseY-translation) < 600 && menu && messung == false) {
    tutor = true;
    messung = false;
    menu = false;
    settings = false;
  }


  if (messung && aktuellerZyklus == anzahlZyklen && mouseX > 350 && mouseX <450 && (mouseY-translation) > 550 && (mouseY-translation)< 590) {
    if (aktuelleKonzentration != anzahlKonzentrationen-1) {
      Aufforderung = true;
    } else {
      myPort.clear();
      wait = true;
      aktuellerZyklus = 0;
      Aufforderung = false;

      if (aktuelleKonzentration < anzahlKonzentrationen) {
        aktuelleKonzentration += 1;
      }
      if (aktuelleKonzentration == anzahlKonzentrationen) {
        auswertung = true;
      }
    }
  }

  if (messung && Aufforderung && aktuellerZyklus == anzahlZyklen && mouseX > 350 && mouseX > 450 && mouseX < 550 && (mouseY-translation) > 600 && (mouseY-translation) < 640) {
    myPort.clear();
    wait = true;
    aktuellerZyklus = 0;
    Aufforderung = false;

    if (aktuelleKonzentration < anzahlKonzentrationen) {
      aktuelleKonzentration += 1;
    }
    if (aktuelleKonzentration == anzahlKonzentrationen) {
      auswertung = true;
    }
  }


  if (messung && mouseX > 475 && mouseX < 625 && mouseY > 500 && mouseY < 550 && aktuelleKonzentration == anzahlKonzentrationen) {
    erklaerung = false;
  }

  //Einstellungen - Resette alle Messwerte

  if (mouseX > 400 && mouseX < 500 && mouseY < 350 && mouseY > 300 && settings) {
    aktuelleKonzentration = 0;
    aktuellerZyklus = 0;
    // Alles auf null
    for (int i = 0; i < aktuelleKonzentration*(anzahlZyklen) + anzahlZyklen; i++) {
      for (int j = 0; j < 50; j++) {
        Messdaten[i][j] = 0;
      }
    }
  }

  ////


  if (tutor) {
    if (mouseX > 900 &&  mouseX < 1000 && (mouseY-translation) > 800 && (mouseY-translation) < 850 && seiteTutorial < 13 && seiteTutorial !=12) {
      if (seiteTutorial == 9) {
        MaxAktiv = true;
        SteigAktiv = true;
        MinAktiv = false;
        MWAktiv = false;
      }

      seiteTutorial += 1;
    }
   if (mouseX > 900 &&  mouseX < 1000 && (mouseY-translation) > 850 && (mouseY-translation) < 900 && seiteTutorial ==12) {
      seiteTutorial += 1;
    }
    if (mouseX > 50 &&  mouseX < 150 && (mouseY-translation) > 800 && (mouseY-translation) < 850 && seiteTutorial > 0 && seiteTutorial != 12) {
      seiteTutorial -= 1;
    }
    if (mouseX > 50 &&  mouseX < 150 && (mouseY-translation) > 850 && (mouseY-translation) < 900 && seiteTutorial > 0 && seiteTutorial == 12) {
      seiteTutorial -= 1;
    }
    //Man klickt auf Messung starten
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 225 && (mouseY-translation) < 275 && seiteTutorial == 1) {
      seiteTutorial += 1;
    }
    //Von Tutorial ins Hauptmenü
    if (mouseX > 450 &&  mouseX < 580 && (mouseY-translation) > 800 && (mouseY-translation) < 850 && seiteTutorial != 3) {
      tutor = false;
      menu = true;
      messung = false;
      seiteTutorial = 0;
      settings = false;
    }



    //Maximum ausgewählt
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 205 && (mouseY-translation) < 265 && seiteTutorial == 9) {
      if (MaxAktiv) {
        MaxAktiv = false;
      } else {
        MaxAktiv = true;
      }
    }
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 280 && (mouseY-translation) < 330 && seiteTutorial == 9) {

      if (MinAktiv) {
        MinAktiv = false;
      } else {
        MinAktiv = true;
      }
    }


    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 355 && (mouseY-translation) < 415 && seiteTutorial == 9) {

      if (SteigAktiv) {
        SteigAktiv = false;
      } else {
        SteigAktiv = true;
      }
    }

    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 430 && (mouseY-translation) < 480 && seiteTutorial == 9) {
      if (MWAktiv) {
        MWAktiv = false;
      } else {
        MWAktiv = true;
      }
    }
  }


  //Einstellungen öffnen
  if (mouseX > 400 && mouseX < 700 && (mouseY-translation) > 725 && (mouseY-translation) < 800 && menu) {
    settings = true;
    menu = false;
    tutor = false;
    messung = false;
  }

  //Einstellungen schließen
  if (mouseX > 400 && mouseX < 550 && mouseY > 400 && mouseY < 450 && settings) {
    menu = true;
    settings = false;
    tutor = false;
    messung = false;
  }
} 
boolean messungGestartet = false;


public void Buttons() {
  textSize(20);
  text("Merkmale", 75, 120);
  strokeWeight(4);
  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 145 && (mouseY-translation) < 195) {
    fill(0, 0, 255, 20);
  } else {
    fill(100, 100, 255, 220);
  }
  //Maximum
  if (MaxAktiv) {
    strokeWeight(4);
    stroke(255);
  } else {
    strokeWeight(1);
    stroke(0);
  }
  rect(75, 145, 100, 50);
  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 220 && (mouseY-translation) < 270) {
    fill(255, 100, 100, 20);
  } else {
    fill(255, 0, 0, 220);
  }
  //Minimum
  if (MinAktiv) {
    strokeWeight(4);
    stroke(255);
  } else {
    strokeWeight(1);
    stroke(0);
  }
  rect(75, 220, 100, 50);


  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 295 && (mouseY-translation) < 345) {
    fill(255, 255, 0, 20);
  } else {
    fill(255, 255, 0, 220);
  }
  //Steigung
  if (SteigAktiv) {
    strokeWeight(4);
    stroke(255);
  } else {
    strokeWeight(1);
    stroke(0);
  }
  rect(75, 295, 100, 50);
  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 370 && (mouseY-translation) < 420) {
    fill(0, 255, 0, 20);
  } else {
    fill(0, 255, 0, 220);
  }
  //Mittelwert
  if (MWAktiv) {
    strokeWeight(4);
    stroke(255);
  } else {
    stroke(0);
    strokeWeight(1);
  }
  rect(75, 370, 100, 50);
  // Start-Button
  strokeWeight(1);
  stroke(0);

  // Abbruch
  if (mouseX > 815 && mouseX < 915 && (mouseY-translation) > 350 && (mouseY-translation) < 400 && aktuelleKonzentration != anzahlKonzentrationen) {
    fill(255);
    if (mousePressed) {
      aktuellerZyklus = 0;
      wait = true;
      myPort.clear();
      // Wenn man nicht zufrieden ist, werden die Daten dieser Konzentration gelöscht
      for (int i = aktuelleKonzentration*(anzahlZyklen); i < aktuelleKonzentration*(anzahlZyklen) + anzahlZyklen; i++) {
        for (int j = 0; j < 50; j++) {
          Messdaten[i][j] = 0;
        }
      }
    }
  } else {
    fill(220);
  }

  if (aktuelleKonzentration != anzahlKonzentrationen) {
    rect(815, 350, 100, 50);
  }

  //


  if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 25 && (mouseY-translation) < 75) {
    fill(255);
    if (mousePressed && messungGestartet == false) {
      messungGestartet = true;
      myPort.clear();
    }
  } else {
    fill(220);
  }
  rect(75, 25, 100, 50);



  fill(0);
  textSize(16);
  text("Maximum", 87, 175);
  text("Minimum", 87, 250);
  text("Steigung", 90, 325);
  text("Mittelwert", 87, 400);
  text("Messung \n starten", 91, 45);
  if (aktuelleKonzentration != anzahlKonzentrationen) {
    text("  Messung\nwiederholen", 818, 368);
  }


  if (mouseX > 815 && mouseX < 915 && (mouseY-translation) > 900 && (mouseY-translation) < 950) {
    fill(255);
  } else {
    fill(220);
  }
  rect(815, 900, 100, 50);

  fill(0);
  text("Hauptmenu", 820, 930);
}
public void Einstellungen() {
  pushMatrix();
  for (int i = 0; i < 1500; i++) {
    stroke(255 - 255 * i / 1500);
    line(0, i, width, i);
  }

  textSize(20);
  fill(0);
  text("Wähle COM-Port:", 20, 200);
  text("Anzahl Konzentrationen:", 20, 100);
  anzahlZyklen_.show();
  text("Anzahl Zyklen pro Konzentration:", 20, 150);
  anzahlKonzentrationen_.show();
  text("Baudrate: ", 550, 200);
  text("(default: 9600)", 800, 200);
  baudRate.show();
  if (mouseX > 400 && mouseX < 550 && mouseY > 400 && mouseY < 450) {
    fill(255);
  } else {
    fill(220);
  }

  rect(400, 400, 150, 50);

  d1.show();
  fill(0);
  text("Hauptmenü", 420, 430);

  if (d1.isMouseOver()) {
    d1.clear(); //Delete all the items
    for (int i=0; i<Serial.list().length; i++) {
      d1.addItem(Serial.list()[i], i); //add the items in the list
    }
  }
  
  
  if(mouseX > 400 && mouseX < 500 && mouseY < 350 && mouseY > 300){
    fill(255);
  }else{
    fill(220);
  }  
  rect(400, 300, 100, 50);
  fill(0);
  textSize(25);
  text("RESET", 415,333);
  textSize(12);
  text("Bei Fragen zum Programm, lesen Sie bitte zunächst das 'readme.pdf'. Bei sonstigen Fragen oder Problemen, wenden Sie sich bitte an:", 20, 620);
  text("Sebastian Höfner\nLehrstuhl für Messtechnik\nFachrichtung Systems Engineering\nUniversität des Saarlandes\nTel.: +49 681 302-2235\nmail: s.hoefner@lmt.uni-saarland.de\n", 20, 650);
  popMatrix();
}



public void homeScreen() {
  pushMatrix();
  // 1. 2 Optionen: Tutorial und direkt losmessen
  textSize(30);
  fill(0);
  text("Modul 2a) - Kalibrierung eines Sensors", 250, 480);

  if (mouseX > 400 && mouseX < 700 && (mouseY-translation) > 525 && (mouseY-translation) < 600) {
    fill(255);
  } else {
    fill(220);
  }
  rect(400, 525, 300, 75);

  if (mouseX > 400 && mouseX < 700 && (mouseY-translation) > 625 && (mouseY-translation) < 700) {
    fill(255);
  } else {
    fill(220);
  }

  rect(400, 625, 300, 75);
  if (mouseX > 400 && mouseX < 700 && (mouseY-translation) > 725 && (mouseY-translation) < 800) {
    fill(255);
  } else {
    fill(220);
  }
  rect(400, 725, 300, 75);



  fill(0);
  text("Tutorial", 500, 570);
  text("Messung", 495, 670);
  text("Einstellungen", 455, 770);
  popMatrix();
}
public void Koordinatenkreuz() {
  fill(255);
  rect(250, 50, 500, 350);
  fill(0);
  stroke(0); 
  for (int i = 0; i < 20; i++) {
    stroke(200);
    line(250, 17.5f*i + 50, 750, 17.5f*i + 50);
    stroke(0);
  }
  for (int i = 0; i < 26; i++) {
    stroke(200);
    line(250 + 20*i, 50, 250 + 20*i, 400);
    stroke(0);
  }
  stroke(0); 
  line(250, 50, 250, 410);
  line(245, 55, 250, 50);
  line(250, 50, 255, 55);
  line(240, 400, 760, 400);
  line(755, 395, 760, 400);
  line(760, 400, 755, 405);

  // x Achse
  fill(0);
  text("0", 250, 420);
  text("25", 492, 420);
  text("50", 750, 420);
  text("Messpunkt (~Zeit)", 450, 440);


  // y-Achse
  text(nf(max/1000, 0, 1), 200, 50);
  pushMatrix();
  translate(width/2, height/2);
  rotate(3*PI/2);
  text("Widerstand [kΩ]", 250, -width/2 + 220);
  popMatrix();
}



float max = 0;
public void NormalizeData() {
  max = 0;
  for (int i = 0; i < anzahlKonzentrationen*anzahlZyklen; i++) {
    for (int j = 0; j < 50; j++) {
      if (Messdaten[i][j] > max) {
        max = Messdaten[i][j];
      }
    }
  }

  for (int i = 0; i < 51; i++) {
    if (UnbekannteKonzentrationMessdaten[0][i] > max) {
      max = UnbekannteKonzentrationMessdaten[0][i];
    }
  }
}

public void DatenZeichnen() {
  //Durchschnitt abgeschlossener Konzentrationen zeichnen
  for (int i = 0; i < anzahlKonzentrationen; i++) {
    for (int j = 0; j < 50; j++) {
      Durchschnitt[i][j] = 0;
    }
  }

  for (int k = 0; k < anzahlKonzentrationen; k++) {
    for (int i = 0; i < anzahlZyklen; i++) {
      for (int j = 0; j < 50; j++) {
        Durchschnitt[k][j] += Messdaten[k*anzahlZyklen + i][j];
      }
    }
  }


  for (int i = 0; i < anzahlKonzentrationen; i++) {
    for (int j = 0; j < 50; j++) {
      Durchschnitt[i][j] = Durchschnitt[i][j]/anzahlZyklen;
    }
  }

  //alte Durchschnittsaufnahmen
  textSize(14);
  if (aktuelleKonzentration == 0) {
    fill(0);
    noStroke();
    strokeWeight(1);
    text("0 ppm", 810, 150);
  } else if (aktuelleKonzentration == 1) {
    fill(0);
    noStroke();
    strokeWeight(1);
    text(Konzentration1Wert + " ppm", 810, 170);
  } else if (aktuelleKonzentration == 2) {
    noStroke();
    strokeWeight(1);
    text(Konzentration2Wert + " ppm", 810, 190);
  } else if (aktuelleKonzentration == 3) {
    noStroke();
    strokeWeight(1);
    text(Konzentration3Wert + " ppm", 810, 210);
  } else if (aktuelleKonzentration == 4 && unbekannteKonzentration == false) {
    noStroke();
    strokeWeight(1);
    text("40 ppm", 810, 230);
  } else {
    noStroke();
    strokeWeight(1);
    text("?? ppm", 810, 250);
  }



  for (int j = 0; j < aktuelleKonzentration; j++) {
    for (int i = 1; i < 50; i++) {
      if (j == 0) {
        fill(255, 0, 0);
        noStroke();
        strokeWeight(1);
        text("0 ppm", 810, 150);
        strokeWeight(2);
        stroke(255, 0, 0);
      } else if (j == 1) {
        fill(0, 0, 255);
        noStroke();
        strokeWeight(1);
        text(Konzentration1Wert + " ppm", 810, 170);
        strokeWeight(2);
        stroke(0, 0, 255);
      } else if (j == 2) {
        fill(0, 200, 0);
        noStroke();
        strokeWeight(1);
        text(Konzentration2Wert + " ppm", 810, 190);
        strokeWeight(2);
        stroke(0, 200, 0);
      } else if (j == 3) {
        fill(255, 0, 255);
        noStroke();
        strokeWeight(1);
        text(Konzentration3Wert + " ppm", 810, 210);
        strokeWeight(2);
        stroke(255, 0, 255);
      } else if (j == 4) {
        fill(255, 255, 0);
        noStroke();
        strokeWeight(1);
        text("40 ppm", 810, 230);
        strokeWeight(2);
        stroke(255, 255, 0);
      } 
      line(250 + 10*i, 400 - 350*Durchschnitt[j][i]/max, 250 + 10*(i-1), 400 - 350*Durchschnitt[j][i-1]/max);
    }
  }

  strokeWeight(1);


  //alte Aufnahmen der aktuellen Konzentration
  for (int i = aktuelleKonzentration*(anzahlZyklen); i < aktuelleKonzentration*(anzahlZyklen)+aktuellerZyklus; i++) {
    for (int j = 1; j < 50; j++) {
      stroke(100);
      line(250 + 10*j, 400 - 350*Messdaten[i][j]/max, 250 + 10*(j-1), 400 - 350*Messdaten[i][j-1]/max);
    }
  }


  //Aktuelle Aufnahme
  stroke(0);
  if (unbekannteKonzentration == false) {
    for (int i = 1; i < aktuellerMesspunkt; i++) {
      line(250 + 10*i, 400 - 350*Messdaten[aktuellerZyklus + aktuelleKonzentration*(anzahlZyklen)][i]/max, 250 + 10*(i-1), 400 - 350*Messdaten[aktuellerZyklus + aktuelleKonzentration*(anzahlZyklen)][i-1]/max);
    }
  }
  for (int i = 1; i < 50; i++) {
    line(250 + 10*i, 400 - 350*UnbekannteKonzentrationMessdaten[0][i]/max, 250 + 10*(i-1), 400 - 350*UnbekannteKonzentrationMessdaten[0][i-1]/max);
  }

  noStroke();
  //Hier befinden wir uns im Messablauf:
  textSize(14);
  fill(0);
  if (aktuellerZyklus+1 < 0) {
    text("abgeschlossene Zyklen: " + (0) + "/" + anzahlZyklen, 810, 20);
  } else {
    if (aktuellerZyklus == -1) {
      text("abgeschlossene Zyklen: " + (aktuellerZyklus+ 1) + "/" + anzahlZyklen, 810, 20);
    } else {
      text("abgeschlossene Zyklen: " + (aktuellerZyklus) + "/" + anzahlZyklen, 810, 20);
    }
  }
  text("Anzahl Zyklen: " + anzahlZyklen, 810, 60);
  text("Anzahl Konzentrationen: " + anzahlKonzentrationen, 810, 80);
  if (wait && messungGestartet) {
    textSize(30);
    text("Synchronisiere...", 410, 30);
    textSize(14);
  } else {
    text("Messpunkt: " + aktuellerMesspunkt + "/50", 810, 100);
  }
  if (aktuelleKonzentration != anzahlKonzentrationen) {
    int conc = 0;
    if (aktuelleKonzentration == 0) {
      conc = 0;
    }
    if (aktuelleKonzentration == 1) {
      conc = Konzentration1Wert;
    }
    if (aktuelleKonzentration == 2) {
      conc = Konzentration2Wert;
    }
    if (aktuelleKonzentration == 3) {
      conc = Konzentration3Wert;
    }
    if (aktuelleKonzentration == 4) {
      conc = 40;
    }



    text("Konzentration: " + conc + " ppm", 810, 40);
  } else {
    anzahlMerkmale = 0;
    if (MaxAktiv) {
      anzahlMerkmale+= 1;
    }
    if (MinAktiv) {
      anzahlMerkmale+= 1;
    }
    if (SteigAktiv) {
      anzahlMerkmale+= 1;
    }

    if (MWAktiv) {
      anzahlMerkmale+= 1;
    }


    if (unbekannteKonzentration == false) {
      fill(255);
      stroke(0);
      rect(800, 330, 240, 110);
      noStroke();
      fill(0);
      text("Anzahl ausgewählter Merkmale: " + anzahlMerkmale, 810, 40);
      if (anzahlMerkmale == 1) {
        text("Du hast momentan " + anzahlMerkmale + " Merkmal\nausgewählt.", 810, 350);
      } else {
        text("Du hast momentan " + anzahlMerkmale + " Merkmale\nausgewählt.", 810, 350);
      }
      if (anzahlMerkmale == 2) {
        text("Wenn du zufrieden bist, klicke\nauf 'weiter'.", 810, 400);
      } else {
        text("Wähle genau 2 Merkmale aus.", 810, 400);
      }
    }
  }
}




//Temperaturzyklus

public void Temperaturzyklus() {
  pushMatrix();
  fill(255);
  noStroke();
  rect(250, 500, 500, 350);

  noFill();
  for (int i = 0; i < 20; i++) {
    stroke(200);
    line(250, 17.5f*i +500, 750, 17.5f*i + 500);
    stroke(0);
  }
  for (int i = 0; i < 26; i++) {
    stroke(200);
    line(250 + 20*i, 500, 250 + 20*i, 850);
    stroke(0);
  }

  strokeWeight(3);
  stroke(0);
  line(250, 510, 300, 510);

  line(300, 661, 500, 661);
  line(500, 510, 550, 510);
  line(550, 699, 750, 699);
  // Abgrenzungen zwischen Temperatursprüngen
  stroke(0);
  strokeWeight(2);
  for (int i = 0; i <44; i++) {
    ellipse(300, 504 + 8*i, 1, 1); 
    ellipse(500, 504 + 8*i, 1, 1); 
    ellipse(550, 504 + 8*i, 1, 1);
  }

  strokeWeight(1);
  stroke(150);
  line((aktuellerMesspunkt) * 10 + 250, 480, (aktuellerMesspunkt) * 10 + 250, 850);
  noStroke();

  stroke(0);
  line(250, 500, 250, 860);
  line(245, 505, 250, 500);
  line(250, 500, 255, 505);
  line(240, 850, 760, 850);
  line(755, 845, 760, 850);
  line(760, 850, 755, 855);
  fill(0);
  text("Messpunkt (~Zeit)", 450, 890);
  text("0", 250, 870);
  text("25", 492, 870);
  text("50", 750, 870);

  text("400", 210, 548);
  text("200", 210, 699);
  text("0", 210, 850);

  text("450 °C", 253, 535);
  text("250 °C", 380, 655);
  text("450 °C", 503, 535);
  text("200 °C", 630, 692);




  pushMatrix();
  translate(width/2, height/2);
  rotate(3*PI/2);
  fill(0);
  text("Temperatur ϑ [°C]", -215, -350);
  popMatrix();

  popMatrix();
}
public void matLog(float[][] m) {
  int spalten = m[0].length;
  int reihen = m.length;
  println();
  println(reihen + "x" + spalten);
  println("______________");
  for (int i = 0; i < reihen; i++) {
    for (int j = 0; j < spalten; j++) {
      print(m[i][j] + " ");
    }
    println();
  }
}


public void arrLog(float[] m) {
  int reihen = m.length;
  println();
  for (int i = 0; i < reihen; i++) {
    println(m[i] + " ");
  }
}
int anzahlKonzentrationen = 5;
int aktuelleKonzentration = 0;
int anzahlZyklen = 10;
int aktuellerZyklus = 0;
int aktuellerMesspunkt = 0;

float[][]Durchschnitt = new float[anzahlKonzentrationen][50];
float[][]Messdaten = new float[anzahlKonzentrationen*anzahlZyklen][50];

float[][]UnbekannteKonzentrationMessdaten = new float[1][51];
int UnbekannteKonzentrationZyklus = 0;


boolean wait = true;

float[] MerkmalMaximum = new float[anzahlKonzentrationen*anzahlZyklen];
float[] MerkmalMinimum = new float[anzahlKonzentrationen*anzahlZyklen];
float[] MerkmalSteigung = new float[anzahlKonzentrationen*anzahlZyklen];
float[] MerkmalMittelwert = new float[anzahlKonzentrationen*anzahlZyklen];

float MerkmalMaximumUnbekannt = 0;
float MerkmalMinimumUnbekannt = 999999999;
float MerkmalSteigungUnbekannt = 0;
float MerkmalMittelwertUnbekannt = 0;


int outputsAbstand = 10;
int anzahlMerkmale = 0;



boolean res = true;

public void Messung() {  
  if (messungGestartet) {
    if (myPort.available() > 0) {
      String Daten = "...";
      if (aktuelleKonzentration < anzahlKonzentrationen) {
        if (aktuellerZyklus != anzahlZyklen) {
          Daten = myPort.readStringUntil('\n');
        }

        int Widerstand = 0;
        if (Daten != null) {
          // Wenn die Daten existieren, wird der String in ein Int umgewandelt
          float SensorDaten = PApplet.parseFloat(Daten);
          Widerstand = PApplet.parseInt(SensorDaten);
          if (Widerstand == 1) {
            wait = false;
          }
        }


        if (Widerstand == 1 || Widerstand == 25 || Widerstand == 50 && wait == false) {
          aktuellerMesspunkt = Widerstand;
        } else if (aktuelleKonzentration < anzahlKonzentrationen && Daten != null && Widerstand != 0 && wait == false) {
          Messdaten[aktuellerZyklus + aktuelleKonzentration*(anzahlZyklen)][aktuellerMesspunkt] =  Widerstand;
          aktuellerMesspunkt += 1;
        }
        if (aktuellerMesspunkt == 49) {
          aktuellerMesspunkt = 0;
          if (aktuellerZyklus < anzahlZyklen) {
            aktuellerZyklus += 1;
            //matLog(Messdaten);
            wait = true;
          }
        }
        //Kalibrierung abgeschlossen
      }
    }
  }


  //UnbekannteKonuentration
  if (unbekannteKonzentration) {
    if (res) {
      myPort.clear();
      res = false;
    }


    if (myPort.available() > 0) {
      String Daten = "...";

      if (aktuellerZyklus != anzahlZyklen) {
        Daten = myPort.readStringUntil('\n');
      }

      int Widerstand = 0;
      if (Daten != null) {
        // Wenn die Daten existieren, wird der String in ein Int umgewandelt
        float SensorDaten = PApplet.parseFloat(Daten);
        Widerstand = PApplet.parseInt(SensorDaten);
        if (Widerstand == 1) {
          wait = false;
        }
      }


      if (Widerstand == 1 || Widerstand == 25 || Widerstand == 50) {
        aktuellerMesspunkt = Widerstand;
      } else if (Daten != null && Widerstand != 0) {
        UnbekannteKonzentrationMessdaten[0][aktuellerMesspunkt] =  Widerstand;
        aktuellerMesspunkt += 1;
      }
      if (aktuellerMesspunkt == 49) {
        aktuellerMesspunkt = 0;
      }
      if (aktuellerMesspunkt == GrenzeMaximumLinks) {
        MerkmalMaximumUnbekannt = 0;
      }
      if (aktuellerMesspunkt == GrenzeMinimumLinks) {
        MerkmalMinimumUnbekannt = 999999999;
      }
    }
  }
}
boolean tutor = false;

int seiteTutorial = 0;



public void tutorial() {
  pushMatrix();
  for (int i = 0; i < 1500; i++) {
    stroke(255 - 255 * i / 2500);
    line(0, i, width, i);
  }

  if (seiteTutorial == 0) {
    seite0();
  } else if (seiteTutorial == 1) {
    seite1();
  } else if (seiteTutorial == 2) {
    seite2();
  } else if (seiteTutorial == 3) {
    seite3();
  } else if (seiteTutorial == 4) {
    seite4();
  } else if (seiteTutorial == 5) {
    seite5();
  } else if (seiteTutorial == 6) {
    seite6();
  } else if (seiteTutorial == 7) {
    seite7();
  } else if (seiteTutorial == 8) {
    seite8();
  } else if (seiteTutorial == 9) {
    seite9();
  } else if (seiteTutorial == 10) {
    seite10();
  } else if (seiteTutorial == 11) {
    seite11();
  } else if (seiteTutorial == 12) {
    seite12();
  } else if (seiteTutorial == 13) {
    seite13();
  }

  //zurück
  if (seiteTutorial > 0) {
    if (mouseX > 50 &&  mouseX < 150 && (mouseY-translation) > 800 &&(mouseY-translation) < 850) {
      fill(255);
    } else {
      fill(220);
    }
    if (seiteTutorial == 12) {
      if (mouseX > 50 &&  mouseX < 150 && (mouseY-translation) > 850 &&(mouseY-translation) < 900) {
        fill(255);
      } else {
        fill(220);
      }
    }
    rect(50, 800, 100, 50);
    fill(0);
    text("zurück", 65, 830);
  }
  if (seiteTutorial < 13) {
    if (mouseX > 900 &&  mouseX < 1000 && (mouseY-translation) > 800 && (mouseY-translation) < 850) {
      fill(255);
    } else {
      fill(220);
    }    
    if (seiteTutorial == 12) {
      if (mouseX > 900 &&  mouseX < 1000 && (mouseY-translation) > 850 &&(mouseY-translation) < 900) {
        fill(255);
      } else {
        fill(220);
      }
    }
    rect(900, 800, 100, 50);
    fill(0);
    text("weiter", 920, 830);
  }



  if (seiteTutorial != 3) {
    if (mouseX > 450 &&  mouseX < 580 && (mouseY-translation) > 800 && (mouseY-translation) < 850) {
      fill(255);
    } else {
      fill(220);
    }
    if (seiteTutorial == 12) {
      if (mouseX > 450 &&  mouseX < 580 && (mouseY-translation) > 850 &&(mouseY-translation) < 900) {
        fill(255);
      } else {
        fill(220);
      }
    }
      rect(450, 800, 130, 50);
      fill(0);
      text("Hauptmenü", 460, 830);
    }
    popMatrix();
  }



  public void seite0() {
    fill(0);
    textSize(20);
    text("Willkommen zum Tutorial des Kalibrierprogramms!", 20, 50);
    textSize(16);
    fill(255);
    rect(10, 130, 1000, 75);

    fill(0);


    text("Hier wird dir der Ablauf des Versuchs erklärt. Sobald du das Tutorial abgeschlossen hast, kannst du loslegen.", 20, 150);
    text("Klicke auf 'weiter', um den nächsten Schritt anzuzeigen. Du kannst jederzeit wieder Schritte zurückgehen, oder das Tutorial\nbeenden.", 20, 174);
    textSize(20);
  }
  public void seite1() {
    textSize(16);
    fill(255);
    rect(10, 25, 1000, 90);
    fill(0);
    text("Im Programm gibt es einen Graphen, auf dem die gemessenen Widerstände gegen die Zeit aufgetragen sind. Ein Durchlauf ent-\nspricht einem Temperaturzyklus. Sobald auf auf 'Messung starten' klickst, wird der Sensor zunächst mit dem Programm syn-\nchronisiert. Anschließend werden die Messwerte live eingetragen. ", 20, 50);
    translate(0, 200);

    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 225 && (mouseY-translation) < 275) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);  

    Koordinatenkreuz();
    translate(0, -200);
    textSize(20);

    noFill();
    stroke(255, 0, 0);
    strokeWeight(4);
    ellipse(125, 250, 150, 100);

    strokeWeight(1);
    stroke(0);
  }



  float fakeZyklus[] = {1, 1, 1, 1, 1, 4, 3.9f, 3.8f, 3.7f, 3.6f, 3.55f, 3.5f, 3.47f, 3.43f, 3.4f, 3.36f, 3.32f, 3.3f, 3.28f, 3.27f, 3.26f, 3.25f, 3.24f, 3.23f, 3.22f, 1, 1, 1, 1, 1, 5, 4.9f, 4.8f, 4.7f, 4.6f, 4.55f, 4.5f, 4.47f, 4.43f, 4.4f, 4.36f, 4.32f, 4.3f, 4.28f, 4.27f, 4.26f, 4.25f, 4.24f, 4.23f, 4.22f};
  float timerTutorial = 0;

  public void seite2() {
    textSize(16);
    text("Ein solcher Messablauf kann beispielsweise so aussehen:", 20, 50);

    if (timerTutorial < 10) {
      textSize(30);
      text("Synchronisiere...", 400, 200);
    }
    translate(0, 200);

    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 225 && (mouseY-translation) < 275) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -200);

    for (int i = 1; i < (timerTutorial - 10); i++) {
      if (i > 0 && i < 50) {
        line(250 + 10*i, 600-70*fakeZyklus[i], 250 + 10*(i-1), 600-70*fakeZyklus[i-1]);
      }
    }
    for (int i = 220; i < 270; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 249);
    textSize(20);
    stroke(0);

    timerTutorial +=0.1f;

    if (timerTutorial > 100) {
      timerTutorial = 0;
    }
  }




  public void seite3() {
    textSize(16);
    text("Unterhalb des Zeit-Widerstands-Graphen, siehst du den Temperaturzyklus.", 20, 50);

    if (timerTutorial < 10) {
      textSize(30);
      text("Synchronisiere...", 400, 200);
    }
    translate(0, 50);

    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 75 && (mouseY-translation) < 125) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -200);

    for (int i = 1; i < (timerTutorial - 10); i++) {
      if (i > 0 && i < 50) {
        line(250 + 10*i, 600-70*fakeZyklus[i], 250 + 10*(i-1), 600-70*fakeZyklus[i-1]);
      }
    }
    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, (i+150), 245, (i+150));
    }
    textSize(16);
    fill(0);
    text(200, 198, 249);
    textSize(20);
    stroke(0);

    timerTutorial +=0.1f;

    if (timerTutorial > 100) {
      timerTutorial = 0;
    }

    translate(0, 175);
    textSize(16);
    Temperaturzyklus();
    textSize(20);
    translate(0, -25);
  }


  public void seite4() {
    textSize(20);
    text("Auf der rechten Seite werden dir die folgenden Informationen angezeigt:", 20, 50);
    textSize(16);
    fill(255);
    rect(95, 75, 870, 80);

    fill(0);
    text("1) abgeschlossene Zyklen: Für jede Konzentration sollst du 10 Messkurven aufnehmen", 100, 100);
    text("2) Konzentration: Eine Info für dich, welche Konzentration sich momentan in der Messkammer befinden sollte", 100, 120);
    text("3) Messpunkt: Zeigt an, an welchem Punkt im Zyklus sich der Sensor befindet", 100, 140);

    textSize(14);
    text("abgeschlossene Zyklen: 1/10", 800, 250);
    text("Konzentration: 0 ppm", 800, 270);
    text("Messpunkt: 37/50", 800, 290);

    translate(0, 200);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 225 && (mouseY-translation) < 275) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -200);

    for (int i = 1; i < 50; i++) {
      line(250 + 10*i, 600-70*fakeZyklus[i], 250 + 10*(i-1), 600-70*fakeZyklus[i-1]);
    }
    for (int i = 220; i < 270; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 249);
    textSize(20);
    noFill();
    stroke(255, 0, 0);
    strokeWeight(4);
    ellipse(900, 265, 240, 120);

    strokeWeight(1);
    stroke(0);
  }



  public void seite5() {
    textSize(16);
    text("Wenn 10 Messkurven aufgenommen wurden, wirst du gefragt, ob du mit der Messung zufrieden bist:", 20, 50);


    textSize(14);
    text("abgeschlossene Zyklen: 10/10", 800, 100);
    text("Konzentration: 0 ppm", 800, 120);
    text("Messpunkt: 50/50", 800, 140);

    translate(0, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 125 && (mouseY-translation) < 175) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -50);


    for (int j = 0; j < 10; j++) {
      for (int i = 1; i < 50; i++) {
        line(250 + 10*i, 450-70*fakeZyklus[i]/(0.1f*j + 1), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/(0.1f*j + 1));
      }
    }

    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 99);
    textSize(20);
    stroke(0);

    translate(0, 60);



    fill(255);
    stroke(0);

    //Messagebox
    rect(200, 450, 600, 100);
    //Ja Button
    rect(350, 500, 100, 40);
    //Nein Button
    rect(550, 500, 100, 40);
    fill(0);
    textSize(30);
    //Ja Button
    if (mouseX > 350 && mouseX < 450 && (mouseY-translation) > 560 && (mouseY-translation) < 600) {
      fill(255);
    } else {
      fill(220);
    }
    rect(350, 500, 100, 40);
    //Nein Button
    if (mouseX > 550 && mouseX < 650 && (mouseY-translation) > 560 && (mouseY-translation) < 600) {
      fill(255);
    } else {
      fill(220);
    }
    rect(550, 500, 100, 40);
    fill(0);
    textSize(30);
    text("Bist du mit der Messung zufrieden?", 250, 483);
    text("Ja", 390, 530);
    text("Nein", 570, 530);
    noFill();
    stroke(255, 0, 0);
    strokeWeight(3);

    ellipse(500, 500, 750, 100);

    strokeWeight(1);
    translate(0, -60);
    stroke(0);
    textSize(20);
  }



  public void seite6() {
    textSize(16);
    text("Wenn 10 Messkurven aufgenommen wurden, wirst du gefragt, ob du mit der Messung zufrieden bist:", 20, 50);


    textSize(14);
    text("abgeschlossene Zyklen: 10/10", 800, 100);
    text("Konzentration: 0 ppm", 800, 120);
    text("Messpunkt: 50/50", 800, 140);

    translate(0, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 75 && (mouseY-translation) < 125) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -50);

    strokeWeight(1);
    for (int j = 0; j < 10; j++) {
      for (int i = 1; i < 50; i++) {
        line(250 + 10*i, 450-70*fakeZyklus[i]/(0.1f*j+1), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/(0.1f*j+1));
      }
    }
    strokeWeight(1);
    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 99);
    textSize(20);
    stroke(0);

    translate(0, 60);
    fill(255);
    stroke(0);

    //Messagebox
    rect(200, 450, 600, 100);
    //Ja Button
    rect(350, 500, 100, 40);
    //Nein Button
    rect(550, 500, 100, 40);
    fill(0);
    textSize(30);
    //Ja Button
    if (mouseX > 350 && mouseX < 450 && (mouseY-translation) > 560 && (mouseY-translation) < 600) {
      fill(255);
    } else {
      fill(220);
    }
    rect(350, 500, 100, 40);
    //Nein Button
    if (mouseX > 550 && mouseX < 650 && (mouseY-translation) > 560 && (mouseY-translation) < 600) {
      fill(255);
    } else {
      fill(220);
    }
    rect(550, 500, 100, 40);
    fill(0);
    textSize(30);
    text("Bist du mit der Messung zufrieden?", 250, 483);
    text("Ja", 390, 530);
    text("Nein", 570, 530);
    translate(0, -60);
    textSize(16);
    noFill();
    strokeWeight(4);
    stroke(255, 0, 0);
    ellipse(600, 580, 120, 60);
    fill(0);
    strokeWeight(1);
    fill(255);
    stroke(0);
    rect(150, 640, 700, 110);

    fill(0);
    noStroke();
    text("Das Ethanol braucht eine gewisse Zeit bis es sich gleichmäßig in der Messkammer ver-\nteilt hat. In dieser Zeit ändert sich das Messignal noch deutlich (siehe oben).\nWenn du auf 'Nein' klickst, werden die Messkurven der aktuellen Konzentration gelöscht,\nund erneut 10 Zyklen aufgenommen.", 160, 662);
    //text("Wenn du auf 'Nein' klickst, wird die Messung wiederholt. Du kannst jederzeit die Messung durch Klicken auf den Button 'Messung\nwiederholen' klicken (beispielsweise, wenn abzusehen ist, dass die 10 Messkurven stark voneinander abweichen).", 20, 660);
    //stroke(0);
    //if (mouseX > 810 && mouseX < 930 && mouseY > 400 && mouseY < 450) {
    //  fill(255);
    //} else {
    //  fill(220);
    //}
    //rect(810, 400, 120, 50);
    //fill(0);
    //text("  Messung\nwiederholen", 825, 418);
    textSize(20);
    stroke(0);
  }


  public void seite7() {
    textSize(16);
    text("Wenn 10 Messkurven aufgenommen wurden, wirst du gefragt, ob du mit der Messung zufrieden bist:", 20, 50);


    textSize(14);
    text("abgeschlossene Zyklen: 5/10", 800, 100);
    text("Konzentration: 0 ppm", 800, 120);
    text("Messpunkt: 50/50", 800, 140);

    translate(0, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 75 && (mouseY-translation) < 125) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -50);

    for (int j = 0; j < 5; j++) {
      for (int i = 1; i < 50; i++) {
        line(250 + 10*i, 450-70*fakeZyklus[i]/(0.05f*j+1), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/(0.05f*j+1));
      }
    }
    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 99);
    textSize(20);
    stroke(0);

    translate(0, 60);

    fill(255);
    stroke(0);

    //Messagebox
    rect(200, 450, 600, 100);
    //Ja Button
    rect(350, 500, 100, 40);
    //Nein Button
    rect(550, 500, 100, 40);
    fill(0);
    textSize(30);
    //Ja Button
    if (mouseX > 350 && mouseX < 450 && (mouseY-translation) > 560 && (mouseY-translation) < 600) {
      fill(255);
    } else {
      fill(220);
    }
    rect(350, 500, 100, 40);
    //Nein Button
    if (mouseX > 550 && mouseX < 650 && (mouseY-translation) > 560 && (mouseY-translation) < 600) {
      fill(255);
    } else {
      fill(220);
    }
    rect(550, 500, 100, 40);
    fill(0);
    textSize(30);
    text("Bist du mit der Messung zufrieden?", 250, 483);
    text("Ja", 390, 530);
    text("Nein", 570, 530);
    translate(0, -60);
    textSize(16);
    fill(255);
    stroke(0);
    rect(150, 640, 700, 110);

    fill(0);
    noStroke();
    text("Wenn du bereits nach wenigen Zyklen merkst, dass das Ethanol sich noch nicht gleich-\nmäßig verteilt hat, kannst auch direkt auf 'Messung wiederholen' klicken.\nAuch dann werden die Zyklen dieser Konzentration gelöscht, und die 10 Zyklen starten\nerneut.", 160, 662);
    //text("Wenn du auf 'Nein' klickst, wird die Messung wiederholt. Du kannst jederzeit die Messung durch Klicken auf den Button 'Messung\nwiederholen' klicken (beispielsweise, wenn abzusehen ist, dass die 10 Messkurven stark voneinander abweichen).", 20, 660);
    stroke(0);
    if (mouseX > 810 && mouseX < 930 && mouseY > 400 && mouseY < 450) {
      fill(255);
    } else {
      fill(220);
    }
    rect(810, 400, 120, 50);
    fill(0);
    text("  Messung\nwiederholen", 825, 418);
    noFill();
    strokeWeight(4);
    stroke(255, 0, 0);
    ellipse(870, 425, 120, 60);
    strokeWeight(1);
    textSize(20);
    stroke(0);
  }



  public void seite8() {
    textSize(16);
    text("Wenn 10 Messkurven aufgenommen wurden, wirst du gefragt, ob du mit der Messung zufrieden bist:", 20, 50);


    textSize(14);
    text("abgeschlossene Zyklen: 10/10", 800, 100);
    text("Konzentration: 0 ppm", 800, 120);
    text("Messpunkt: 50/50", 800, 140);

    translate(0, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 75 && (mouseY-translation) < 125) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -50);

    for (int j = 0; j < 10; j++) {
      for (int i = 1; i < 50; i++) {
        line(250 + 10*i, 450-70*fakeZyklus[i]/(0.003f*j+1), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/(0.003f*j+1));
      }
    }
    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 99);
    textSize(20);
    stroke(0);

    translate(0, 60);
    fill(255);
    stroke(0);

    //Messagebox
    rect(200, 450, 600, 100);
    //Ja Button
    rect(350, 500, 100, 40);
    //Nein Button
    rect(550, 500, 100, 40);
    fill(0);
    textSize(30);
    //Ja Button
    if (mouseX > 350 && mouseX < 450 && (mouseY-translation) > 560 && (mouseY-translation) < 600) {
      fill(255);
    } else {
      fill(220);
    }
    rect(350, 500, 100, 40);
    //Nein Button
    if (mouseX > 550 && mouseX < 650 && (mouseY-translation) > 560 && (mouseY-translation) < 600) {
      fill(255);
    } else {
      fill(220);
    }
    rect(550, 500, 100, 40);
    fill(0);
    textSize(30);
    text("Bist du mit der Messung zufrieden?", 250, 483);
    text("Ja", 390, 530);
    text("Nein", 570, 530);
    translate(0, -60);
    textSize(16);
    noFill();
    strokeWeight(4);
    stroke(255, 0, 0);
    ellipse(400, 580, 120, 60);
    fill(0);
    strokeWeight(1);
    fill(255);
    stroke(0);
    rect(150, 640, 700, 85);

    fill(0);
    noStroke();
    text("Wenn die Messkurven sich nicht stark unterscheiden, hat sich das Ethanol gleich-\nmäßig verteilt. In diesem Fall kannst du auf 'Ja' klicken. Dann wirst du aufgefordert die\nEthanol-Konzentration zu erhöhen.", 160, 662);
    //text("Wenn du auf 'Nein' klickst, wird die Messung wiederholt. Du kannst jederzeit die Messung durch Klicken auf den Button 'Messung\nwiederholen' klicken (beispielsweise, wenn abzusehen ist, dass die 10 Messkurven stark voneinander abweichen).", 20, 660);
    stroke(0);
    if (mouseX > 810 && mouseX < 930 && mouseY > 400 && mouseY < 450) {
      fill(255);
    } else {
      fill(220);
    }
    rect(810, 400, 120, 50);
    fill(0);
    text("  Messung\nwiederholen", 825, 418);
    textSize(20);
    stroke(0);
  }




  public void seite9() {
    textSize(16);
    text("Der Durchschnitt der Signale einer Konzentration wird farbig dargestellt:", 20, 50);
    textSize(14);
    text("abgeschlossene Zyklen: 10/10", 800, 100);
    text("Konzentration: 40 ppm", 800, 120);
    text("Messpunkt: 50/50", 800, 140);

    translate(0, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 125 && (mouseY-translation) < 175) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -50);

    strokeWeight(3);
    for (int j = 0; j < 5; j++) {
      for (int i = 1; i < 50; i++) {
        if (j == 0) {
          stroke(255, 0, 0);
        } else if (j== 1) {
          stroke(0, 200, 0);
        } else if (j ==2) {
          stroke(255, 0, 255);
        } else if (j ==3) {
          stroke(255, 255, 0);
        } else if (j ==4) {
          stroke(0, 255, 255);
        }
        line(250 + 10*i, 450-70*fakeZyklus[i]/((j+1)), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/((j+1)));
      }
    }
    fill(255, 0, 0);
    text("0 ppm", 810, 200);
    fill(0, 200, 0);
    text("10 ppm", 810, 220);
    fill(255, 0, 255);
    text("20 ppm", 810, 240);
    fill(255, 255, 0);
    text("30 ppm", 810, 260);
    fill(0, 255, 255);
    text("40 ppm", 810, 280);





    strokeWeight(1);
    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 99);
    textSize(20);
    stroke(0);
    textSize(20);
  }








  public void seite10() {
    textSize(20);
    textSize(14);
    text("abgeschlossene Zyklen: 10/10", 800, 100);
    text("Konzentration: 40 ppm", 800, 120);
    text("Messpunkt: 50/50", 800, 140);

    translate(0, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 75 && (mouseY-translation) < 125) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -50);

    strokeWeight(3);
    for (int j = 0; j < 5; j++) {
      for (int i = 1; i < 50; i++) {
        if (j == 0) {
          stroke(255, 0, 0);
        } else if (j== 1) {
          stroke(0, 200, 0);
        } else if (j ==2) {
          stroke(255, 0, 255);
        } else if (j ==3) {
          stroke(255, 255, 0);
        } else if (j ==4) {
          stroke(0, 255, 255);
        }
        line(250 + 10*i, 450-70*fakeZyklus[i]/((j+1)), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/((j+1)));
      }
    }
    fill(255, 0, 0);
    text("0 ppm", 810, 200);
    fill(0, 200, 0);
    text("10 ppm", 810, 220);
    fill(255, 0, 255);
    text("20 ppm", 810, 240);
    fill(255, 255, 0);
    text("30 ppm", 810, 260);
    fill(0, 255, 255);
    text("40 ppm", 810, 280);





    strokeWeight(1);
    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 99);
    stroke(0);
    translate(0, 50);

    fill(255);
    rect(10, 475, 1015, 190);
    fill(0);
    text("Wenn 5 verschiedene Konzentrationen aufgenommen wurden, hast du die Aufgabe 2 Merkmale der Kurven zu bestim-\nmen. Dazu stehen dir Maximum, Minimum, Mittelwert und Steigung innerhalb eines Intervalls zur Auswahl.\nKlicke auf die jeweiligen Buttons (links) und wähle 2 Merkmale aus. Wenn du mit der Maus in das Intervall klickst, kanns du es\nverschieben. Durch erneutes Klicken auf den Button wählst du das Merkmal ab.\n\nWenn du genau 2 Merkmale ausgewählt hast erscheint ein Button. Wenn du zufrieden bist, kommst du mit einem Klick darauf\nweiter.", 20, 500);
    textSize(20);  


    text("Merkmale", 75, 120);
    stroke(0);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 195 && (mouseY-translation) < 245) {
      fill(0, 0, 255, 20);
    } else {
      fill(100, 100, 255, 220);
    }
    //Maximum
    rect(75, 145, 100, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 270 && (mouseY-translation) < 320) {
      fill(255, 100, 100, 20);
    } else {
      fill(255, 0, 0, 220);
    }
    //Minimum
    rect(75, 220, 100, 50);


    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 345 && (mouseY-translation) < 395) {
      fill(255, 255, 0, 20);
    } else {
      fill(255, 255, 0, 220);
    }
    //Steigung
    rect(75, 295, 100, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) >420 && (mouseY-translation) < 470) {
      fill(0, 255, 0, 20);
    } else {
      fill(0, 255, 0, 220);
    }
    //Mittelwert
    rect(75, 370, 100, 50);

    fill(0);
    textSize(16);
    text("Maximum", 87, 175);
    text("Minimum", 87, 250);
    text("Steigung", 90, 325);
    text("Mittelwert", 87, 400);

    textSize(20);  
    if (SteigAktiv) {
      Steigung();
    }
    if (MWAktiv) {
      Mittelwert();
    }
    if (MaxAktiv) {
      Maximum();
    }
    if (MinAktiv) {
      Minimum();
    }

    translate(0, -50);
  }


  public void seite11() {
    textSize(20);
    textSize(14);
    text("abgeschlossene Zyklen: 10/10", 800, 100);
    text("Konzentration: 40 ppm", 800, 120);
    text("Messpunkt: 50/50", 800, 140);

    translate(0, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 75 && (mouseY-translation) < 125) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -50);

    strokeWeight(3);
    for (int j = 0; j < 5; j++) {
      for (int i = 1; i < 50; i++) {
        if (j == 0) {
          stroke(255, 0, 0);
        } else if (j== 1) {
          stroke(0, 200, 0);
        } else if (j ==2) {
          stroke(255, 0, 255);
        } else if (j ==3) {
          stroke(255, 255, 0);
        } else if (j ==4) {
          stroke(0, 255, 255);
        }
        line(250 + 10*i, 450-70*fakeZyklus[i]/((j+1)), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/((j+1)));
      }
    }
    fill(255, 0, 0);
    text("0 ppm", 810, 200);
    fill(0, 200, 0);
    text("10 ppm", 810, 220);
    fill(255, 0, 255);
    text("20 ppm", 810, 240);
    fill(255, 255, 0);
    text("30 ppm", 810, 260);
    fill(0, 255, 255);
    text("40 ppm", 810, 280);






    strokeWeight(1);
    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 99);
    stroke(0);
    translate(0, 50);

    fill(255);
    rect(210, 460, 580, 30);
    fill(0);
    text("Du kannst dir die Merkmale, auch in dem unteren Graphen anschauen.", 220, 480);
    textSize(20);  


    text("Merkmale", 75, 120);
    stroke(0);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 195 && (mouseY-translation) < 245) {
      fill(0, 0, 255, 20);
    } else {
      fill(100, 100, 255, 220);
    }
    //Maximum
    rect(75, 145, 100, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 270 && (mouseY-translation) < 320) {
      fill(255, 100, 100, 20);
    } else {
      fill(255, 0, 0, 220);
    }
    //Minimum
    rect(75, 220, 100, 50);


    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 345 && (mouseY-translation) < 395) {
      fill(255, 255, 0, 20);
    } else {
      fill(255, 255, 0, 220);
    }
    //Steigung
    rect(75, 295, 100, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) >420 && (mouseY-translation) < 470) {
      fill(0, 255, 0, 20);
    } else {
      fill(0, 255, 0, 220);
    }
    //Mittelwert
    rect(75, 370, 100, 50);

    fill(0);
    textSize(16);
    text("Maximum", 87, 175);
    text("Minimum", 87, 250);
    text("Steigung", 90, 325);
    text("Mittelwert", 87, 400);

    textSize(20);  
    if (SteigAktiv) {
      Steigung();
    }
    if (MWAktiv) {
      Mittelwert();
    }
    if (MaxAktiv) {
      Maximum();
    }
    if (MinAktiv) {
      Minimum();
    }

    fill(0);
    text("Maximum", 230, 520);
    text("Steigung", 635, 520);

    fill(255);
    rect(125, 525, 300, 200);
    rect(525, 525, 300, 200);
    fill(100, 100, 255, 50);
    rect(125, 525, 300, 200);
    fill(255, 255, 0, 50);
    rect(525, 525, 300, 200);


    stroke(0);
    line(125, 525, 125, 730);
    line(120, 725, 400, 725);

    for (int i = 0; i < 5; i++) {
      line(175 + 50*i, 525, 175 + 50*i, 730); 
      line(575 + 50*i, 525, 575 + 50*i, 730);
    }


    line(625, 525, 625, 730);
    line(620, 725, 800, 725);

    textSize(12);
    fill(0);
    text("0 ppm", 130, 740);
    text("10 ppm", 180, 740);
    text("20 ppm", 230, 740);
    text("30 ppm", 280, 740);
    text("40 ppm", 330, 740);
    text("?? ppm", 380, 740);

    text("0 ppm", 530, 740);
    text("10 ppm", 580, 740);
    text("20 ppm", 630, 740);
    text("30 ppm", 680, 740);
    text("40 ppm", 730, 740);
    text("?? ppm", 780, 740);
    textSize(20);
    translate(0, -50);

    GrenzeMaximumLinks = 10;
    GrenzeSteigungLinks = 30;

    noStroke();  
    for (int i = 0; i <10; i++) {
      fill(255, 0, 0, 100);
      ellipse(150, 610+i, 10, 10);
      ellipse(550, 740 + 0.1f*i, 10, 10);
      fill(0, 200, 0, 100);
      ellipse(200, 660+i, 10, 10);
      ellipse(600, 690 + 0.1f*i, 10, 10);
      fill(255, 0, 255, 100);
      ellipse(250, 695+i, 10, 10);
      ellipse(650, 660 + 0.1f*i, 10, 10);
      fill(255, 255, 0, 100);
      ellipse(300, 710+i, 10, 10);
      ellipse(700, 630 + 0.1f*i, 10, 10);
      fill(0, 255, 255, 100);
      ellipse(350, 720+i, 10, 10);
      ellipse(750, 610 + 0.1f*i, 10, 10);
    }    


    stroke(0);
  }


  public void seite12() {
    textSize(20);
    textSize(14);
    text("abgeschlossene Zyklen: 10/10", 800, 100);
    text("Konzentration: 40 ppm", 800, 120);
    text("Messpunkt: 50/50", 800, 140);

    translate(0, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 75 && (mouseY-translation) < 125) {
      fill(255);
    } else {
      fill(220);
    }
    textSize(16);
    rect(75, 25, 100, 50);
    fill(0);
    text("Messung \n starten", 91, 45);

    Koordinatenkreuz();
    translate(0, -50);

    strokeWeight(3);
    for (int j = 0; j < 5; j++) {
      for (int i = 1; i < 50; i++) {
        if (j == 0) {
          stroke(255, 0, 0);
        } else if (j== 1) {
          stroke(0, 200, 0);
        } else if (j ==2) {
          stroke(255, 0, 255);
        } else if (j ==3) {
          stroke(255, 255, 0);
        } else if (j ==4) {
          stroke(0, 255, 255);
        }
        line(250 + 10*i, 450-70*fakeZyklus[i]/((j+1)), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/((j+1)));
      }
    }

    for (int i = 1; i < 50; i++) {
      stroke(0);
      line(250 + 10*i, 450-70*fakeZyklus[i]/((1.7f+1)), 250 + 10*(i-1), 450-70*fakeZyklus[i-1]/((1.7f+1)));
    }






    fill(255, 0, 0);
    text("0 ppm", 810, 200);
    fill(0, 200, 0);
    text("10 ppm", 810, 220);
    fill(255, 0, 255);
    text("20 ppm", 810, 240);
    fill(255, 255, 0);
    text("30 ppm", 810, 260);
    fill(0, 255, 255);
    text("40 ppm", 810, 280);
    fill(0);
    text("?? ppm", 810, 300);





    strokeWeight(1);
    for (int i = 70; i < 120; i++) {
      stroke(255 - 255 * i / 2500);
      line(200, i, 245, i);
    }
    textSize(16);
    fill(0);
    text(200, 198, 99);
    stroke(0);
    translate(0, 50);

    fill(255);
    rect(10, 460, 1020, 85);
    fill(0);
    text("Nachdem du alle Trainingsdaten aufgenommen hast, werden wir ein mathematisches Modell erstellen, das uns, bei gegebenen\nMerkmalen, eine Vorhersage für die Konzentration liefert. Das Modell werden wir dann an einer unbekannten Konzentration\ntesten, indem wir erneut Merkmale aufnehmen.", 20, 480);
    textSize(20);  


    text("Merkmale", 75, 120);
    stroke(0);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 195 && (mouseY-translation) < 245) {
      fill(0, 0, 255, 20);
    } else {
      fill(100, 100, 255, 220);
    }
    //Maximum
    rect(75, 145, 100, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 270 && (mouseY-translation) < 320) {
      fill(255, 100, 100, 20);
    } else {
      fill(255, 0, 0, 220);
    }
    //Minimum
    rect(75, 220, 100, 50);


    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) > 345 && (mouseY-translation) < 395) {
      fill(255, 255, 0, 20);
    } else {
      fill(255, 255, 0, 220);
    }
    //Steigung
    rect(75, 295, 100, 50);
    if (mouseX > 75 && mouseX < 175 && (mouseY-translation) >420 && (mouseY-translation) < 470) {
      fill(0, 255, 0, 20);
    } else {
      fill(0, 255, 0, 220);
    }
    //Mittelwert
    rect(75, 370, 100, 50);

    fill(0);
    textSize(16);
    text("Maximum", 87, 175);
    text("Minimum", 87, 250);
    text("Steigung", 90, 325);
    text("Mittelwert", 87, 400);

    textSize(20);  
    if (SteigAktiv) {
      Steigung();
    }
    if (MWAktiv) {
      Mittelwert();
    }
    if (MaxAktiv) {
      Maximum();
    }
    if (MinAktiv) {
      Minimum();
    }
    translate(0, 50);
    fill(0);
    text("Maximum", 230, 520);
    text("Steigung", 635, 520);

    fill(255);
    rect(125, 525, 300, 200);
    rect(525, 525, 300, 200);
    fill(100, 100, 255, 50);
    rect(125, 525, 300, 200);
    fill(255, 255, 0, 50);
    rect(525, 525, 300, 200);


    stroke(0);
    line(125, 525, 125, 730);
    line(120, 725, 400, 725);

    for (int i = 0; i < 5; i++) {
      line(175 + 50*i, 525, 175 + 50*i, 730); 
      line(575 + 50*i, 525, 575 + 50*i, 730);
    }


    line(625, 525, 625, 730);
    line(620, 725, 800, 725);

    textSize(12);
    fill(0);
    text("0 ppm", 130, 740);
    text("10 ppm", 180, 740);
    text("20 ppm", 230, 740);
    text("30 ppm", 280, 740);
    text("40 ppm", 330, 740);
    text("?? ppm", 380, 740);

    text("0 ppm", 530, 740);
    text("10 ppm", 580, 740);
    text("20 ppm", 630, 740);
    text("30 ppm", 680, 740);
    text("40 ppm", 730, 740);
    text("?? ppm", 780, 740);
    textSize(20);
    translate(0, -50);

    GrenzeMaximumLinks = 10;
    GrenzeSteigungLinks = 30;

    noStroke();  
    for (int i = 0; i <10; i++) {
      fill(255, 0, 0, 100);
      ellipse(150, 610+i, 10, 10);
      ellipse(550, 740 + 0.1f*i, 10, 10);
      fill(0, 200, 0, 100);
      ellipse(200, 660+i, 10, 10);
      ellipse(600, 690 + 0.1f*i, 10, 10);
      fill(255, 0, 255, 100);
      ellipse(250, 695+i, 10, 10);
      ellipse(650, 660 + 0.1f*i, 10, 10);
      fill(255, 255, 0, 100);
      ellipse(300, 710+i, 10, 10);
      ellipse(700, 630 + 0.1f*i, 10, 10);
      fill(0, 255, 255, 100);
      ellipse(350, 720+i, 10, 10);
      ellipse(750, 610 + 0.1f*i, 10, 10);
    }
    fill(0, 100);
    ellipse(400, 670, 10, 10);
    ellipse(800, 660, 10, 10);
   
    noFill();
    stroke(255,0,0);
    strokeWeight(4);
    ellipse(840, 250, 90, 50);
    ellipse(400, 670, 30, 30);
    
    ellipse(800, 660, 30, 30);
    
    
    
    stroke(0);
    strokeWeight(1);
  }

  public void seite13() {
    textSize(20);
    textAlign(CENTER);
    text("Du kannst nun zur echten Messung. Wenn du während des Versuchs Fragen hast, stehen dir die Betreuer\nzur Verfügung.", 525, 300);
    textAlign(NORMAL);
  }
boolean auswertung = false;


public void Zufrieden() {
  pushMatrix();
  fill(255);
  stroke(0);

  //Messagebox
  rect(200, 500, 600, 100);
  //Ja Button
  rect(350, 550, 100, 40);
  //Nein Button
  rect(550, 550, 100, 40);
  fill(0);
  textSize(30);
  if (aktuelleKonzentration < anzahlKonzentrationen + 1) {
    fill(255);
    stroke(0);
    //Messagebox
    rect(200, 500, 600, 150);
    if (Aufforderung == false) {
      //Ja Button
      if (mouseX > 350 && mouseX < 450 && (mouseY-translation) > 550 && (mouseY-translation) < 590) {
        fill(255);
      } else {
        fill(220);
      }
      rect(350, 550, 100, 40);
      //Nein Button
      if (mouseX > 550 && mouseX < 650 && (mouseY-translation) > 550 && (mouseY-translation) < 590) {
        fill(255);
      } else {
        fill(220);
      }
      rect(550, 550, 100, 40);
    } else {
      //weiter Button
      if (mouseX > 450 && mouseX < 550 && (mouseY-translation) > 600 && (mouseY-translation) < 640) {
        fill(255);
      } else {
        fill(220);
      }
      rect(450, 600, 100, 40);
    }
    fill(0);
    textSize(30);
    if (Aufforderung == false) {
      text("Bist du mit der Messung zufrieden?", 250, 533);
      text("Ja", 390, 580);
      text("Nein", 570, 580);
    } else {
      if (aktuelleKonzentration != anzahlKonzentrationen-1) {
        textSize(20);
        if (aktuelleKonzentration == 0) {
          float temp = Konzentration1Wert / ppmProMlWert;
          String temp2 = nf(temp, 0, 2);
          String temp3 = nf(round(Konzentration1Wert), 0, 0).replace('.', ',');
          text("Spritze nun " + temp2.replace('.', ',') + "ml in die Messkammer, um eine Konzen-\ntration von " + temp3 + " ppm zu erhalten.", 220, 533);
        }
        if (aktuelleKonzentration == 1) {
          float temp0 = Konzentration2Wert - Konzentration1Wert;
          float temp = temp0 / ppmProMlWert;
          String temp2 = nf(temp, 0, 2);
          String temp3 = nf(round(Konzentration2Wert), 0, 0).replace('.', ',');
          text("Spritze nun " + temp2.replace('.', ',') + "ml in die Messkammer, um eine Konzen-\ntration von " + temp3 + " ppm zu erhalten.", 220, 533);
        }
        if (aktuelleKonzentration == 2) {
          float temp0 = Konzentration3Wert - Konzentration2Wert;
          float temp = temp0 / ppmProMlWert;
          String temp2 = nf(temp, 0, 2);
          String temp3 = nf(round(Konzentration3Wert), 0, 0).replace('.', ',');
          text("Spritze nun " + temp2.replace('.', ',') + " ml in die Messkammer, um eine Konzen-\ntration von " + temp3 + " ppm zu erhalten.", 220, 533);
        }

        if (aktuelleKonzentration == 3) {
          float temp0 = 40 - Konzentration3Wert;
          float temp = temp0 / ppmProMlWert;
          String temp2 = nf(temp, 0, 2);
          text("Spritze nun " + temp2.replace('.', ',') + " ml in die Messkammer, um eine Konzen-\ntration von 40 ppm zu erhalten.", 220, 533);
        }

        textSize(26);
        text("weiter", 465, 630);
      }
    }
  }

  textSize(14);

  //Nicht zufrieden, Messung wiederholen
  if (mousePressed && mouseX > 550 && mouseX <650 && (mouseY-translation) > 550 && (mouseY-translation)< 590 ) {
    aktuellerZyklus = 0;
    wait = true;
    myPort.clear();
    // Wenn man nicht zufrieden ist, werden die Daten dieser Konzentration gelöscht
    for (int i = aktuelleKonzentration*(anzahlZyklen); i < aktuelleKonzentration*(anzahlZyklen) + anzahlZyklen; i++) {
      for (int j = 0; j < 50; j++) {
        Messdaten[i][j] = 0;
      }
    }
  }
  popMatrix();
}



public void ErklaerungMerkmale() {
  if (erklaerung) {
    fill(200, 220);
    noStroke();
    rect(0, 0, width, height);
    fill(255);
    stroke(0);
    rect(50, 150, 950, 335);
    fill(0);
    noStroke();
    textSize(20);
    text("Bestimme nun die Unterschiede zwischen den Kurven. Du hast die Auswahl zwischen Maxi-\nmum, Minimum, Steigung und Mittelwert in verschiedenen Bereichen.", 60, 180);
    text("Klicke mit der Maus auf die Buttons auf der linken Seite, um ein Merkmal auszuwählen. Du\nkannst den Bereich, in dem diese Merkmale bestimmt werden, im Graphen verschieben,\nindem du mit der Maus in diesen Bereich klickst und die Maus gedrückt hälst.", 60, 270);
    text("Klickst du ein zweites Mal auf die linken Buttons wird deine Auswahl aufgehoben.", 60, 380);
    text("Wähle zwei Merkmale aus. Anschließend erscheint ein 'weiter' Button, der dich wieder in\nden Selbstlernkurs führt.", 60, 430);


    fill(255);
    if (mouseX > 475 && mouseX < 625 && mouseY > 500 && mouseY < 550) {
      fill(255);
    } else {
      fill(220);
    }
    stroke(0);
    rect(475, 500, 150, 50);
    fill(0);
    text("Verstanden", 495, 530);
  } else {
    preview();
    if (mouseX > 475 && mouseX < 575 && (mouseY-translation) > 900 && (mouseY-translation) < 950) {
      fill(200);
    } else {
      fill(255);
    }
    if (anzahlMerkmale == 2 && unbekannteKonzentration == false) {
      rect(475, 900, 100, 50);
      fill(0);
      text("weiter", 495, 930);
    }
  }
}






public void preview() {
  fill(255);
  rect(120, 500, 360, 300);
  rect(520, 500, 360, 300);

  if (unbekannteKonzentration) {
    fill(255);
    textSize(20);
    text("Merkmale der unbekannten Konzentration:", 275, 860);
  }

  //Daten zwischen 0 und 1 normalisieren:
  float MerkmaleMaxMax = 0;
  float MerkmaleMinMax = 0;
  float MerkmaleMWMax = 0;

  float MerkmaleSlopeMax = 0;
  float MerkmaleSlopeMin = 999999999;



  for (int i = 0; i < anzahlKonzentrationen; i++) {
    for (int j = 0; j < anzahlZyklen; j++) {
      if (MerkmalMaximum[i*anzahlZyklen + j] > MerkmaleMaxMax) {
        MerkmaleMaxMax = MerkmalMaximum[i*anzahlZyklen + j]*1.115f;
      }
      if (MerkmalMinimum[i*anzahlZyklen + j] > MerkmaleMinMax) {
        MerkmaleMinMax = MerkmalMinimum[i*anzahlZyklen + j]*1.115f;
      }

      if (MerkmalMittelwert[i*anzahlZyklen + j] > MerkmaleMWMax) {
        MerkmaleMWMax = MerkmalMittelwert[i*anzahlZyklen + j]*1.115f;
      }
      if (MerkmalSteigung[i*anzahlZyklen + j] > MerkmaleSlopeMax) {
        MerkmaleSlopeMax = MerkmalSteigung[i*anzahlZyklen + j];
      }      
      if (MerkmalSteigung[i*anzahlZyklen + j] < MerkmaleSlopeMin) {
        MerkmaleSlopeMin = MerkmalSteigung[i*anzahlZyklen + j];
      }
    }
  }
  pushMatrix();
  translate(width/2, height/2);
  rotate(3*PI/2);
  fill(0);
  text("kΩ", -125, -420);
  text("0", -265, -420);
  stroke(200);
  line(10, -405, 10, -45);
  line(10, -5, 10, 355);
  popMatrix();

  int anz = 0;
  if(MaxAktiv){
    anz += 1;
  }
  if(MinAktiv){
    anz += 1;
  }
  if(MWAktiv){
    anz += 1;
  }

  if (SteigAktiv && anz == 1) {
    pushMatrix();
    translate(width/2, height/2);
    rotate(3*PI/2);
    fill(0);
    text("kΩ/Messpunkt", -160, -20);
    text(round(MerkmaleSlopeMax/1000), -10, -20);
    text(round(MerkmaleSlopeMin/1000), -255, -20);
    stroke(200);
    line(-230, -5, -230, 355);
    popMatrix();
  } else {
    pushMatrix();
    translate(width/2, height/2);
    rotate(3*PI/2);
    fill(0);
    text("kΩ", -125, -20);
    text("0", -265, -20);
    popMatrix();
  }
  stroke(0);

  textAlign(CENTER);

  if (MaxAktiv && MinAktiv && MWAktiv == false && SteigAktiv == false) {
    pushMatrix();
    translate(width/2, height/2);
    rotate(3*PI/2);
    fill(0);
    text(round(MerkmaleMaxMax/1000),  10, -420);
    text(round(MerkmaleMinMax/1000), 10, -20);
    popMatrix();



    fill(0, 0, 255, 50); 
    rect(120, 500, 360, 300);
    fill(255, 0, 0, 50);
    rect(520, 500, 360, 300);
    fill(0);
    textSize(18);
    text("Maximum", 295, 485);
    text("Minimum", 695, 485);
    for (int i = 0; i < anzahlKonzentrationen; i++) {
      for (int j = 0; j < anzahlZyklen; j++) {
        noStroke();
        if (i == 0) {
          fill(255, 0, 0, 100);
        } else if (i == 1) {
          fill(0, 0, 255, 100);
        } else if (i == 2) {
          fill(0, 200, 0, 100);
        } else if (i == 3) {
          fill(255, 0, 255, 100);
        } else if (i == 4) {
          fill(255, 255, 0, 100);
        }

        ellipse(150 + 60*i, 800 - 300*MerkmalMaximum[i*anzahlZyklen + j]/MerkmaleMaxMax, 10, 10);
        ellipse(550 + 60*i, 800 - 300*MerkmalMinimum[i*anzahlZyklen + j]/MerkmaleMinMax, 10, 10);
      }
    }

    if (unbekannteKonzentration) {
      fill(0, 100);
      ellipse(450, 800 - 300*MerkmalMaximumUnbekannt/MerkmaleMaxMax, 10, 10);
      ellipse(850, 800 - 300*MerkmalMinimumUnbekannt/MerkmaleMinMax, 10, 10);
      fill(255);

      text("Maximum: " + PApplet.parseInt(MerkmalMaximumUnbekannt)/1000  + " kΩ", 500, 910);
      text("Minimum: " + PApplet.parseInt(MerkmalMinimumUnbekannt)/1000  + " kΩ", 500, 940);
    }
  } else if (MaxAktiv && SteigAktiv && MWAktiv == false && MinAktiv == false) {
    pushMatrix();
    translate(width/2, height/2);
    rotate(3*PI/2);
    fill(0);
    text(round(MerkmaleMaxMax/1000), 10, -420);
    popMatrix();

    fill(0, 0, 255, 50); 
    rect(120, 500, 360, 300);
    fill(255, 255, 0, 50);
    rect(520, 500, 360, 300);
    fill(0);
    textSize(18);
    text("Maximum", 295, 485);
    text("Steigung", 695, 485);
    for (int i = 0; i < anzahlKonzentrationen; i++) {
      for (int j = 0; j < anzahlZyklen; j++) {
        noStroke();
        if (i == 0) {
          fill(255, 0, 0, 100);
        } else if (i == 1) {
          fill(0, 0, 255, 100);
        } else if (i == 2) {
          fill(0, 200, 0, 100);
        } else if (i == 3) {
          fill(255, 0, 255, 100);
        } else if (i == 4) {
          fill(255, 255, 0, 100);
        }

        ellipse(150 + 60*i, 800 - 300*MerkmalMaximum[i*anzahlZyklen + j]/MerkmaleMaxMax, 10, 10);
        ellipse(550 + 60*i, 770 - 240*((MerkmalSteigung[i*anzahlZyklen + j]-MerkmaleSlopeMin)/(MerkmaleSlopeMax-MerkmaleSlopeMin)), 10, 10);
      }
    }



    if (unbekannteKonzentration) {
      fill(0, 100);
      ellipse(450, 800 - 300*MerkmalMaximumUnbekannt/MerkmaleMaxMax, 10, 10);
      ellipse(850, 800 - 300*(MerkmalSteigungUnbekannt-MerkmaleSlopeMin)/(MerkmaleSlopeMax-MerkmaleSlopeMin), 10, 10);
      fill(255);
      text("Maximum: " + PApplet.parseInt(MerkmalMaximumUnbekannt)/1000  + " kΩ", 500, 910);
      text("Steigung: " + PApplet.parseInt(MerkmalSteigungUnbekannt)/1000  + " kΩ/Messpunkt", 500, 940);
    }
  } else if (MaxAktiv && MWAktiv && MinAktiv == false && SteigAktiv == false) {
    pushMatrix();
    translate(width/2, height/2);
    rotate(3*PI/2);
    fill(0);
    text(round(MerkmaleMaxMax/1000), 10, -420);
    text(round(MerkmaleMWMax/1000), 10, -20);
    popMatrix();
    fill(0, 0, 255, 50); 
    rect(120, 500, 360, 300);
    fill(0, 255, 0, 50);
    rect(520, 500, 360, 300);
    fill(0);
    textSize(18);
    text("Maximum", 295, 485);
    text("Mittelwert", 695, 485);
    for (int i = 0; i < anzahlKonzentrationen; i++) {
      for (int j = 0; j < anzahlZyklen; j++) {
        noStroke();
        if (i == 0) {
          fill(255, 0, 0, 100);
        } else if (i == 1) {
          fill(0, 0, 255, 100);
        } else if (i == 2) {
          fill(0, 200, 0, 100);
        } else if (i == 3) {
          fill(255, 0, 255, 100);
        } else if (i == 4) {
          fill(255, 255, 0, 100);
        }

        ellipse(150 + 60*i, 800 - 300*MerkmalMaximum[i*anzahlZyklen + j]/MerkmaleMaxMax, 10, 10);
        ellipse(550 + 60*i, 800 - 300*(MerkmalMittelwert[i*anzahlZyklen + j]/MerkmaleMWMax), 10, 10);
      }
    }


    if (unbekannteKonzentration) {
      fill(0, 100);
      ellipse(450, 800 - 300*MerkmalMaximumUnbekannt/MerkmaleMaxMax, 10, 10);
      ellipse(850, 800 - 300*MerkmalMittelwertUnbekannt/MerkmaleMWMax, 10, 10);
      fill(255);

      text("Maximum: " + PApplet.parseInt(MerkmalMaximumUnbekannt)/1000  + " kΩ", 500, 910);
      text("Mittelwert: " + PApplet.parseInt(MerkmalMittelwertUnbekannt)/1000  + " kΩ", 500, 940);
    }
  } else if (MinAktiv && MWAktiv && MaxAktiv == false && SteigAktiv == false) {
    pushMatrix();
    translate(width/2, height/2);
    rotate(3*PI/2);
    fill(0);
    text(round(MerkmaleMinMax/1000), 10, -420);
    text(round(MerkmaleMWMax/1000), 10, -20);
    popMatrix();
    fill(255, 0, 0, 50); 
    rect(120, 500, 360, 300);
    fill(0, 255, 0, 50);
    rect(520, 500, 360, 300);
    fill(0);
    textSize(18);
    text("Minimum", 265, 485);
    text("Mittelwert", 665, 485);
    for (int i = 0; i < anzahlKonzentrationen; i++) {
      for (int j = 0; j < anzahlZyklen; j++) {
        noStroke();
        if (i == 0) {
          fill(255, 0, 0, 100);
        } else if (i == 1) {
          fill(0, 0, 255, 100);
        } else if (i == 2) {
          fill(0, 200, 0, 100);
        } else if (i == 3) {
          fill(255, 0, 255, 100);
        } else if (i == 4) {
          fill(255, 255, 0, 100);
        }

        ellipse(150 + 60*i, 800 - 300*MerkmalMinimum[i*anzahlZyklen + j]/MerkmaleMinMax, 10, 10);
        ellipse(550 + 60*i, 800 - 300*(MerkmalMittelwert[i*anzahlZyklen + j]/MerkmaleMWMax), 10, 10);
      }
    }


    if (unbekannteKonzentration) {
      fill(0, 100);
      ellipse(450, 800 - 300*MerkmalMinimumUnbekannt/MerkmaleMinMax, 10, 10);
      ellipse(850, 800 - 300*MerkmalMittelwertUnbekannt/MerkmaleMWMax, 10, 10);

      fill(255);
      text("Minimum: " + PApplet.parseInt(MerkmalMinimumUnbekannt)/1000  + " kΩ", 500, 910);
      text("Mittelwert: " + PApplet.parseInt(MerkmalMittelwertUnbekannt)/1000  + " kΩ", 500, 940);
    }
  } else if (MinAktiv && SteigAktiv && MaxAktiv == false && MWAktiv == false) {
    pushMatrix();
    translate(width/2, height/2);
    rotate(3*PI/2);
    fill(0);
    text(round(MerkmaleMinMax/1000), 10, -420);
    popMatrix();
    fill(255, 0, 0, 50); 
    rect(120, 500, 360, 300);
    fill(255, 255, 0, 50);
    rect(520, 500, 360, 300);
    fill(0);
    textSize(18);
    text("Minimum", 295, 485);
    text("Steigung", 695, 485);
    for (int i = 0; i < anzahlKonzentrationen; i++) {
      for (int j = 0; j < anzahlZyklen; j++) {
        noStroke();
        if (i == 0) {
          fill(255, 0, 0, 100);
        } else if (i == 1) {
          fill(0, 0, 255, 100);
        } else if (i == 2) {
          fill(0, 200, 0, 100);
        } else if (i == 3) {
          fill(255, 0, 255, 100);
        } else if (i == 4) {
          fill(255, 255, 0, 100);
        }

        ellipse(150 + 60*i, 800 - 300*MerkmalMinimum[i*anzahlZyklen + j]/MerkmaleMinMax, 10, 10);
        ellipse(550 + 60*i, 750 - 280*((MerkmalSteigung[i*anzahlZyklen + j]-MerkmaleSlopeMin)/(MerkmaleSlopeMax-MerkmaleSlopeMin)), 10, 10);
      }
    }



    if (unbekannteKonzentration) {
      fill(0, 100);
      ellipse(450, 800 - 300*MerkmalMinimumUnbekannt/MerkmaleMinMax, 10, 10);
      ellipse(850, 800 - 300*(MerkmalSteigungUnbekannt-MerkmaleSlopeMin)/(MerkmaleSlopeMax-MerkmaleSlopeMin), 10, 10);

      fill(255);
      text("Minimum: " + PApplet.parseInt(MerkmalMinimumUnbekannt)/1000  + " kΩ", 500, 910);
      text("Steigung: " + PApplet.parseInt(MerkmalSteigungUnbekannt)/1000  + " kΩ/Messpunkt", 500, 940);
    }
  } else if (MWAktiv && SteigAktiv && MaxAktiv == false && MinAktiv == false) {
    pushMatrix();
    translate(width/2, height/2);
    rotate(3*PI/2);
    fill(0);
    text(round(MerkmaleMWMax/1000), 10, -420);
    popMatrix();
    fill(0, 255, 0, 50); 
    rect(120, 500, 360, 300);
    fill(255, 255, 0, 50);
    rect(520, 500, 360, 300);
    fill(0);
    textSize(18);
    text("Mittelwert", 295, 485);
    text("Steigung", 695, 485);
    for (int i = 0; i < anzahlKonzentrationen; i++) {
      for (int j = 0; j < anzahlZyklen; j++) {
        noStroke();
        if (i == 0) {
          fill(255, 0, 0, 100);
        } else if (i == 1) {
          fill(0, 0, 255, 100);
        } else if (i == 2) {
          fill(0, 200, 0, 100);
        } else if (i == 3) {
          fill(255, 0, 255, 100);
        } else if (i == 4) {
          fill(255, 255, 0, 100);
        }

        ellipse(150 + 60*i, 800 - 300*(MerkmalMittelwert[i*anzahlZyklen + j]/MerkmaleMWMax), 10, 10);
        ellipse(550 + 60*i, 750 - 280*((MerkmalSteigung[i*anzahlZyklen + j]-MerkmaleSlopeMin)/(MerkmaleSlopeMax-MerkmaleSlopeMin)), 10, 10);
      }
    }



    if (unbekannteKonzentration) {
      fill(0, 100);
      ellipse(450, 800 - 300*MerkmalMittelwertUnbekannt/MerkmaleMWMax, 10, 10);
      ellipse(850, 800 - 300*(MerkmalSteigungUnbekannt-MerkmaleSlopeMin)/(MerkmaleSlopeMax-MerkmaleSlopeMin), 10, 10);
      fill(255);

      text("Mittelwert: " + PApplet.parseInt(MerkmalMittelwertUnbekannt)/1000  + " kΩ", 500, 910);
      text("Steigung: " + PApplet.parseInt(MerkmalSteigungUnbekannt)/1000  + " kΩ/Messpunkt", 500, 940);
    }
  }

  stroke(0);
  for (int i = 0; i < 5; i++) {
    line(180 + 60*i, 500, 180 + 60*i, 810);
    line(580 + 60*i, 500, 580 + 60*i, 810);
  }
  textAlign(CORNER);
  fill(0);
  noStroke();
  textSize(14);
  text("0 ppm", 130, 820);
  text(Konzentration1Wert + " ppm", 185, 820);
  text(Konzentration2Wert + " ppm", 245, 820);
  text(Konzentration3Wert + " ppm", 305, 820);
  text("40 ppm", 365, 820);
  text("?? ppm", 425, 820);

  text("0ppm", 530, 820);
  text(Konzentration1Wert + " ppm", 585, 820);
  text(Konzentration2Wert + " ppm", 645, 820);
  text(Konzentration3Wert + " ppm", 705, 820);
  text("40 ppm", 765, 820);
  text("?? ppm", 825, 820);
  stroke(0);
  textSize(20);
}



public void KonzProMl(){
  textSize(20);
  text("Bevor du kalibrieren kannst, fülle bitte die folgenden Felder aus:", 20, 50);
  textSize(18);
  text("1. Um wieviel ppm erhöht sich die Konzentration in der Messkammer pro eingespritzten ml?", 100, 120);
  
  text("2. Welche 5 Konzentrationen möchtest du für die Kalibrierung verwenden? Trage sie in aufsteigender\nReihenfolge ein.\nBeachte: 0ppm und 40ppm musst du auf jeden Fall messen!", 100, 250);
  textSize(25);
  text("ppm/ml", 525, 175);
  
  
  text("1:", 350, 370);
  text("2:", 350, 420);
  text("3:", 350, 470);
  text("4:", 350, 520);
  text("5:", 350, 570);
  
  text("0    ppm", 410, 370);
  text("ppm", 458, 420);
  text("ppm", 458, 470);
  text("ppm", 458, 520);
  
  text("40  ppm", 408, 570);
  
  
  if(mouseX > 400 && mouseX < 630 && mouseY > 700 && mouseY < 750){
    fill(255);
  }else{
   fill(220); 
  }
  rect(400, 700, 180, 50);
  fill(0);
  textSize(20);
  text("Messung starten", 410, 730);
  
}
float[] Outputs = new float[anzahlKonzentrationen*anzahlZyklen];

public void Speichern() {
  for (int i = 0; i < anzahlZyklen*anzahlKonzentrationen; i++) {
    float max = 0;
    float min = 999999999;
    float slope = 0;
    float mean = 0;



    for (int j = 0; j < 50; j++) {
      if (j >= GrenzeMaximumLinks && j <GrenzeMaximumLinks + 6) {
        if (max < Messdaten[i][j]) {
          max = Messdaten[i][j];
          MerkmalMaximum[i] = Messdaten[i][j];
        }
      }

      if (j >= GrenzeMinimumLinks && j <GrenzeMinimumLinks + 6) {
        if (min > Messdaten[i][j]) {
          min = Messdaten[i][j];
          MerkmalMinimum[i] = Messdaten[i][j];
        }
      }
    }

    slope = (-Messdaten[i][GrenzeSteigungLinks] + Messdaten[i][GrenzeSteigungLinks + 6])/6;
    MerkmalSteigung[i] = slope;

    for (int j = 0; j < 6; j++) {
      mean += Messdaten[i][GrenzeMittelwertLinks+j];
    }
    mean = mean/6;
    MerkmalMittelwert[i] = mean;
  }




  for (int j = 0; j < 50; j++) {
    if (j >= GrenzeMaximumLinks && j <GrenzeMaximumLinks + 6) {
      if (MerkmalMaximumUnbekannt < UnbekannteKonzentrationMessdaten[0][j]) {
        MerkmalMaximumUnbekannt = UnbekannteKonzentrationMessdaten[0][j];
      }
    }

    if (j >= GrenzeMinimumLinks && j <GrenzeMinimumLinks + 6) {
      if (MerkmalMinimumUnbekannt > UnbekannteKonzentrationMessdaten[0][j]) {
        MerkmalMinimumUnbekannt = UnbekannteKonzentrationMessdaten[0][j];
      }
    }
  }

  float mean = 0;
 
  for (int j = 0; j < 6; j++) {
    mean += UnbekannteKonzentrationMessdaten[0][GrenzeMittelwertLinks+j];
  }
  mean = mean/6;
  MerkmalMittelwertUnbekannt = mean;
  MerkmalSteigungUnbekannt = (-UnbekannteKonzentrationMessdaten[0][GrenzeSteigungLinks] + UnbekannteKonzentrationMessdaten[0][GrenzeSteigungLinks + 6])/6;







  String[] Training = new String[anzahlKonzentrationen*anzahlZyklen];
  for (int i = 0; i< anzahlKonzentrationen*anzahlZyklen; i++) {
    Training[i] = "";
  }
  Training[0] = "let max = false; let min = false; let slope = false; let mean = false; let training_data = [";
  if (MaxAktiv && MinAktiv) {

    for (int i = 0; i < anzahlKonzentrationen*anzahlZyklen; i++) {
      Training[i] = Training[i] + "{inputs: [" + MerkmalMaximum[i] + "," + MerkmalMinimum[i] + "], outputs:[" + Outputs[i] + "]},";
    }
    Training[anzahlKonzentrationen*anzahlZyklen-1] = Training[anzahlKonzentrationen*anzahlZyklen - 1] + "]; max = true; min = true;";
  } else if (MaxAktiv && SteigAktiv) {
    for (int i = 0; i < anzahlKonzentrationen*anzahlZyklen; i++) {
      Training[i] = Training[i] + "{inputs: [" + MerkmalMaximum[i] + "," + MerkmalSteigung[i] + "], outputs:[" + Outputs[i] + "]},";
    }
    Training[anzahlKonzentrationen*anzahlZyklen-1] = Training[anzahlKonzentrationen*anzahlZyklen - 1] + "]; max = true; slope = true;";
  } else if (MaxAktiv && MWAktiv) {
    for (int i = 0; i < anzahlKonzentrationen*anzahlZyklen; i++) {
      Training[i] = Training[i] + "{inputs: [" + MerkmalMaximum[i] + "," + MerkmalMittelwert[i] + "], outputs:[" + Outputs[i] + "]},";
    }
    Training[anzahlKonzentrationen*anzahlZyklen-1] = Training[anzahlKonzentrationen*anzahlZyklen - 1] + "]; max = true; mean = true;";
  } else if (MinAktiv && SteigAktiv) {
    for (int i = 0; i < anzahlKonzentrationen*anzahlZyklen; i++) {
      Training[i] = Training[i] + "{inputs: [" + MerkmalMinimum[i] + "," + MerkmalSteigung[i] + "], outputs:[" + Outputs[i] + "]},";
    }
    Training[anzahlKonzentrationen*anzahlZyklen-1] = Training[anzahlKonzentrationen*anzahlZyklen - 1] + "]; min = true; slope = true;";
  } else if (MinAktiv && MWAktiv) {
    for (int i = 0; i < anzahlKonzentrationen*anzahlZyklen; i++) {
      Training[i] = Training[i] + "{inputs: [" + MerkmalMinimum[i] + "," + MerkmalMittelwert[i] + "], outputs:[" + Outputs[i] + "]},";
    }
    Training[anzahlKonzentrationen*anzahlZyklen-1] = Training[anzahlKonzentrationen*anzahlZyklen - 1] + "]; min = true; mean = true;";
  } else if (SteigAktiv && MWAktiv) {
    for (int i = 0; i < anzahlKonzentrationen*anzahlZyklen; i++) {
      Training[i] = Training[i] + "{inputs: [" + MerkmalSteigung[i] + "," + MerkmalMittelwert[i] + "], outputs:[" + Outputs[i] + "]},";
    }
    Training[anzahlKonzentrationen*anzahlZyklen-1] = Training[anzahlKonzentrationen*anzahlZyklen - 1] + "]; slope = true; mean = true;";
  }
  saveStrings("lib/Trainingsdaten.js", Training);
}
//- Mittelwertsanzeige falsch?
//- inputs ppmpromol integriere
//- inputs beschränken
  public void settings() {  size(1050, displayHeight); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "Kalibrierungssoftware" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
